/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactDoubleList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBaseMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.util.Objects;

public final class OlapFactDoubleMemMapList
extends OlapFactBaseMemMapList<DoubleBuffer>
implements IOlapFactDoubleList {
    private OlapFactDoubleMemMapList(OlapFactMemMapListConfiguration configuration) {
        super(configuration);
    }

    public static IOlapFactDoubleList create(OlapFactMemMapListConfiguration configuration) {
        return new OlapFactDoubleMemMapList(configuration);
    }

    @Override
    protected String getFriendlyTypeName() {
        return "double";
    }

    @Override
    public int getValueByteCount() {
        return 8;
    }

    protected DoubleBuffer[] createBuffers(int count) {
        return new DoubleBuffer[count];
    }

    @Override
    protected DoubleBuffer createBuffer(MappedByteBuffer buffer) {
        return buffer.asDoubleBuffer();
    }

    @Override
    public void add(double val) {
        this.ensureCapacity();
        ((DoubleBuffer)this.currentBuffer).put(this.currentBufferPos++, val);
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Double)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactDoubleMemMapList this$0;
            {
                OlapFactDoubleMemMapList olapFactDoubleMemMapList = this$0;
                Objects.requireNonNull(olapFactDoubleMemMapList);
                this.this$0 = olapFactDoubleMemMapList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Double[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Double.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    @Override
    public void setQuick(int offset, double val) {
        ((DoubleBuffer[])this.buffers)[offset >> this.bufferItemCountBits].put(offset & this.bufferItemCountMask, val);
    }

    @Override
    public double getQuick(int rowId) {
        return ((DoubleBuffer[])this.buffers)[rowId >> this.bufferItemCountBits].get(rowId & this.bufferItemCountMask);
    }

    @Override
    public int lookup(double lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startBufferIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < ((DoubleBuffer[])this.buffers).length; ++idx) {
            DoubleBuffer buffer = ((DoubleBuffer[])this.buffers)[idx];
            int limit = buffer.limit();
            for (int pageIdx = startBufferIdx; rowId < this.size && pageIdx < limit; ++rowId, ++pageIdx) {
                double value = buffer.get(pageIdx);
                if (lookupValue != value) continue;
                return rowId;
            }
            startBufferIdx = 0;
        }
        return -1;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, double val) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        DoubleBuffer values = ((DoubleBuffer[])this.buffers)[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            double value = values.get(rowId & this.bufferItemCountMask);
            if (value == Double.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        double value = this.getQuick(rowId);
        if (value != Double.NEGATIVE_INFINITY) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int bufferNumber, int startOffset, int endOffset) {
        DoubleBuffer buffer = ((DoubleBuffer[])this.buffers)[bufferNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            double value = buffer.get(offset);
            if (value == Double.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void addValues(ByteBuffer buffer) {
        DoubleBuffer typedBuffer = ((DoubleBuffer[])this.buffers)[((DoubleBuffer[])this.buffers).length - 1];
        typedBuffer.rewind();
        typedBuffer.put(buffer.asDoubleBuffer());
    }
}

