/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactDateTimeList;
import crazydev.iccube.olap.facts.column.memlist.date.OlapFactDateTimePaginatedListHelper;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactLongMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class OlapFactDateTimeMemMapList
extends OlapFactMemMapList
implements IOlapFactDateTimeList {
    private final OlapFactDateTimePaginatedListHelper underlying;

    public OlapFactDateTimeMemMapList(OlapFactMemMapListConfiguration configuration) {
        this.underlying = new OlapFactDateTimePaginatedListHelper(OlapFactLongMemMapList.create(configuration));
        if (configuration != null && OlapLoggers.FACTS.isDebugEnabled()) {
            OlapLoggers.FACTS.debug((Object)("MDX facts : mmap file configuration [" + configuration.getColumnName() + "] [date]"));
        }
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.underlying.cleanupResources(cleaner);
    }

    @Override
    public int getBufferItemCount() {
        return this.underlying.getLocalMillis().getBufferItemCount();
    }

    @Override
    public int getBufferCount() {
        return this.underlying.getLocalMillis().getBufferCount();
    }

    @Override
    public long sizeOf() {
        return 0L;
    }

    @Override
    public long sizeOfFiles() {
        return this.underlying.sizeOfFiles();
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public LocalDateTime getQuick(int rowId) {
        return this.underlying.getQuick(rowId);
    }

    @Override
    public void setQuick(int rowId, @Nullable LocalDateTime value) {
        this.underlying.setQuick(rowId, value);
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, @Nullable LocalDateTime value) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void add(@Nullable LocalDateTime val) {
        this.underlying.add(val);
    }

    @Override
    public void trimToSize() {
        this.underlying.trimToSize();
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        this.underlying.aggregatePoints(aggregator, rowIds, len);
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        this.underlying.aggregatePoint(aggregator, rowId);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        this.underlying.aggregateRange(aggregator, startRowId, endRowId);
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        return this.underlying.lookup(lookupValue, start);
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.underlying.save(context, out);
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.underlying.restore(context, in);
    }

    @Override
    public long getQuickDateTimeMillis(int rowId) {
        return this.underlying.getQuickMillis(rowId);
    }
}

