/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactByteList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBaseMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactDoubleMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactFloatMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public class OlapFactByteMemMapList
extends OlapFactBaseMemMapList<ByteBuffer>
implements IOlapFactByteList {
    private OlapFactByteMemMapList(OlapFactMemMapListConfiguration configuration) {
        super(configuration);
    }

    public static IOlapFactByteList create(OlapFactMemMapListConfiguration configuration) {
        return new OlapFactByteMemMapList(configuration);
    }

    @Override
    protected String getFriendlyTypeName() {
        return "byte";
    }

    @Override
    public int getValueByteCount() {
        return 1;
    }

    protected ByteBuffer[] createBuffers(int count) {
        return new ByteBuffer[count];
    }

    @Override
    protected ByteBuffer createBuffer(MappedByteBuffer buffer) {
        return buffer;
    }

    @Override
    public void add(byte val) {
        this.ensureCapacity();
        ((ByteBuffer)this.currentBuffer).put(this.currentBufferPos++, val);
        ++this.size;
    }

    @Override
    public void setQuick(int offset, byte val) {
        ((ByteBuffer[])this.buffers)[offset >> this.bufferItemCountBits].put(offset & this.bufferItemCountMask, val);
    }

    @Override
    public void add(byte[] values) {
        if (values.length == 0) {
            return;
        }
        int offset = 0;
        while (offset < values.length) {
            int written = this.write(values, offset);
            if (written > 0) {
                offset += written;
                continue;
            }
            this.addBuffer();
        }
        this.size += values.length;
    }

    private int write(byte[] values, int offset) {
        int availableWriteLen;
        if (offset >= values.length) {
            return 0;
        }
        int n = availableWriteLen = this.currentBufferPos != -1 ? this.bufferItemCount - this.currentBufferPos : 0;
        if (availableWriteLen <= 0) {
            return 0;
        }
        int toWriteLen = values.length - offset;
        int canWriteLen = toWriteLen >= availableWriteLen ? availableWriteLen : toWriteLen;
        if (this.currentBuffer == null) {
            throw new CdProgrammingException("internal error: missing current buffer!");
        }
        ((ByteBuffer)this.currentBuffer).position(this.currentBufferPos);
        ((ByteBuffer)this.currentBuffer).put(values, offset, canWriteLen);
        this.currentBufferPos += canWriteLen;
        return canWriteLen;
    }

    @Override
    public byte getQuick(int rowId) {
        return ((ByteBuffer[])this.buffers)[rowId >> this.bufferItemCountBits].get(rowId & this.bufferItemCountMask);
    }

    @Override
    public byte[] getQuick(int startRowId, byte eos) {
        int endRowId = this.lookup(eos, startRowId);
        if (endRowId < startRowId) {
            throw new CdProgrammingException("internal error: missing EOS marker");
        }
        byte[] bytes = new byte[endRowId - startRowId];
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        int bytesOffset = this.doGetQuick(bytes, 0, startPageNb, startPageOffset, startPageNb == endPageNb ? endPageOffset : this.bufferItemCount);
        for (int pageNb = startPageNb + 1; pageNb < endPageNb; ++pageNb) {
            bytesOffset += this.doGetQuick(bytes, bytesOffset, pageNb, 0, this.bufferItemCount);
        }
        if (endPageNb > startPageNb && endPageOffset != 0) {
            this.doGetQuick(bytes, bytesOffset, endPageNb, 0, endPageOffset);
        }
        return bytes;
    }

    private int doGetQuick(byte[] bytes, int bytesOffset, int pageNb, int from, int to) {
        int len = to - from;
        ByteBuffer buffer = ((ByteBuffer[])this.buffers)[pageNb];
        for (int ii = 0; ii < len; ++ii) {
            bytes[bytesOffset + ii] = buffer.get(from + ii);
        }
        return len;
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        byte value = this.getQuick(rowId);
        aggregator.aggregate(value);
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        ByteBuffer values = ((ByteBuffer[])this.buffers)[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            byte value = values.get(rowId & this.bufferItemCountMask);
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int bufferNumber, int startOffset, int endOffset) {
        ByteBuffer buffer = ((ByteBuffer[])this.buffers)[bufferNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            byte value = buffer.get(offset);
            aggregator.aggregate(value);
        }
    }

    public void copy(OlapFactDoubleMemMapList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < ((ByteBuffer[])this.buffers).length; ++bb) {
            ByteBuffer buffer = ((ByteBuffer[])this.buffers)[bb];
            int limit = buffer.limit();
            for (int ii = 0; row < this.size && ii < limit; ++row, ++ii) {
                to.add(buffer.get(ii));
            }
        }
    }

    public void copy(OlapFactFloatMemMapList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < ((ByteBuffer[])this.buffers).length; ++bb) {
            ByteBuffer buffer = ((ByteBuffer[])this.buffers)[bb];
            int limit = buffer.limit();
            for (int ii = 0; row < this.size && ii < limit; ++row, ++ii) {
                to.add(buffer.get(ii));
            }
        }
    }

    @Override
    public int lookup(byte lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int bufferStart = start >> this.bufferItemCountBits;
        int bufferStartOffset = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = bufferStart; idx < ((ByteBuffer[])this.buffers).length; ++idx) {
            ByteBuffer buffer = ((ByteBuffer[])this.buffers)[idx];
            int limit = buffer.limit();
            for (int pageIdx = bufferStartOffset; rowId < this.size && pageIdx < limit; ++rowId, ++pageIdx) {
                byte value = buffer.get(pageIdx);
                if (lookupValue != value) continue;
                return rowId;
            }
            bufferStartOffset = 0;
        }
        return -1;
    }

    @Override
    public void createZeroBuffers(int bufferCount) {
        byte[] values = new byte[this.bufferItemCount];
        for (int ii = 0; ii < bufferCount; ++ii) {
            this.add(values);
        }
        this.trimToSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getQuick(byte[] dest, int destPos, int startRowId, int len) {
        ByteBuffer buffer;
        int endRowId = startRowId + len;
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        if (startPageNb != endPageNb && (endPageNb - startPageNb != 1 || endPageOffset != 0)) {
            throw new CdProgrammingException("internal error: unexpected len (crossing buffer boundary)");
        }
        ByteBuffer byteBuffer = buffer = ((ByteBuffer[])this.buffers)[startPageNb];
        synchronized (byteBuffer) {
            buffer.position(startPageOffset);
            buffer.get(dest, destPos, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQuick(int startRowId, byte[] values, int valuesPos, int valuesLen) {
        ByteBuffer buffer;
        int endRowId = startRowId + valuesLen;
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        if (startPageNb != endPageNb && (endPageNb - startPageNb != 1 || endPageOffset != 0)) {
            throw new CdProgrammingException("internal error: unexpected len (crossing buffer boundary)");
        }
        ByteBuffer byteBuffer = buffer = ((ByteBuffer[])this.buffers)[startPageNb];
        synchronized (byteBuffer) {
            buffer.position(startPageOffset);
            buffer.put(values, valuesPos, valuesLen);
        }
    }

    @Override
    protected void addValues(ByteBuffer buffer) {
        throw new RuntimeException("internal error: inconsistent usage of mmap. byte list");
    }
}

