/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactBoolList;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBoolPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.bool.OlapFactBooleanPaginatedListHelper;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactLongMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;

public class OlapFactBoolMemMapList
extends OlapFactMemMapList
implements IOlapFactBoolList {
    private final IOlapFactLongList underlying;
    private int size;

    public OlapFactBoolMemMapList(OlapFactMemMapListConfiguration configuration) {
        this.underlying = OlapFactLongMemMapList.create(configuration != null ? configuration.copyForBooleanValues() : null);
        if (configuration != null && OlapLoggers.FACTS.isDebugEnabled()) {
            OlapLoggers.FACTS.debug((Object)("MDX facts : mmap file configuration [" + configuration.getColumnName() + "] [boolean]"));
        }
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.underlying.cleanupResources(cleaner);
    }

    @Override
    public int getBufferItemCount() {
        return 0;
    }

    @Override
    public int getBufferCount() {
        return this.underlying.getBufferCount();
    }

    @Override
    public long sizeOf() {
        return 0L;
    }

    @Override
    public long sizeOfFiles() {
        return this.underlying.sizeOfFiles();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean getQuick(int rowId) {
        return OlapFactBooleanPaginatedListHelper.get(this.underlying, rowId);
    }

    public void setNew(int rowId, Boolean val) {
        this.size = Math.max(rowId + 1, this.size);
        this.ensureCapacity(rowId);
        OlapFactBooleanPaginatedListHelper.set(this.underlying, rowId, val);
    }

    @Override
    public void add(boolean val) {
        OlapFactBooleanPaginatedListHelper.add(this.underlying, val, this.size);
        ++this.size;
    }

    @Override
    public void setQuick(int rowId, boolean val) {
        OlapFactBooleanPaginatedListHelper.set(this.underlying, rowId, val);
    }

    private void ensureCapacity(int rowId) {
        this.underlying.ensureCapacity(OlapFactBooleanPaginatedListHelper.sizeForLong(rowId));
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, boolean fact) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void trimToSize() {
        this.underlying.trimToSize();
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        aggregator.aggregate(OlapBooleanEntity.value(this.getQuick(rowId)));
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        for (int ii = startRowId; ii < endRowId; ++ii) {
            this.aggregatePoint(aggregator, ii);
        }
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.size);
        this.underlying.save(context, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.size = in.readInt();
        if (context.isVersion0()) {
            IOlapFactLongList nulls = this.underlying.createForBooleanNulls();
            try {
                OlapFactBoolPaginatedList.restoreForVersion0(context, in, nulls, this.underlying);
            }
            finally {
                nulls.cleanupResources(context.getFileCleaner());
            }
            return;
        }
        this.underlying.restore(context, in);
    }
}

