/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist.utf8;

import crazydev.common.collection.CdCharArrayList;
import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdCharUtils;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.jetbrains.annotations.Nullable;

public class OlapFactCharStringPaginatedListHelper {
    private static final char CHAR_ZERO = '\u0c80';
    private final CdCharArrayList array = new CdCharArrayList();
    private final IntArrayList positions = new IntArrayList();

    public void addNewValue(@Nullable String name) {
        this.positions.add(this.array.size());
        if (name != null) {
            char[] asChars = name.toCharArray();
            this.array.add(asChars);
        } else {
            this.array.add('\udc80');
        }
        this.array.add('\u0c80');
    }

    public String getValueAsObject(int dataHandlerIdx) {
        int pos = this.positions.getInt(dataHandlerIdx);
        int size = this.array.getLength(pos, '\u0c80');
        if (size == 1 && this.array.getData()[pos] == '\udc80') {
            return null;
        }
        return new String(this.array.getData(), pos, size);
    }

    public int hashCode(int dataHandlerIdx) {
        int pos = this.positions.getInt(dataHandlerIdx);
        int size = this.array.getLength(pos, '\u0c80');
        if (size == 1 && this.array.getData()[pos] == '\udc80') {
            return -1;
        }
        char[] data = this.array.getData();
        int hashcode = Character.hashCode(data[pos]);
        int i = pos + 1;
        while (pos < size) {
            hashcode += OlapFactCharStringPaginatedListHelper.literalLengthMultiplication(Character.hashCode(data[i]));
            ++pos;
        }
        return hashcode;
    }

    private static int literalLengthMultiplication(int n) {
        return (n << 5) - n;
    }

    public void trimToSize() {
        this.array.trimToSize();
        this.positions.trim();
    }

    public long sizeOf() {
        return 0L;
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    public int size() {
        return this.positions.size();
    }

    public int lookup(Comparable lookupValue, int start) {
        int size = this.positions.size();
        if (start < 0 || start >= size || !(lookupValue instanceof String)) {
            return -1;
        }
        String lookupString = (String)((Object)lookupValue);
        for (int idx = start; idx < size; ++idx) {
            int pos;
            char[] data = this.array.getData();
            if (!OlapFactCharStringPaginatedListHelper.equals(lookupString, data, pos = this.positions.getInt(idx))) continue;
            return idx;
        }
        return -1;
    }

    public int binarySearchIgnoreCase(CdPaginatedIntList sortList, String lookupName) {
        int low = 0;
        int high = sortList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int misKeySortedIdx = sortList.getInt(mid);
            int pos = this.positions.getInt(misKeySortedIdx);
            int comp = this.compareToIgnoreCase(lookupName, pos);
            if (comp > 0) {
                low = mid + 1;
                continue;
            }
            if (comp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    private int compareToIgnoreCase(String lookup, int pos) {
        char[] data = this.array.getData();
        int lookupLength = lookup.length();
        int i = 0;
        while (i < lookupLength) {
            char c1 = lookup.charAt(i);
            if (pos >= data.length) {
                return 1;
            }
            char c2 = data[pos];
            if (c2 == '\u0c80') {
                return 1;
            }
            int cmp = CdCharUtils.compareToIgnoreCase((char)c1, (char)c2);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            ++pos;
        }
        if (pos >= data.length) {
            return -1;
        }
        if (data[pos] == '\u0c80') {
            return 0;
        }
        return -1;
    }

    public int binarySearch(CdPaginatedIntList sortList, Comparable compKey, @Nullable IOlapFactExtraComparator extraComparator) {
        if (compKey instanceof String) {
            char[] value = ((String)((Object)compKey)).toCharArray();
            int low = 0;
            int high = sortList.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int misKeySortedIdx = sortList.getInt(mid);
                int pos = this.positions.getInt(misKeySortedIdx);
                int comp = this.compareTo(value, pos);
                if (comp == 0 && extraComparator != null) {
                    comp = extraComparator.compareOtherColumns(misKeySortedIdx);
                }
                if (comp > 0) {
                    low = mid + 1;
                    continue;
                }
                if (comp < 0) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low - 1;
        }
        return Integer.MIN_VALUE;
    }

    public char[] getChars(String value) {
        return value.toCharArray();
    }

    public int compareToValueForCompare(char[] value, int rowId) {
        int pos = this.positions.getInt(rowId);
        return this.compareTo(value, pos);
    }

    private int compareTo(char[] lookupValue, int pos) {
        char[] data = this.array.getData();
        if (lookupValue == null) {
            return data[pos] == '\u0c80' ? 0 : -1;
        }
        int i = 0;
        while (i < lookupValue.length) {
            char v = lookupValue[i];
            char c = data[pos];
            int comp = v - c;
            if (comp != 0) {
                return c == '\u0c80' ? 1 : comp;
            }
            ++i;
            ++pos;
        }
        return data[pos] == '\u0c80' ? 0 : -1;
    }

    private static boolean equals(String lookupString, char[] data, int pos) {
        int thisStringPos = pos;
        int lookupStringLen = lookupString.length();
        for (int lookupStringPos = 0; lookupStringPos < lookupStringLen; ++lookupStringPos) {
            char c2;
            char c1 = lookupString.charAt(lookupStringPos);
            char c = c2 = thisStringPos < data.length ? data[thisStringPos++] : (char)'\u0c80';
            if (c1 == c2) continue;
            return false;
        }
        return thisStringPos < data.length && data[thisStringPos] == '\u0c80';
    }

    public void setValueAsObject(int rowId, String value) {
        throw new CdProgrammingException("internal error: operation not supported");
    }

    public boolean equalsIgnoreCase(int rowId, String name) {
        return this.compareToIgnoreCase(name, this.positions.getInt(rowId)) == 0;
    }
}

