/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.olap.OlapConfiguration;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactIntList;
import crazydev.iccube.olap.facts.column.list.IOlapFactList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedList;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public abstract class OlapFactVectorPaginatedList<DATA extends IOlapFactList>
extends OlapFactPaginatedList {
    private static final int LIST_MAX_SIZE = Integer.MAX_VALUE;
    private static final int LIST_MAX_ITEMS = OlapConfiguration.LIST_VECTOR_LIMIT_ITEMS;
    private static final int VECTOR_MAX_ITEMS = Integer.MAX_VALUE - LIST_MAX_ITEMS;
    private final IOlapFactListFactory listFactory;
    private final IOlapFactColumn column;
    private int[] pageStartPositions;
    private IOlapFactIntList[] positions;
    private DATA[] data;

    public OlapFactVectorPaginatedList(IOlapFactListFactory listFactory, IOlapFactColumn column) {
        this.listFactory = listFactory;
        this.column = column;
        this.pageStartPositions = new int[]{0};
        this.positions = new IOlapFactIntList[]{listFactory.createIntList(column, "vector-positions")};
        this.positions[0].add(0);
        this.data = this.createData(1);
        this.data[0] = this.createDataList(listFactory, column, 0);
    }

    public IOlapFactListFactory getListFactory() {
        return this.listFactory;
    }

    public IOlapFactColumn getColumn() {
        return this.column;
    }

    protected abstract DATA[] createData(int var1);

    public int getBufferItemCount() {
        return 0;
    }

    public int getBufferCount() {
        return 0;
    }

    public boolean isNull(int rowId) {
        Boolean value = (Boolean)this.getEntity(Kind.NULL, rowId);
        return value;
    }

    protected int getPage(int rowId) {
        if (this.pageStartPositions.length == 1) {
            return 0;
        }
        int idx = Arrays.binarySearch(this.pageStartPositions, rowId);
        return idx >= 0 ? idx : -idx - 2;
    }

    @Nullable
    private IOlapDoubleValueIterable getDoubleValueIterable(int rowId) {
        IOlapDoubleValueIterable vector = (IOlapDoubleValueIterable)this.getEntity(Kind.ITERABLE, rowId);
        return vector;
    }

    protected abstract IOlapDoubleValueIterable getVector(DATA var1, int var2, int var3);

    @Nullable
    public Comparable getComparable(int rowId) {
        Comparable vector = (Comparable)this.getEntity(Kind.COMPARABLE, rowId);
        return vector;
    }

    protected abstract Comparable getComparable(DATA var1, int var2, int var3);

    @Nullable
    private Object getEntity(Kind kind, int rowId) {
        int pageIndex = this.getPage(rowId);
        int pageRowId = rowId - this.pageStartPositions[pageIndex];
        IOlapFactIntList pagePositions = this.positions[pageIndex];
        int pagePosition = pagePositions.getQuick(pageRowId);
        int nextPagePosition = pagePositions.getQuick(pageRowId + 1);
        if (kind == Kind.NULL) {
            return pagePosition == nextPagePosition;
        }
        if (pagePosition == nextPagePosition) {
            return null;
        }
        DATA pageData = this.data[pageIndex];
        switch (kind.ordinal()) {
            case 0: {
                return this.getVector(pageData, pagePosition, nextPagePosition);
            }
            case 1: {
                return this.getComparable(pageData, pagePosition, nextPagePosition);
            }
        }
        throw new RuntimeException("internal error: inconsistent vector list usage");
    }

    public void add(CdComparableArray values) {
        int lastPageIndex = this.positions.length - 1;
        IOlapFactIntList lastPagePositions = this.positions[lastPageIndex];
        DATA lastPageData = this.data[lastPageIndex];
        if (values == null) {
            lastPagePositions.add(lastPageData.size());
            return;
        }
        if (values.size() > VECTOR_MAX_ITEMS) {
            throw new RuntimeException("internal error: unsupported vector size [" + values.size() + "] [max:" + VECTOR_MAX_ITEMS + "]");
        }
        this.addVector(lastPageData, values);
        lastPagePositions.add(lastPageData.size());
        if (lastPageData.size() > LIST_MAX_ITEMS) {
            this.positions = Arrays.copyOf(this.positions, this.positions.length + 1);
            this.data = (IOlapFactList[])Arrays.copyOf(this.data, this.data.length + 1);
            this.pageStartPositions = Arrays.copyOf(this.pageStartPositions, this.pageStartPositions.length + 1);
            this.pageStartPositions[this.pageStartPositions.length - 1] = this.pageStartPositions[this.pageStartPositions.length - 2] + this.positions[this.pageStartPositions.length - 2].size() - 1;
            this.positions[this.positions.length - 1] = this.listFactory.createIntList(this.column);
            this.positions[this.positions.length - 1].add(0);
            this.data[this.data.length - 1] = this.createDataList(this.listFactory, this.column, this.data.length);
        }
    }

    protected abstract void addVector(DATA var1, CdComparableArray var2);

    protected abstract DATA createDataList(IOlapFactListFactory var1, IOlapFactColumn var2, int var3);

    public long sizeOf() {
        int i;
        long size = this.shallowSizeOf();
        for (i = 0; i < this.positions.length; ++i) {
            size += this.positions[i].sizeOf();
        }
        for (i = 0; i < this.data.length; ++i) {
            size += this.data[i].sizeOf();
        }
        return size;
    }

    protected abstract long shallowSizeOf();

    public long sizeOfFiles() {
        int ii;
        long size = 0L;
        for (ii = 0; ii < this.positions.length; ++ii) {
            size += this.positions[ii].sizeOfFiles();
        }
        for (ii = 0; ii < this.data.length; ++ii) {
            size += this.data[ii].sizeOfFiles();
        }
        return size;
    }

    public int size() {
        int size = 0;
        for (int ii = 0; ii < this.positions.length; ++ii) {
            size += this.positions[ii].size() - 1;
        }
        return size;
    }

    public void cleanupResources(OlapFileCleaner cleaner) {
        int ii;
        for (ii = 0; ii < this.positions.length; ++ii) {
            this.positions[ii].cleanupResources(cleaner);
        }
        for (ii = 0; ii < this.data.length; ++ii) {
            this.data[ii].cleanupResources(cleaner);
        }
    }

    public void trimToSize() {
        int ii;
        for (ii = 0; ii < this.positions.length; ++ii) {
            this.positions[ii].trimToSize();
        }
        for (ii = 0; ii < this.data.length; ++ii) {
            this.data[ii].trimToSize();
        }
    }

    public boolean isEmpty() {
        return this.positions.length == 0 || this.positions[0].size() <= 1;
    }

    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        for (int rowId = startRowId; rowId < endRowId; ++rowId) {
            this.aggregatePoint(aggregator, rowId);
        }
    }

    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        IOlapDoubleValueIterable value = this.getDoubleValueIterable(rowId);
        if (value != null) {
            aggregator.aggregate(value);
        }
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        if (context.isCancelling()) {
            return;
        }
        out.writeInt(this.pageStartPositions == null ? -1 : this.pageStartPositions.length);
        if (this.pageStartPositions != null) {
            out.writeInts(this.pageStartPositions);
        }
        out.writeInt(this.positions == null ? -1 : this.positions.length);
        if (this.positions != null) {
            for (IOlapFactIntList list : this.positions) {
                list.save(context, out);
            }
        }
        out.writeInt(this.data == null ? -1 : this.data.length);
        if (this.data != null) {
            for (IOlapFactIntList dataPage : this.data) {
                dataPage.save(context, out);
            }
        }
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int dataLen;
        int positionsLen;
        if (context.isCancelling()) {
            return;
        }
        int pageStartPositionsLen = in.readInt();
        if (pageStartPositionsLen != -1) {
            this.pageStartPositions = new int[pageStartPositionsLen];
            in.readInts(this.pageStartPositions);
        }
        if ((positionsLen = in.readInt()) != -1) {
            this.positions = new IOlapFactIntList[positionsLen];
            for (int ii = 0; ii < this.positions.length; ++ii) {
                this.positions[ii] = this.listFactory.createIntList(this.column);
                this.positions[ii].restore(context, in);
            }
        }
        if ((dataLen = in.readInt()) != -1) {
            this.data = this.createData(dataLen);
            for (int ii = 0; ii < this.data.length; ++ii) {
                this.data[ii] = this.createDataList(this.listFactory, this.column, ii);
                this.data[ii].restore(context, in);
            }
        }
    }

    static enum Kind {
        ITERABLE,
        COMPARABLE,
        NULL;

    }
}

