/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBasePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactDoublePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactFloatPaginatedList;
import java.io.IOException;
import java.nio.LongBuffer;
import java.util.Objects;

public class OlapFactLongPaginatedList
extends OlapFactBasePaginatedList<long[], LongBuffer>
implements IOlapFactLongList {
    private static long SHALLOW_SIZE_OF = -1L;
    private long[][] buffers;
    private int currentBuffer;
    private int currentBufferPos;
    private int size;
    private Object LOCK = new Object();

    public OlapFactLongPaginatedList(int bits) {
        super(bits);
        this.buffers = new long[1][];
        this.buffers[0] = new long[this.bufferItemCount];
        this.currentBuffer = 0;
        this.currentBufferPos = 0;
    }

    @Override
    public IOlapFactLongList createForBooleanNulls() {
        return new OlapFactLongPaginatedList(this.bits);
    }

    @Override
    protected int getBufferItemCountBits(int bits) {
        return bits - 3;
    }

    @Override
    public int getBufferCount() {
        return this.buffers.length;
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.buffers);
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            size += CdRamUsageEstimator.sizeOf((long[])this.buffers[ii]);
        }
        return size;
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public long getQuick(int offset) {
        return this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask];
    }

    @Override
    public void add(long val) {
        this.ensureCapacity()[this.currentBufferPos++] = val;
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Long)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactLongPaginatedList this$0;
            {
                OlapFactLongPaginatedList olapFactLongPaginatedList = this$0;
                Objects.requireNonNull(olapFactLongPaginatedList);
                this.this$0 = olapFactLongPaginatedList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Long[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Long.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    private long[] ensureCapacity() {
        long[] buffer = this.buffers[this.currentBuffer];
        if (this.currentBufferPos < buffer.length) {
            return buffer;
        }
        if (buffer.length == this.bufferItemCount) {
            long[][] newBuffers = new long[this.buffers.length + 1][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            long[] lArray = new long[this.bufferItemCount];
            newBuffers[this.buffers.length] = lArray;
            long[] newBuffer = lArray;
            this.buffers = newBuffers;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = 0;
            return newBuffer;
        }
        long[] newBuffer = new long[this.bufferItemCount];
        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
        this.buffers[this.currentBuffer] = newBuffer;
        return newBuffer;
    }

    private long[] ensureCapacityMT(int currentBuffer) {
        long[] buffer;
        if (currentBuffer >= this.buffers.length) {
            this.expandBuffersMT(currentBuffer);
        }
        if ((buffer = this.buffers[currentBuffer]).length == this.bufferItemCount) {
            return buffer;
        }
        return this.expandBufferMT(currentBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] expandBufferMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            long[] buffer = this.buffers[currentBuffer];
            if (buffer.length == this.bufferItemCount) {
                return buffer;
            }
            long[] newBuffer = new long[this.bufferItemCount];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            this.buffers[currentBuffer] = newBuffer;
            return newBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] expandBuffersMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (currentBuffer >= this.buffers.length) {
                long[][] newBuffers = new long[currentBuffer + 1][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                for (int i = this.buffers.length; i < newBuffers.length; ++i) {
                    newBuffers[i] = new long[this.bufferItemCount];
                }
                this.buffers = newBuffers;
            }
            return this.buffers[currentBuffer];
        }
    }

    @Override
    public void trimToSize() {
        if (this.currentBufferPos == 0) {
            if (this.currentBuffer == 0) {
                return;
            }
            long[][] newPages = new long[this.buffers.length - 1][];
            System.arraycopy(this.buffers, 0, newPages, 0, newPages.length);
            this.buffers = newPages;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = this.buffers[this.currentBuffer].length;
            return;
        }
        if (this.currentBufferPos < this.bufferItemCount) {
            long[] newPage = new long[this.currentBufferPos];
            System.arraycopy(this.buffers[this.currentBuffer], 0, newPage, 0, newPage.length);
            this.buffers[this.currentBuffer] = newPage;
            return;
        }
    }

    @Override
    public void setQuick(int offset, long val) {
        this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask] = val;
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        long[] values = this.buffers[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            long value = values[rowId & this.bufferItemCountMask];
            if (value == Long.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        long value = this.getQuick(rowId);
        if (value != Long.MIN_VALUE) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int pageNumber, int startOffset, int endOffset) {
        long[] page = this.buffers[pageNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            long value = page[offset];
            if (value == Long.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    public void copy(OlapFactDoublePaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            long[] buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.length; ++row, ++ii) {
                to.add(buffer[ii]);
            }
        }
    }

    public void copy(OlapFactFloatPaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            long[] buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.length; ++row, ++ii) {
                to.add(buffer[ii]);
            }
        }
    }

    @Override
    public int lookup(long lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startPageIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < this.buffers.length; ++idx) {
            long[] page = this.buffers[idx];
            for (int pageIdx = startPageIdx; rowId < this.size && pageIdx < page.length; ++rowId, ++pageIdx) {
                long value = page[pageIdx];
                if (lookupValue != value) continue;
                return rowId;
            }
            startPageIdx = 0;
        }
        return -1;
    }

    @Override
    public void setNew(int offset, long val) {
        int currentBuffer = offset >> this.bufferItemCountBits;
        int currentBufferPos = offset & this.bufferItemCountMask;
        this.ensureCapacityMT((int)currentBuffer)[currentBufferPos] = val;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public long[] ensureCapacity(int offset) {
        int currentBuffer = offset >> this.bufferItemCountBits;
        return this.ensureCapacityMT(currentBuffer);
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.currentBuffer);
        out.writeInt(this.currentBufferPos);
        out.writeInt(this.size);
        out.writeInt(this.buffers == null ? -1 : this.buffers.length);
        if (this.buffers != null) {
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                long[] buffer = this.buffers[bb];
                out.writeInt(buffer == null ? -1 : buffer.length);
                if (buffer == null) continue;
                out.writeLongs(buffer);
            }
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.currentBuffer = in.readInt();
        this.currentBufferPos = in.readInt();
        this.size = in.readInt();
        int bufferCount = in.readInt();
        if (bufferCount > -1) {
            this.buffers = new long[bufferCount][];
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                int bufferLen = in.readInt();
                if (bufferLen <= -1) continue;
                this.buffers[bb] = new long[bufferLen];
                in.readLongs(this.buffers[bb]);
            }
        }
    }
}

