/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdArrays;
import crazydev.common.collection.CdComparableArray;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactDoubleList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBasePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactBytePaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactFloatPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactIntPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactLongPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactShortPaginatedList;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.Objects;

public class OlapFactDoublePaginatedList
extends OlapFactBasePaginatedList<double[], DoubleBuffer>
implements IOlapFactDoubleList {
    private static long SHALLOW_SIZE_OF = -1L;
    private double[][] buffers;
    private int currentBuffer;
    private int currentBufferPos;
    private int size;
    private Object LOCK = new Object();

    public OlapFactDoublePaginatedList(int bits) {
        super(bits);
        this.buffers = new double[1][];
        this.buffers[0] = new double[this.bufferItemCount];
        this.currentBuffer = 0;
        this.currentBufferPos = 0;
    }

    public OlapFactDoublePaginatedList(OlapFactDoublePaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactDoublePaginatedList(OlapFactLongPaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactDoublePaginatedList(OlapFactIntPaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactDoublePaginatedList(OlapFactShortPaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    public OlapFactDoublePaginatedList(OlapFactBytePaginatedList from) {
        this(from.bits);
        from.copy(this);
        this.trimToSize();
    }

    @Override
    protected int getBufferItemCountBits(int bits) {
        return bits - 3;
    }

    @Override
    public int getBufferCount() {
        return this.buffers.length;
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.buffers);
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            size += CdRamUsageEstimator.sizeOf((double[])this.buffers[ii]);
        }
        return size;
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public double getQuick(int rowId) {
        return this.buffers[rowId >> this.bufferItemCountBits][rowId & this.bufferItemCountMask];
    }

    @Override
    public void add(double val) {
        this.ensureCapacity();
        this.buffers[this.currentBuffer][this.currentBufferPos++] = val;
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Double)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactDoublePaginatedList this$0;
            {
                OlapFactDoublePaginatedList olapFactDoublePaginatedList = this$0;
                Objects.requireNonNull(olapFactDoublePaginatedList);
                this.this$0 = olapFactDoublePaginatedList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Double[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Double.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    private void ensureCapacity() {
        double[] buffer = this.buffers[this.currentBuffer];
        if (this.currentBufferPos < buffer.length) {
            return;
        }
        if (buffer.length == this.bufferItemCount) {
            double[][] newBuffers = new double[this.buffers.length + 1][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            newBuffers[this.buffers.length] = new double[this.bufferItemCount];
            this.buffers = newBuffers;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = 0;
            return;
        }
        double[] newBuffer = new double[this.bufferItemCount];
        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
        this.buffers[this.currentBuffer] = newBuffer;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int offset, double val) {
        int currentBuffer = offset >> this.bufferItemCountBits;
        int currentBufferPos = offset & this.bufferItemCountMask;
        this.ensureCapacityMT((int)currentBuffer)[currentBufferPos] = val;
    }

    private double[] ensureCapacityMT(int currentBuffer) {
        double[] buffer;
        if (currentBuffer >= this.buffers.length) {
            this.expandBuffersMT(currentBuffer);
        }
        if ((buffer = this.buffers[currentBuffer]).length == this.bufferItemCount) {
            return buffer;
        }
        return this.expandBufferMT(currentBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] expandBufferMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            double[] buffer = this.buffers[currentBuffer];
            if (buffer.length == this.bufferItemCount) {
                return buffer;
            }
            double[] newBuffer = new double[this.bufferItemCount];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            this.buffers[currentBuffer] = newBuffer;
            return newBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] expandBuffersMT(int currentBuffer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (currentBuffer >= this.buffers.length) {
                double[][] newBuffers = new double[currentBuffer + 1][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                for (int i = this.buffers.length; i < newBuffers.length; ++i) {
                    newBuffers[i] = new double[this.bufferItemCount];
                }
                this.buffers = newBuffers;
            }
            return this.buffers[currentBuffer];
        }
    }

    @Override
    public void trimToSize() {
        if (this.currentBufferPos == 0) {
            if (this.currentBuffer == 0) {
                return;
            }
            double[][] newPages = new double[this.buffers.length - 1][];
            System.arraycopy(this.buffers, 0, newPages, 0, newPages.length);
            this.buffers = newPages;
            this.currentBuffer = this.buffers.length - 1;
            this.currentBufferPos = this.buffers[this.currentBuffer].length;
            return;
        }
        if (this.currentBufferPos < this.bufferItemCount) {
            double[] newPage = new double[this.currentBufferPos];
            System.arraycopy(this.buffers[this.currentBuffer], 0, newPage, 0, newPage.length);
            this.buffers[this.currentBuffer] = newPage;
            return;
        }
    }

    @Override
    public void setQuick(int offset, double val) {
        this.buffers[offset >> this.bufferItemCountBits][offset & this.bufferItemCountMask] = val;
    }

    public void copy(OlapFactDoublePaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        to.buffers = CdArrays.copy((double[][])this.buffers);
        to.currentBufferPos = to.bufferItemCount;
        to.currentBuffer = to.buffers.length - 1;
        to.size = this.size;
    }

    public void copy(OlapFactFloatPaginatedList to) {
        if (this.isEmpty()) {
            return;
        }
        int row = 0;
        for (int bb = 0; bb < this.buffers.length; ++bb) {
            double[] buffer = this.buffers[bb];
            for (int ii = 0; row < this.size && ii < buffer.length; ++row, ++ii) {
                to.add((float)buffer[ii]);
            }
        }
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        double[] values = this.buffers[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            double value = values[rowId & this.bufferItemCountMask];
            if (value == Double.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        double value = this.getQuick(rowId);
        if (value != Double.NEGATIVE_INFINITY) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int pageNumber, int startOffset, int endOffset) {
        double[] page = this.buffers[pageNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            double value = page[offset];
            if (value == Double.NEGATIVE_INFINITY) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public int lookup(double lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startPageIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < this.buffers.length; ++idx) {
            double[] page = this.buffers[idx];
            for (int pageIdx = startPageIdx; rowId < this.size && pageIdx < page.length; ++rowId, ++pageIdx) {
                double value = page[pageIdx];
                if (lookupValue != value) continue;
                return rowId;
            }
            startPageIdx = 0;
        }
        return -1;
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.currentBuffer);
        out.writeInt(this.currentBufferPos);
        out.writeInt(this.size);
        out.writeInt(this.buffers == null ? -1 : this.buffers.length);
        if (this.buffers != null) {
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                double[] buffer = this.buffers[bb];
                out.writeInt(buffer == null ? -1 : buffer.length);
                if (buffer == null) continue;
                out.writeDoubles(buffer);
            }
        }
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.currentBuffer = in.readInt();
        this.currentBufferPos = in.readInt();
        this.size = in.readInt();
        int bufferCount = in.readInt();
        if (bufferCount > -1) {
            this.buffers = new double[bufferCount][];
            for (int bb = 0; bb < this.buffers.length; ++bb) {
                if (context.isCancelling()) {
                    return;
                }
                int bufferLen = in.readInt();
                if (bufferLen <= -1) continue;
                this.buffers[bb] = new double[bufferLen];
                in.readDoubles(this.buffers[bb]);
            }
        }
    }
}

