/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactDateTimeList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactLongPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.date.OlapFactDateTimePaginatedListHelper;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;

public class OlapFactDateTimePaginatedList
extends OlapFactPaginatedList
implements IOlapFactDateTimeList {
    private static long SHALLOW_SIZE_OF = -1L;
    private final OlapFactDateTimePaginatedListHelper underlying;

    public OlapFactDateTimePaginatedList(int bits) {
        this.underlying = new OlapFactDateTimePaginatedListHelper(new OlapFactLongPaginatedList(bits));
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.underlying.cleanupResources(cleaner);
    }

    @Override
    public int getBufferItemCount() {
        return this.underlying.getLocalMillis().getBufferItemCount();
    }

    @Override
    public int getBufferCount() {
        return this.underlying.getLocalMillis().getBufferCount();
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += this.underlying.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    @Nullable
    public LocalDateTime getQuick(int rowId) {
        return this.underlying.getQuick(rowId);
    }

    @Override
    public void setQuick(int rowId, @Nullable LocalDateTime value) {
        this.underlying.setQuick(rowId, value);
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, @Nullable LocalDateTime value) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void add(@Nullable LocalDateTime val) {
        this.underlying.add(val);
    }

    @Override
    public void trimToSize() {
        this.underlying.trimToSize();
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        this.underlying.aggregatePoints(aggregator, rowIds, len);
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        this.underlying.aggregatePoint(aggregator, rowId);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        this.underlying.aggregateRange(aggregator, startRowId, endRowId);
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        return this.underlying.lookup(lookupValue, start);
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.underlying.save(context, out);
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.underlying.restore(context, in);
    }

    @Override
    public long getQuickDateTimeMillis(int rowId) {
        return this.underlying.getQuickMillis(rowId);
    }
}

