/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactCharStringList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.utf8.OlapFactCharStringPaginatedListHelper;
import org.jetbrains.annotations.Nullable;

public class OlapFactCharStringPaginatedList
extends OlapFactPaginatedList
implements IOlapFactCharStringList {
    private static long SHALLOW_SIZE_OF = -1L;
    private final OlapFactCharStringPaginatedListHelper underlying = new OlapFactCharStringPaginatedListHelper();

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
    }

    @Override
    public int getBufferItemCount() {
        return 0;
    }

    @Override
    public int getBufferCount() {
        return 0;
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += this.underlying.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return 0L;
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Nullable
    public String getQuick(int rowId) {
        return this.underlying.getValueAsObject(rowId);
    }

    @Override
    public void setQuick(int rowId, @Nullable String value) {
        this.underlying.setValueAsObject(rowId, value);
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, String value) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void add(@Nullable String val) {
        this.underlying.addNewValue(val);
    }

    @Override
    public void trimToSize() {
        this.underlying.trimToSize();
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        String value = this.getQuick(rowId);
        OlapScalarEntity scalar = value == null ? OlapEmptyEntity.INSTANCE : this.createScalarEntity(value);
        aggregator.aggregate(scalar);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        for (int rowId = startRowId; rowId < endRowId; ++rowId) {
            this.aggregatePoint(aggregator, rowId);
        }
    }

    protected OlapScalarEntity createScalarEntity(String value) {
        return new OlapStringEntity(value);
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        return this.underlying.lookup(lookupValue, start);
    }

    @Override
    public char[] getChars(String value) {
        return this.underlying.getChars(value);
    }

    @Override
    public int compareToChars(char[] value, int rowId) {
        return this.underlying.compareToValueForCompare(value, rowId);
    }

    @Override
    public int hashCode(int rowId) {
        return this.underlying.hashCode(rowId);
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, String value, @Nullable IOlapFactExtraComparator extraComparator) {
        return this.underlying.binarySearch(sortList, (Comparable)((Object)value), extraComparator);
    }

    @Override
    public int binarySearchIgnoreCase(CdPaginatedIntList sortList, String value) {
        return this.underlying.binarySearchIgnoreCase(sortList, value);
    }

    @Override
    public boolean equalsIgnoreCase(int rowId, String name) {
        return this.underlying.equalsIgnoreCase(rowId, name);
    }

    @Override
    public void save(N_BackupContext context, S_BackupOutputStream out) {
        throw new RuntimeException("internal error: char-string list backup not supported");
    }

    @Override
    public void restore(N_RestoreContext context, S_BackupInputStream in) {
        throw new RuntimeException("internal error: char-string list backup not supported");
    }
}

