/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.context.N_OlapContext;
import crazydev.iccube.cluster.node.facts.N_DistinctCountTransformKind;
import crazydev.iccube.cluster.node.facts.N_DistinctCountUniques;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.facts.aggregation.multicolumn.OlapFactMultiColumnAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnEmptyAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnRowVectorAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnTableRowNumbersAggregator;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumn;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapFactMeasureColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapIntegerScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapLongScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapShortScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class OlapScalarEntityFactColumn<T>
implements IOlapFactColumn<T> {
    protected final IOlapFactListFactory listFactory;
    protected final IOlapFactColumnId id;
    protected final OlapBuilderInputType factDataType;
    private boolean hasNulls;

    protected OlapScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType factDataType) {
        this.listFactory = listFactory;
        this.id = id;
        this.factDataType = factDataType;
    }

    public OlapScalarEntityFactColumn adoptPartition(OlapBuilderLoadEntityContext context, OlapScalarEntityFactColumn loadedFactsColumn) {
        this.cleanupResources(context.getFileCleaner());
        return loadedFactsColumn;
    }

    public boolean isInMemory() {
        return this.listFactory.isInMemory();
    }

    @Override
    public IOlapFactColumnId getId() {
        return this.id;
    }

    @Override
    public abstract void cleanupResources(OlapFileCleaner var1);

    public abstract String getFriendlyTypeName();

    public OlapBuilderInputType getFactDataType() {
        return this.factDataType;
    }

    @Override
    public abstract long sizeOf();

    public abstract long sizeOfFiles();

    protected void setHasNulls() {
        this.hasNulls = true;
    }

    @Override
    public void addNewValue(@Nullable T value) {
        if (value == null) {
            this.hasNulls = true;
            this.addNewNullFact();
        } else {
            this.addNewNonNullFact(value);
        }
    }

    protected abstract void addNewNullFact();

    protected abstract void addNewNonNullFact(T var1);

    public final boolean hasNulls() {
        return this.hasNulls;
    }

    public abstract boolean isNullFact(int var1);

    public abstract OlapScalarEntity getValuedForDrillthrough(int var1);

    @Override
    public Object transformValueForCompare(Comparable value) {
        return value;
    }

    @Override
    public int compareToValueForCompare(Object value, int rowId) {
        Comparable valueAsObject = this.getValueAsObject(rowId);
        if (value == null) {
            return valueAsObject == null ? 0 : -1;
        }
        return valueAsObject == null ? 1 : -valueAsObject.compareTo(value);
    }

    public abstract void setValueAt(int var1, @Nullable T var2, OlapFactRowAggregationType var3);

    public abstract Aggregator createAggregator(OlapAggregationType var1);

    protected Aggregator onAggregationTypeNotSupported(OlapAggregationType aggregationType) {
        throw new OlapEvaluationException((OlapErrorLocation)null, OlapErrorCode.AGGREGATE_TYPE_NOT_SUPPORTED, new Serializable[]{this.id.getColumnName(), aggregationType});
    }

    public abstract void aggregateRange(Aggregator var1, int var2, int var3);

    public abstract void aggregatePoint(Aggregator var1, int var2);

    public abstract void aggregatePoints(Aggregator var1, int[] var2, int var3);

    public abstract boolean shouldTransformToDistinctCount(DistinctCountOptimType var1);

    public void addAllDistincts(N_OlapContext context, N_DistinctCountUniques uniqueFacts) {
        try {
            this.doAddAllDistincts(context, uniqueFacts);
        }
        catch (AddAllDistinctsCancelled addAllDistinctsCancelled) {
            // empty catch block
        }
    }

    private void doAddAllDistincts(final N_OlapContext context, final N_DistinctCountUniques uniqueFacts) {
        this.aggregateRange(new Aggregator(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void aggregate(Comparable value) {
                this.assertNotCancelled();
                uniqueFacts.addIfMissing(value);
            }

            @Override
            public void aggregate(double value) {
                this.assertNotCancelled();
                uniqueFacts.addIfMissing(Double.valueOf(value));
            }

            @Override
            public void aggregate(long value) {
                this.assertNotCancelled();
                uniqueFacts.addIfMissing(Long.valueOf(value));
            }

            @Override
            public void aggregate(OlapScalarEntity value) {
                this.assertNotCancelled();
                if (!value.isMdxNull()) {
                    uniqueFacts.addIfMissing((Comparable)value.asValue());
                }
            }

            private void assertNotCancelled() {
                if (context.isCancelling()) {
                    throw new AddAllDistinctsCancelled();
                }
            }

            @Override
            public OlapScalarEntity asScalarEntity() {
                throw new CdShouldNotBeHereProgrammingException();
            }
        }, 0, this.size());
    }

    public void transformUniqueFacts(N_OlapContext context, final N_DistinctCountUniques uniqueFacts, final OlapScalarEntityFactColumn to) {
        class MyAggregator
        extends Aggregator {
            boolean set;

            MyAggregator() {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void aggregate(Comparable value) {
                to.addNewNonNullFact(uniqueFacts.indexOf(value));
                this.set = true;
            }

            @Override
            public void aggregate(double value) {
                to.addNewNonNullFact(uniqueFacts.indexOf(value));
                this.set = true;
            }

            @Override
            public void aggregate(long value) {
                to.addNewNonNullFact(uniqueFacts.indexOf(value));
                this.set = true;
            }

            @Override
            public void aggregate(OlapScalarEntity value) {
                if (!value.isMdxNull()) {
                    to.addNewNonNullFact(uniqueFacts.indexOf(value.asValue()));
                } else {
                    to.addNewValue(null);
                }
                this.set = true;
            }

            @Override
            public OlapScalarEntity asScalarEntity() {
                throw new CdShouldNotBeHereProgrammingException();
            }
        }
        MyAggregator aggregator = new MyAggregator();
        long rowCount = this.size();
        int row = 0;
        while ((long)row < rowCount && !context.isCancelling()) {
            this.aggregatePoint(aggregator, row);
            if (!aggregator.set) {
                to.addNewValue(null);
            }
            aggregator.set = false;
            ++row;
        }
    }

    public OlapScalarEntityFactColumn createColumnForDistinctCountTransform(N_DistinctCountTransformKind kind) {
        OlapFactMeasureColumnId distinctCountId = this.id.copyForDistinctCountTransform();
        switch (kind) {
            case SHORT: {
                return new OlapShortScalarEntityFactColumn(this.listFactory, distinctCountId, this.getFactDataType());
            }
            case INTEGER: {
                return new OlapIntegerScalarEntityFactColumn(this.listFactory, distinctCountId, this.getFactDataType());
            }
            case LONG: {
                return new OlapLongScalarEntityFactColumn(this.listFactory, distinctCountId, this.getFactDataType());
            }
        }
        throw new RuntimeException("internal error: DISTINCT COUNT processing inconsistency [" + String.valueOf((Object)kind) + "]");
    }

    protected byte[] md5() {
        return new byte[0];
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        if (context.isCancelling()) {
            return;
        }
        out.writeInt(out.isDebug() ? 1 : 0);
        if (out.isDebug()) {
            byte[] hash = this.md5();
            out.writeInt(hash.length);
            out.writeBytes(hash);
        }
        out.writeInt(this.hasNulls ? 1 : 0);
        this.doSave(context, out);
    }

    protected abstract void doSave(N_BackupContext var1, S_BackupOutputStream var2) throws IOException;

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        byte[] restoredHash;
        byte[] hash;
        boolean isDebug;
        if (context.isCancelling()) {
            return;
        }
        boolean bl = isDebug = in.readInt() != 0;
        if (isDebug) {
            hash = new byte[in.readInt()];
            in.readBytes(hash);
        } else {
            hash = null;
        }
        this.hasNulls = in.readInt() != 0;
        this.doRestore(context, in);
        if (hash != null && !Arrays.equals(hash, restoredHash = this.md5())) {
            throw new RuntimeException("internal error: index corrupted");
        }
    }

    protected abstract void doRestore(N_RestoreContext var1, S_BackupInputStream var2) throws IOException;

    public static Aggregator createMultiColumnAggregator(OlapScalarEntityFactColumn column, OlapAggregationType aggregationType) {
        switch (aggregationType) {
            case NO_EMPTY: 
            case NO_EMPTY_ROWS: {
                return new OlapFactColumnEmptyAggregator();
            }
            case VECTOR_ROW_NUMBER: {
                return new OlapFactColumnRowVectorAggregator();
            }
            case TABLE_ROW_NUMBER: {
                return new OlapFactColumnTableRowNumbersAggregator();
            }
        }
        return column.createAggregator(aggregationType);
    }

    public static OlapFactMultiColumnAggregator createMultiColumnAggregator(OlapScalarEntityFactColumn[] columns, OlapAggregationType[] aggregationTypes) {
        Aggregator[] aggregators = new Aggregator[columns.length];
        for (int ii = 0; ii < aggregators.length; ++ii) {
            OlapScalarEntityFactColumn column = columns[ii];
            OlapAggregationType aggregationType = aggregationTypes[ii];
            aggregators[ii] = OlapScalarEntityFactColumn.createMultiColumnAggregator(column, aggregationType);
        }
        return new OlapFactMultiColumnAggregator(aggregators);
    }

    public OlapScalarEntityTidyType getTidyEntityType() {
        return OlapScalarEntityTidyType.UNKNOWN;
    }

    public int getQuickInteger(int rowId) {
        throw new CdProgrammingException();
    }

    public long getQuickLong(int rowNumber) {
        throw new CdProgrammingException();
    }

    public float getQuickFloat(int rowId) {
        throw new CdProgrammingException();
    }

    public double getQuickDouble(int rowId) {
        throw new CdProgrammingException();
    }

    public int getQuickDateMillis(int rowId) {
        throw new CdProgrammingException();
    }

    public long getQuickDateTimeMillis(int rowId) {
        throw new CdProgrammingException();
    }

    public static class AddAllDistinctsCancelled
    extends RuntimeException {
        private static final long serialVersionUID = 6028008831067673041L;
    }

    public static abstract class Aggregator
    implements N_MeasureGroup.IFactAggregator {
        public void aggregateFactPage(N_FactPage page) {
        }

        public void aggregate(Comparable value) {
            throw new CdProgrammingException();
        }

        public void aggregate(double value) {
            throw new CdProgrammingException();
        }

        public void aggregate(long value) {
            throw new CdProgrammingException();
        }

        public void aggregate(int value) {
            this.aggregate((long)value);
        }

        public double asDoubleValue() {
            OlapScalarEntity scalar = this.asScalarEntity();
            if (scalar.isMdxNull()) {
                return 0.0;
            }
            Object value = scalar.asValue();
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            throw new CdShouldNotBeHereProgrammingException(this.getClass().getSimpleName());
        }

        public void aggregate(OlapScalarEntity value) {
            throw new CdProgrammingException();
        }

        public void aggregate(IOlapDoubleValueIterable values) {
            throw new CdProgrammingException();
        }

        public boolean useLongInDates() {
            return false;
        }

        @Override
        public abstract OlapScalarEntity asScalarEntity();
    }
}

