/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnCountAggregator;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapRawTypeScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactBoolList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class OlapNewCountScalarEntityFactColumn
extends OlapRawTypeScalarEntityFactColumn<Object> {
    private final IOlapFactBoolList facts;

    public OlapNewCountScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
        this.facts = listFactory.createBoolList(this);
    }

    @Override
    public OlapScalarEntityTidyType getTidyEntityType() {
        return OlapScalarEntityTidyType.LOGICAL;
    }

    @Override
    public String getFriendlyTypeName() {
        return "boolean (count)";
    }

    @Override
    public int size() {
        return this.facts.size();
    }

    @Override
    public void trimToSize() {
        this.facts.trimToSize();
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.facts.cleanupResources(cleaner);
    }

    @Override
    public long sizeOf() {
        return this.facts.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return this.facts.sizeOfFiles();
    }

    @Override
    protected void setRawFact(int rowId, @Nullable Object value) {
        if (value == null) {
            this.setHasNulls();
        }
        this.facts.setQuick(rowId, value != null);
    }

    @Override
    @Nullable
    public Comparable getValueAsObject(int rowId) {
        return Boolean.valueOf(this.facts.getQuick(rowId));
    }

    @Override
    protected void addNewNullFact() {
        this.setHasNulls();
        this.facts.add(false);
    }

    @Override
    protected void addNewNonNullFact(Object value) {
        this.facts.add(true);
    }

    @Override
    public boolean isNullFact(int rowId) {
        return this.hasNulls() && !this.facts.getQuick(rowId);
    }

    @Override
    public OlapScalarEntity getValuedForDrillthrough(int rowId) {
        boolean value = this.facts.getQuick(rowId);
        return value ? OlapBooleanEntity.TRUE : OlapEmptyEntity.INSTANCE;
    }

    @Override
    protected void doAggregateFact(int rowId, Object value) {
        boolean fact = value != null;
        this.facts.setQuick(rowId, fact || this.facts.getQuick(rowId));
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        if (!this.hasNulls()) {
            aggregator.aggregate(endRowId - startRowId);
        } else {
            this.facts.aggregateRange(aggregator, startRowId, endRowId);
        }
    }

    @Override
    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        if (!this.hasNulls() || this.facts.getQuick(rowId)) {
            aggregator.aggregate(1L);
        }
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        if (!this.hasNulls()) {
            aggregator.aggregate(len);
        } else {
            for (int row = 0; row < len; ++row) {
                this.aggregatePoint(aggregator, rowIds[row]);
            }
        }
    }

    @Override
    public OlapScalarEntityFactColumn.Aggregator createAggregator(OlapAggregationType aggregationType) {
        if (aggregationType == OlapAggregationType.COUNT) {
            return new OlapFactColumnCountAggregator();
        }
        return this.onAggregationTypeNotSupported(aggregationType);
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        if (lookupValue instanceof Boolean) {
            boolean value = (Boolean)lookupValue;
            for (int i = start; i < this.facts.size(); ++i) {
                if (value != this.facts.getQuick(i)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, Comparable lookupValue, @Nullable IOlapFactExtraComparator extraComparator) {
        if (lookupValue instanceof Boolean) {
            boolean value = (Boolean)lookupValue;
            int low = 0;
            int high = sortList.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int misKeySortedIdx = sortList.getInt(mid);
                boolean midVal = this.facts.getQuick(misKeySortedIdx);
                long comp = Boolean.compare(value, midVal);
                if (comp == 0L && extraComparator != null) {
                    comp = extraComparator.compareOtherColumns(misKeySortedIdx);
                }
                if (comp > 0L) {
                    low = mid + 1;
                    continue;
                }
                if (comp < 0L) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low - 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.facts.save(context, out);
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.facts.restore(context, in);
    }
}

