/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.IOlapStringFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapComparableScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactComparableList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.facts.column.list.IOlapFactModifiedUtf8StringList;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class OlapModifiedUtf8StringScalarEntityFactColumn
extends OlapComparableScalarEntityFactColumn<String>
implements IOlapStringFactColumn {
    private final IOlapFactModifiedUtf8StringList myFacts;

    public OlapModifiedUtf8StringScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
        this.myFacts = (IOlapFactModifiedUtf8StringList)this.facts;
    }

    @Override
    public String getFriendlyTypeName() {
        return "string (utf8)";
    }

    @Override
    public OlapScalarEntityTidyType getTidyEntityType() {
        return OlapScalarEntityTidyType.CHARACTER;
    }

    @Override
    protected IOlapFactComparableList createFactPaginatedList(IOlapFactListFactory listFactory) {
        return listFactory.createModifiedUtf8StringList(this);
    }

    @Override
    protected Class<String> getColumnType() {
        return String.class;
    }

    @Override
    public OlapScalarEntity getValuedForDrillthrough(int rowId) {
        Comparable rawValue = this.getRawFact(rowId);
        if (rawValue == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        return new OlapStringEntity((String)((Object)rawValue));
    }

    @Override
    public byte[] getUnderlyingHackValue(int rowId) {
        return this.myFacts.getUnderlyingHackValue(rowId);
    }

    @Override
    public String getValueAsObject(int rowId) {
        return (String)this.myFacts.getQuick(rowId);
    }

    @Override
    public Object transformValueForCompare(Comparable value) {
        return value;
    }

    @Override
    public int compareToValueForCompare(Object value, int rowId) {
        return this.myFacts.compareToModifiedUtf8((String)value, rowId);
    }

    @Override
    public int getSortOrder() {
        return 3;
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, Comparable compKey, @Nullable IOlapFactExtraComparator extraComparator) {
        if (compKey instanceof String) {
            return this.myFacts.binarySearch(sortList, (String)((Object)compKey), extraComparator);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int binarySearchIgnoreCase(CdPaginatedIntList sortList, String lookupName) {
        return this.myFacts.binarySearchIgnoreCase(sortList, lookupName);
    }

    @Override
    public boolean equalsIgnoreCase(int rowId, String name) {
        return this.myFacts.equalsIgnoreCase(rowId, name);
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.myFacts.save(context, out);
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.myFacts.restore(context, in);
    }
}

