/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnAvgLeavesAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnCountExAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnDistinctCountDoubleAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnMaxDoubleAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnMinDoubleAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumSquareDoubleAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumVectorAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumVectorSortedAggregator;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumVectorUniqueAggregator;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapDoubleWritableFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapRawTypeScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class OlapFloatScalarEntityFactColumn
extends OlapRawTypeScalarEntityFactColumn
implements OlapDoubleWritableFactColumn {
    public static final float NULL_MARKER = Float.NEGATIVE_INFINITY;
    private final IOlapFactFloatList facts;

    public OlapFloatScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
        this.facts = listFactory.createFloatList(this);
    }

    protected OlapFloatScalarEntityFactColumn(OlapRawTypeScalarEntityFactColumn column, IOlapFactFloatList facts) {
        super(column.listFactory, column.id, column.factDataType);
        this.facts = facts;
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.facts.cleanupResources(cleaner);
    }

    @Override
    public String getFriendlyTypeName() {
        return "float";
    }

    @Override
    public int size() {
        return this.facts.size();
    }

    @Override
    @Nullable
    public Comparable getValueAsObject(int rowId) {
        float value = this.facts.getQuick(rowId);
        if (Float.NEGATIVE_INFINITY == value) {
            return null;
        }
        return Float.valueOf(value);
    }

    @Override
    public float getQuickFloat(int rowId) {
        return this.facts.getQuick(rowId);
    }

    @Override
    public boolean isNullFact(int rowId) {
        return Float.NEGATIVE_INFINITY == this.facts.getQuick(rowId);
    }

    public float getRawFact(int rowId) {
        return this.facts.getQuick(rowId);
    }

    @Override
    protected void addNewNullFact() {
        this.facts.add(Float.NEGATIVE_INFINITY);
    }

    @Override
    protected void addNewNonNullFact(Object value) {
        Number fact = (Number)value;
        float val = fact.floatValue();
        this.assertNotNullMarker(val);
        this.facts.add(val);
    }

    @Override
    protected void setRawFact(int rowId, @Nullable Object value) {
        if (value != null) {
            Number fact = (Number)value;
            float val = fact.floatValue();
            this.assertNotNullMarker(val);
            this.facts.setQuick(rowId, val);
        } else {
            this.setHasNulls();
            this.facts.setQuick(rowId, Float.NEGATIVE_INFINITY);
        }
    }

    @Override
    protected void doAggregateFact(int rowId, Object value) {
        Number fact = (Number)value;
        float val = fact.floatValue();
        this.assertNotNullMarker(val);
        this.facts.setQuick(rowId, val + this.facts.getQuick(rowId));
    }

    @Override
    public OlapScalarEntityFactColumn.Aggregator createAggregator(OlapAggregationType aggregationType) {
        switch (aggregationType) {
            case SUM_HIGH_PRECISION: {
                return OlapFactColumnSumDoubleAggregator.createHP();
            }
            case SUM: {
                return OlapFactColumnSumDoubleAggregator.create();
            }
            case MIN: {
                return new OlapFactColumnMinDoubleAggregator();
            }
            case MAX: {
                return new OlapFactColumnMaxDoubleAggregator();
            }
            case AVG_LEAVES: {
                return new OlapFactColumnAvgLeavesAggregator();
            }
            case DISTINCT_COUNT: {
                return new OlapFactColumnDistinctCountDoubleAggregator();
            }
            case SUM_SQUARE: {
                return new OlapFactColumnSumSquareDoubleAggregator();
            }
            case VECTOR: {
                return new OlapFactColumnSumVectorAggregator();
            }
            case VECTOR_SORTED: {
                return new OlapFactColumnSumVectorSortedAggregator();
            }
            case VECTOR_UNIQUE: {
                return new OlapFactColumnSumVectorUniqueAggregator();
            }
            case COUNT: {
                return new OlapFactColumnCountExAggregator();
            }
        }
        return this.onAggregationTypeNotSupported(aggregationType);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        this.facts.aggregateRange(aggregator, startRowId, endRowId);
    }

    @Override
    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        this.facts.aggregatePoint(aggregator, rowId);
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        this.facts.aggregatePoints(aggregator, rowIds, len);
    }

    @Override
    public OlapScalarEntity getValuedForDrillthrough(int rowId) {
        if (this.isNullFact(rowId)) {
            return OlapEmptyEntity.INSTANCE;
        }
        float rawValue = this.getRawFact(rowId);
        return new OlapNumericEntity(rawValue);
    }

    @Override
    public void trimToSize() {
        this.facts.trimToSize();
    }

    @Override
    public long sizeOf() {
        return this.facts.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return this.facts.sizeOfFiles();
    }

    private void assertNotNullMarker(float val) {
        if (val == Float.NEGATIVE_INFINITY) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.FACTS_ADDING_NULL_MARKER, new Serializable[]{this.id.toStringForError(), Float.valueOf(Float.NEGATIVE_INFINITY)});
        }
    }

    @Override
    public void setQuickRawFact(int rowId, double value) {
        this.facts.setQuick(rowId, (float)value);
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        if (lookupValue instanceof Float) {
            float value = ((Float)lookupValue).floatValue();
            this.assertNotNullMarker(value);
            return this.facts.lookup(value, start);
        }
        return -1;
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, Comparable lookupValue, @Nullable IOlapFactExtraComparator extraComparator) {
        if (lookupValue instanceof Float) {
            float value = ((Float)lookupValue).floatValue();
            int low = 0;
            int high = sortList.size() - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int misKeySortedIdx = sortList.getInt(mid);
                float midVal = this.getRawFact(misKeySortedIdx);
                long comp = Float.compare(value, midVal);
                if (comp == 0L && extraComparator != null) {
                    comp = extraComparator.compareOtherColumns(misKeySortedIdx);
                }
                if (comp > 0L) {
                    low = mid + 1;
                    continue;
                }
                if (comp < 0L) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -low - 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.facts.save(context, out);
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.facts.restore(context, in);
    }
}

