/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.iccube.cluster.shared.schema.S_MeasureDef;
import crazydev.iccube.olap.facts.column.columns.OlapFactMeasureColumnWithMeasureGroup;
import org.jetbrains.annotations.Nullable;

public class OlapFactMeasureColumnId
extends OlapFactMeasureColumnWithMeasureGroup {
    private final String measureName;
    @Nullable
    private final S_MeasureDef measureDef;
    private boolean distinctCount;

    public OlapFactMeasureColumnId(String cubeName, String measureGroupName, String measureName) {
        this(cubeName, measureGroupName, measureName, false);
    }

    public OlapFactMeasureColumnId(String cubeName, String measureGroupName, S_MeasureDef measureDef) {
        super(cubeName, measureGroupName);
        this.measureName = measureDef.getName();
        this.measureDef = measureDef;
        this.distinctCount = false;
    }

    protected OlapFactMeasureColumnId(String cubeName, String measureGroupName, String measureName, boolean distinctCount) {
        super(cubeName, measureGroupName);
        this.measureName = measureName;
        this.distinctCount = distinctCount;
        this.measureDef = null;
    }

    @Override
    public OlapFactMeasureColumnId copyForDistinctCountTransform() {
        return new OlapFactMeasureColumnId(this.cubeName, this.measureGroupName, this.measureName, true);
    }

    public String getMeasureName() {
        return this.measureName;
    }

    @Override
    @Nullable
    public S_MeasureDef getMeasureDef() {
        return this.measureDef;
    }

    @Override
    public boolean isDistinctCount() {
        return this.distinctCount;
    }

    @Override
    public String getColumnName() {
        return this.measureName;
    }

    @Override
    public String toStringForError() {
        return "[cube:" + this.cubeName + "] [measureGroup:" + this.measureGroupName + "] [measure:" + this.measureName + "]" + (this.distinctCount ? " [distinctCount]" : "");
    }

    @Override
    public String toStringForLogs() {
        return this.toStringForError();
    }

    public String toString() {
        return this.toStringForError();
    }
}

