/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapBaseDateScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactComparableList;
import crazydev.iccube.olap.facts.column.list.IOlapFactDateTimeList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.IOException;
import org.joda.time.LocalDateTime;

public class OlapDateTimeScalarEntityFactColumn
extends OlapBaseDateScalarEntityFactColumn<LocalDateTime> {
    private final IOlapFactDateTimeList myFacts;

    public OlapDateTimeScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
        this.myFacts = (IOlapFactDateTimeList)this.facts;
    }

    @Override
    public String getFriendlyTypeName() {
        return "datetime";
    }

    @Override
    protected IOlapFactComparableList createFactPaginatedList(IOlapFactListFactory listFactory) {
        return listFactory.createDateTimeList(this);
    }

    @Override
    protected Class<LocalDateTime> getColumnType() {
        return LocalDateTime.class;
    }

    @Override
    public OlapScalarEntity getValuedForDrillthrough(int rowId) {
        Comparable rawValue = this.getRawFact(rowId);
        if (rawValue == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        return new OlapDateTimeEntity((LocalDateTime)rawValue);
    }

    @Override
    public long getQuickDateTimeMillis(int rowId) {
        return this.myFacts.getQuickDateTimeMillis(rowId);
    }

    @Override
    public int getSortOrder() {
        return 1;
    }

    @Override
    protected void doSave(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.myFacts.save(context, out);
    }

    @Override
    protected void doRestore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.myFacts.restore(context, in);
    }
}

