/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnGenericAggregator;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapFactVectorComparableAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapFactVectorSortedComparableAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapFactVectorUniqueComparableAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactComparableList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapComparableScalarEntityFactColumn<T extends Comparable>
extends OlapScalarEntityFactColumn<T> {
    protected final IOlapFactComparableList facts;

    protected OlapComparableScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
        this.facts = this.createFactPaginatedList(listFactory);
    }

    @Override
    public void cleanupResources(OlapFileCleaner cleaner) {
        this.facts.cleanupResources(cleaner);
    }

    @Override
    public String getFriendlyTypeName() {
        return "object";
    }

    @Override
    public long sizeOf() {
        return this.facts.sizeOf();
    }

    @Override
    public long sizeOfFiles() {
        return this.facts.sizeOfFiles();
    }

    protected abstract IOlapFactComparableList createFactPaginatedList(IOlapFactListFactory var1);

    @Override
    public int size() {
        return this.facts.size();
    }

    @Override
    public boolean isNullFact(int rowId) {
        return this.getRawFact(rowId) == null;
    }

    @Override
    @Nullable
    public Comparable getValueAsObject(int rowId) {
        return this.facts.getQuick(rowId);
    }

    @Nullable
    public Comparable getRawFact(int rowId) {
        return this.facts.getQuick(rowId);
    }

    @Override
    protected void addNewNullFact() {
        this.facts.add(null);
    }

    @Override
    protected void addNewNonNullFact(T value) {
        this.facts.add(value);
    }

    @Override
    public void setValueAt(int rowId, @Nullable T value, OlapFactRowAggregationType factRowAggregationType) {
        if (factRowAggregationType == OlapFactRowAggregationType.UPDATE_ON_CELL) {
            if (value == null) {
                this.setHasNulls();
            }
        } else {
            throw new CdRuntimeException(null, new OlapError(OlapErrorCode.NO_AGGREGATION_FOR_COLUMN_TYPE, new Serializable[]{this.getColumnType().getSimpleName(), this.id.toStringForError()}));
        }
        this.facts.setQuick(rowId, value);
    }

    protected abstract Class<T> getColumnType();

    @Override
    public OlapScalarEntityFactColumn.Aggregator createAggregator(OlapAggregationType aggregationType) {
        switch (aggregationType) {
            case VECTOR: {
                return new OlapFactVectorComparableAggregator();
            }
            case VECTOR_SORTED: {
                return new OlapFactVectorSortedComparableAggregator();
            }
            case VECTOR_UNIQUE: {
                return new OlapFactVectorUniqueComparableAggregator();
            }
        }
        return new OlapFactColumnGenericAggregator(null, aggregationType);
    }

    @Override
    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        this.facts.aggregateRange(aggregator, startRowId, endRowId);
    }

    @Override
    public void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        this.facts.aggregatePoint(aggregator, rowId);
    }

    @Override
    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        this.facts.aggregatePoints(aggregator, rowIds, len);
    }

    @Override
    public boolean shouldTransformToDistinctCount(DistinctCountOptimType distinctCountOptim) {
        return distinctCountOptim != DistinctCountOptimType.NONE;
    }

    @Override
    public void trimToSize() {
        this.facts.trimToSize();
    }

    @Override
    public int lookup(Comparable lookupValue, int start) {
        return this.facts.lookup(lookupValue, start);
    }

    @Override
    public int binarySearch(CdPaginatedIntList sortList, Comparable compKey, @Nullable IOlapFactExtraComparator extraComparator) {
        int low = 0;
        int high = sortList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int misKeySortedIdx = sortList.getInt(mid);
            Comparable midVal = this.getValueAsObject(misKeySortedIdx);
            int comp = compKey.compareTo(midVal);
            if (comp == 0 && extraComparator != null) {
                comp = extraComparator.compareOtherColumns(misKeySortedIdx);
            }
            if (comp > 0) {
                low = mid + 1;
                continue;
            }
            if (comp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }
}

