/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.columns;

import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnDistinctCountLongAggregator;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapComparableScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;

public abstract class OlapBaseDateScalarEntityFactColumn<T extends Comparable>
extends OlapComparableScalarEntityFactColumn<T> {
    public OlapBaseDateScalarEntityFactColumn(IOlapFactListFactory listFactory, IOlapFactColumnId id, OlapBuilderInputType valueInputType) {
        super(listFactory, id, valueInputType);
    }

    @Override
    public OlapScalarEntityTidyType getTidyEntityType() {
        return OlapScalarEntityTidyType.DATETIME;
    }

    @Override
    public OlapScalarEntityFactColumn.Aggregator createAggregator(OlapAggregationType aggregationType) {
        if (aggregationType == OlapAggregationType.DISTINCT_COUNT) {
            return new DatesDistinctCountAggregator();
        }
        return super.createAggregator(aggregationType);
    }

    @Override
    public boolean shouldTransformToDistinctCount(DistinctCountOptimType distinctCountOptim) {
        return distinctCountOptim == DistinctCountOptimType.AGGRESSIVE;
    }

    private static final class DatesDistinctCountAggregator
    extends OlapScalarEntityFactColumn.Aggregator {
        private final OlapFactColumnDistinctCountLongAggregator aggregator = new OlapFactColumnDistinctCountLongAggregator();

        private DatesDistinctCountAggregator() {
        }

        @Override
        public void aggregate(long value) {
            this.aggregator.aggregate(value);
        }

        @Override
        public boolean useLongInDates() {
            return true;
        }

        @Override
        public OlapScalarEntity asScalarEntity() {
            return this.aggregator.asScalarEntity();
        }
    }
}

