/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.aggregator;

import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.aggregator.ISumAggregator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;

public final class OlapFactColumnSumDoubleNeumaierAggregator
extends OlapScalarEntityFactColumn.Aggregator
implements ISumAggregator {
    private double sum = 0.0;
    private double compensation = 0.0;
    private boolean hit = false;

    @Override
    public void aggregate(long value) {
        this.aggregate((double)value);
    }

    @Override
    public void aggregate(double number) {
        double t = this.sum + number;
        this.compensation = Math.abs(this.sum) >= Math.abs(number) ? (this.compensation += this.sum - t + number) : (this.compensation += number - t + this.sum);
        this.sum = t;
        this.hit = true;
    }

    @Override
    public double aggregation() {
        return this.sum + this.compensation;
    }

    @Override
    public double asDoubleValue() {
        return this.aggregation();
    }

    @Override
    public boolean isEmpty() {
        return !this.hit;
    }

    @Override
    public OlapScalarEntity asScalarEntity() {
        if (!this.isEmpty()) {
            return new OlapNumericEntity(this.aggregation());
        }
        return OlapEmptyEntity.INSTANCE;
    }
}

