/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.OlapBuilderUnloadPartitionsContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactContext;
import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDimensionality;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.common.OlapIdentity;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.enums.OlapPartitioningType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapFactDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.facts.IOlapFactMeasureGroupManagerForEval;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupSurrogate;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsStats;
import crazydev.iccube.olap.schema.stats.OlapHierarchyStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapFactMeasureGroupBaseManager
implements IOlapFactMeasureGroupManagerForEval,
OlapIdentity {
    private static final OlapNameContext nameContext = OlapNameContext.DEFAULT_VALUES;
    private final OlapFactMeasureGroupSurrogate surrogate = new OlapFactMeasureGroupSurrogate(this);
    private final IOlapFactListFactory factsColumnListFactory;
    private final S_FactBitmapContainerFactory factsBitmapContainerFactory;
    private final String name;
    private final String measureGroupName;
    private final String measureGroupNameInFacts;
    private final OlapCube cube;
    private final IOlapBuilderBaseFactsDef factsDefinition;
    private final OlapPartitioningType partitionType;
    private final List<OlapMeasureMember> measures;
    private OlapFactDimensionality dimensionality;
    private List<OlapDimension> indexingDimensions;

    public OlapFactMeasureGroupBaseManager(IOlapFactListFactory factsColumnListFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory, OlapCube cube, IOlapBuilderBaseFactsDef factsDefinition, OlapPartitioningType partitionType) {
        this.factsColumnListFactory = factsColumnListFactory;
        this.factsBitmapContainerFactory = factsBitmapContainerFactory;
        this.name = cube.getName(nameContext) + "." + factsDefinition.getMeasureGroupName();
        this.measureGroupName = factsDefinition.getMeasureGroupName();
        this.measureGroupNameInFacts = factsDefinition.getName();
        this.cube = cube;
        this.factsDefinition = factsDefinition;
        this.partitionType = partitionType;
        this.measures = cube.getMeasuresMembers(factsDefinition.getMeasureGroupName());
        if (OlapLoggers.FACTS.isTraceEnabled()) {
            OlapLoggers.FACTS.trace((Object)("MDX facts [" + this.name + "] is being created"));
        }
    }

    @Override
    public OlapFactMeasureGroupSurrogate asSurrogate() {
        return this.surrogate;
    }

    public abstract void setupClusterInformation();

    public abstract void setupClusterBuildFactContext(OlapBuilderFactContext var1);

    public abstract S_MeasureGroupRef getClusterRef();

    public OlapFactRowAggregationType rowFactAggregationType() {
        return this.factsDefinition.rowFactAggregationType();
    }

    public OlapPartitioningType getPartitionType() {
        return this.partitionType;
    }

    public abstract boolean isTablePartitioned();

    public abstract boolean isLevelPartitioned();

    protected boolean isFactsInFiles() {
        return !this.factsColumnListFactory.isInMemory();
    }

    protected boolean isIndexInFiles() {
        return this.factsBitmapContainerFactory.isInFile();
    }

    public void resetForSchema(OlapSchema schema, int nextDimensionIndexOffset, int nextHierarchyIndexOffset, int nextPartitionIndexOffset) {
        if (this.dimensionality == null) {
            throw new RuntimeException("internal error: missing dimensionality");
        }
        this.dimensionality.resetForSchema(schema, this.indexingDimensions);
    }

    public void initLazyVariables(Collection<OlapDimension> dimensions) {
        if (this.dimensionality == null) {
            this.dimensionality = new OlapFactDimensionality();
            for (OlapDimension olapDimension : dimensions) {
                this.dimensionality.add(olapDimension);
            }
            this.indexingDimensions = new ArrayList<OlapDimension>();
            this.indexingDimensions.addAll(dimensions);
        }
    }

    public String getSchemaName() {
        return this.cube.getSchema().getName();
    }

    public String getCubeName() {
        return this.cube.getNameX();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String getMeasureGroupName() {
        return this.measureGroupName;
    }

    public String getMeasureGroupNameInFacts() {
        return this.measureGroupNameInFacts;
    }

    public final OlapCube getCube() {
        return this.cube;
    }

    public List<OlapMeasureMember> getMeasures() {
        return this.measures;
    }

    public final IOlapBuilderBaseFactsDef getFactsDefinition() {
        return this.factsDefinition;
    }

    public final OlapFactDimensionality getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public final List<OlapDimension> getIndexingDimensions() {
        return this.indexingDimensions;
    }

    public final boolean containsDimension(OlapDimension dimension) {
        if (this.dimensionality == null) {
            return this.factsDefinition.containsDimension(dimension.getName(OlapNameContext.DEFAULT_VALUES));
        }
        return this.dimensionality.isIn(dimension);
    }

    public boolean containsMeasure(String measureName) {
        for (OlapMeasureMember measure : this.measures) {
            if (!OlapCaseInsensitiveName.equals(measure.getName(nameContext), measureName)) continue;
            return true;
        }
        return false;
    }

    public abstract void restorePartition(OlapBuilderFactContext var1, int var2, String var3, OlapBuilderInputType var4, String var5);

    public abstract void addFactEmptyRow(OlapBuilderFactContext var1, @Nullable IOlapBuilderTablePartitionKey var2);

    public abstract void addFactRows(OlapBuilderFactContext var1, N_FactPageBatchInfo var2);

    public abstract void onTableRowsProcessingCompleted(OlapBuilderContext var1, IOlapBuilderTablePartitionKey var2);

    public abstract void onTableRowsProcessingCompleted(OlapBuilderContext var1);

    public abstract void onProcessFactsCompleted(OlapBuilderContext var1, OlapFileCleaner var2);

    public abstract void onIncrLoadProcessFactsCompleted(OlapBuilderContext var1);

    public abstract OlapScalarEntityFactColumn[] getColumnsForTest__();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapFactMeasureGroupBaseManager that = (OlapFactMeasureGroupBaseManager)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public abstract void deleteCategoryHierarchyBitmaps(OlapHierarchy var1);

    public abstract boolean adoptPartitions(OlapBuilderLoadEntityContext var1, OlapBuilderContext var2, OlapFactMeasureGroupBaseManager var3);

    public abstract boolean unloadPartitions(OlapBuilderUnloadPartitionsContext var1, List<String> var2);

    public abstract List<OlapSchemaPartitionInformation> listPartitions(List<OlapSchemaPartitionInformation> var1, String var2, String var3);

    public abstract void clearOnIncrLoadFullReload(OlapBuilderContext var1);

    public abstract void getInformationForPerformanceTests(OlapSchemaInformationForTests var1);

    public abstract void dumpIndex(FileOutputStream var1, OlapSchemaDumpIndexHierarchies var2) throws IOException;

    public OlapFactsStats createStats(OlapStatsContext context, Map<String, OlapDimensionStats> dimensions) {
        OlapFactsLevelsBitmapsStats statsPerLevel = new OlapFactsLevelsBitmapsStats();
        ArrayList<OlapFactsPartitionStats> partitionsStats = new ArrayList<OlapFactsPartitionStats>();
        this.createStats(context, statsPerLevel, partitionsStats);
        OlapUnresolvedRowsManager rowsManager = context.getUnresolvedRowsManager();
        OlapCube cube = this.getCube();
        IOlapBuilderBaseFactsDef factsDefinition = this.getFactsDefinition();
        long unresolvedRowCount = rowsManager.getCubesUnresolvedRowsCountForStatistics(cube, factsDefinition);
        long unresolvedRowRamSize = rowsManager.getCubesUnresolvedRowsRamSizeForStatistics(cube, factsDefinition);
        double cellCount = -1.0;
        if (this.indexingDimensions != null) {
            cellCount = 1.0;
            for (OlapDimension indexingDimension : this.indexingDimensions) {
                String indexingDimensionName = indexingDimension.getName(OlapNameContext.DEFAULT_VALUES);
                OlapDimensionStats dimensionStats = dimensions.get(indexingDimensionName);
                if (dimensionStats == null) {
                    context.addWarning("Cell count error for facts [" + this.getName() + "] : missing indexing dimension stats [" + indexingDimensionName + "]");
                    cellCount = -1.0;
                    break;
                }
                OlapHierarchyStats baseHierarchy = dimensionStats.getBaseHierarchy();
                if (baseHierarchy == null) {
                    context.addWarning("Cell count error for facts [" + this.name + "] : missing base-hierarchy for indexing dimension stats [" + indexingDimensionName + "]");
                    cellCount = -1.0;
                    break;
                }
                cellCount *= (double)baseHierarchy.getMemberCount();
            }
        }
        return new OlapFactsStats(this.getName(), this.isTablePartitioned(), this.isLevelPartitioned(), this.isIndexInFiles(), this.isFactsInFiles(), cellCount != -1.0 ? Double.valueOf(cellCount) : null, unresolvedRowCount, unresolvedRowRamSize, partitionsStats, statsPerLevel);
    }

    protected abstract void createStats(OlapStatsContext var1, OlapFactsLevelsBitmapsStats var2, List<OlapFactsPartitionStats> var3);

    public OlapFactsStats createIncrLoadStats(OlapStatsContext context) {
        ArrayList<OlapFactsPartitionStats> partitionsStats = new ArrayList<OlapFactsPartitionStats>();
        this.createIncrLoadStats(partitionsStats);
        OlapUnresolvedRowsManager rowsManager = context.getUnresolvedRowsManager();
        long unresolvedRowCount = rowsManager.getCubesUnresolvedRowsCountForStatistics(this.getCube(), this.getFactsDefinition());
        return new OlapFactsStats(this.getName(), this.isTablePartitioned(), this.isLevelPartitioned(), this.isIndexInFiles(), this.isFactsInFiles(), null, unresolvedRowCount, 0L, partitionsStats, new OlapFactsLevelsBitmapsStats());
    }

    protected abstract void createIncrLoadStats(List<OlapFactsPartitionStats> var1);

    public List<OlapHierarchy> createIndexingHierarchies() {
        ArrayList<OlapHierarchy> indexingHierarchies = new ArrayList<OlapHierarchy>();
        if (this.indexingDimensions != null) {
            for (OlapDimension indexingDimension : this.indexingDimensions) {
                indexingHierarchies.addAll(indexingDimension.getHierarchies());
            }
        }
        return indexingHierarchies;
    }

    public S_HierarchyDimensionality createIndexingHierarchiesDimensionality() {
        S_HierarchyDimensionality dimensionality = new S_HierarchyDimensionality();
        List<OlapHierarchy> indexingHierarchies = this.createIndexingHierarchies();
        for (OlapHierarchy indexingHierarchy : indexingHierarchies) {
            dimensionality.addHierarchy(indexingHierarchy.getTupleDimensionalityIndex());
        }
        return dimensionality;
    }

    public boolean isIndexedBy(OlapHierarchy hierarchy) {
        OlapDimension dimension = hierarchy.getDimension();
        return this.dimensionality.isIn(dimension);
    }

    public String toString() {
        return this.getName();
    }
}

