/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.tuple;

import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapTupleOrParenPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapTuplePreparedInstr;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;

public class OlapTupleOrParenInstr
extends OlapExecutedWithPreparedInstr<OlapEvaluationContext> {
    protected final OlapInstr[] content;

    public OlapTupleOrParenInstr(OlapInstrLocationRange range, OlapInstr ... content) {
        super(range);
        this.content = content;
        for (OlapInstr instr : content) {
            instr.setParent(this);
        }
    }

    public OlapInstr[] getContent() {
        return this.content;
    }

    @Override
    public String typeForError() {
        return "TUPLE OR PARENTHESIS";
    }

    @Override
    public boolean isConstrainedEnabled() {
        return false;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            for (OlapInstr c : this.content) {
                c.accept(v);
            }
        }
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapPreparedInstr[] pContent = new OlapPreparedInstr[this.content.length];
        for (int ii = 0; ii < pContent.length; ++ii) {
            OlapPreparedInstr pInstr;
            OlapInstr instr = this.content[ii];
            pContent[ii] = pInstr = instr.prepare(context);
        }
        if (pContent.length == 1) {
            return pContent[0];
        }
        boolean allMembers = true;
        for (OlapPreparedInstr pInstr : pContent) {
            if (pInstr.isQuickToMemberApplicable(context)) continue;
            allMembers = false;
        }
        if (allMembers) {
            return new OlapTuplePreparedInstr(this, context, pContent);
        }
        return new OlapTupleOrParenPreparedInstr(this, pContent);
    }

    @Override
    public String toStringForDebugger() {
        return "Tuple";
    }
}

