/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.subselect.dimension;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerExistsFilterFactory;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.filter.dimension.IOlapSimpleExistsFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapChainedSimpleExistsFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapSimpleEmptyExistsFilter;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.index.bitmap.OlapBitSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapRegularSubSelectTupleFilter
extends OlapSubSelectTupleFilter {
    private final OlapTupleDimensionalityCache cache;
    private final List<List<OlapTuple>> subSelectAxes;
    private final boolean hasCalcMember;
    private final Map<OlapBitSet, IOlapSimpleExistsFilter> filters = new ConcurrentHashMap<OlapBitSet, IOlapSimpleExistsFilter>();
    private final Map<OlapHierarchy, List<OlapMember>> cachedDefinedMember = new ConcurrentHashMap<OlapHierarchy, List<OlapMember>>();
    private final List<OlapBitSet> dimDimensionalities = new ArrayList<OlapBitSet>();
    private final OlapBitSet dimDimensionality;
    private final OlapTupleDimensionality tupleDimensionality;
    private OlapBitSet collidingDimensionality;

    public OlapRegularSubSelectTupleFilter(OlapTupleDimensionalityCache cache, List<List<OlapTuple>> axes) {
        this.cache = cache;
        this.subSelectAxes = axes;
        this.hasCalcMember = this.hasCalcMember();
        this.dimDimensionality = this.fillDimDimensionality();
        this.tupleDimensionality = this.setupTupleDimensionality();
    }

    @Override
    public String getName() {
        return "sub-select-dimension";
    }

    @Override
    public boolean isFilteringHierarchy(OlapHierarchy hierarchy) {
        return this.tupleDimensionality.isIn(hierarchy);
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        return this.accept(member);
    }

    @Override
    public boolean isAccepting(IOlapTuple tuple) {
        return this.accept(tuple);
    }

    private boolean accept(IOlapTuple tuple) {
        IOlapSimpleExistsFilter filter = this.filters.get(tuple.getTupleDimensionality().asBitSet());
        if (filter == null) {
            filter = this.getOrCreateFilter(tuple);
        }
        return filter.isAccepting(tuple);
    }

    private synchronized IOlapSimpleExistsFilter getOrCreateFilter(IOlapTuple tuple) {
        OlapTupleDimensionality tupleDimensionality = tuple.getTupleDimensionality();
        IOlapSimpleExistsFilter filter = this.filters.get(tupleDimensionality.asBitSet());
        if (filter == null) {
            long start = System.currentTimeMillis();
            filter = this.createFilter(tuple);
            this.filters.put(tupleDimensionality.asBitSet(), filter);
            String ellapsed = CdTimeUtils.formatMillisEx((long)start);
            boolean bl = false;
        }
        return filter;
    }

    private IOlapSimpleExistsFilter createFilter(IOlapTuple tuple) {
        OlapBitSet tupleDimDimensionality = this.createDimDimensionality(tuple);
        if (!tupleDimDimensionality.intersects(this.dimDimensionality)) {
            return OlapSimpleEmptyExistsFilter.INSTANCE;
        }
        if (!this.filters.isEmpty()) {
            OlapBitSet interTupleDimensionality = new OlapBitSet();
            this.subSelectAxes.forEach(axis -> interTupleDimensionality.or(((OlapTuple)axis.get(0)).getTupleDimensionality().asBitSet()));
            interTupleDimensionality.and(tuple.getTupleDimensionality().asBitSet());
            IOlapSimpleExistsFilter filter = this.filters.get(interTupleDimensionality);
            if (filter != null) {
                return filter;
            }
        }
        OlapChainedSimpleExistsFilter chainFilter = new OlapChainedSimpleExistsFilter();
        int dimIndex = tupleDimDimensionality.nextSetBit(0);
        while (dimIndex >= 0) {
            for (int i = 0; i < this.dimDimensionalities.size(); ++i) {
                OlapBitSet subDimDim = this.dimDimensionalities.get(i);
                if (!tupleDimDimensionality.intersects(subDimDim)) continue;
                OlapBitSet matchinDim = new OlapBitSet(subDimDim);
                matchinDim.and(tupleDimDimensionality);
                IOlapSimpleExistsFilter filter = OlapSlicerExistsFilterFactory.createSubSelect(IOlapEvaluationExceptionContext.NULL_NO_CHECK, this.cache, tuple, matchinDim, this.subSelectAxes.get(i), false, this.hasCalcMember);
                chainFilter.addFilter(filter);
            }
            dimIndex = tupleDimDimensionality.nextSetBit(dimIndex + 1);
        }
        return chainFilter.simplify();
    }

    private OlapTupleDimensionality setupTupleDimensionality() {
        OlapTupleDimensionality dim = null;
        for (int i = 0; i < this.subSelectAxes.size(); ++i) {
            List<OlapTuple> olapTuples = this.subSelectAxes.get(i);
            OlapTuple firstTuple = olapTuples.get(0);
            dim = firstTuple.getTupleDimensionality().or(dim);
        }
        return dim;
    }

    private boolean hasCalcMember() {
        for (int idx = 0; idx < this.subSelectAxes.size(); ++idx) {
            List<OlapTuple> axe = this.subSelectAxes.get(idx);
            for (int i = 0; i < axe.size(); ++i) {
                if (!axe.get(i).hasCalcMember()) continue;
                return true;
            }
        }
        return false;
    }

    private OlapBitSet fillDimDimensionality() {
        OlapBitSet dimDimensionality = new OlapBitSet();
        for (int i = 0; i < this.subSelectAxes.size(); ++i) {
            List<OlapTuple> olapTuples = this.subSelectAxes.get(i);
            OlapTuple firstTuple = olapTuples.get(0);
            firstTuple.setDimensionBitSet(dimDimensionality);
            OlapBitSet listDimDimensionality = this.createDimDimensionality(firstTuple);
            this.dimDimensionalities.add(listDimDimensionality);
        }
        return dimDimensionality;
    }

    @Override
    public List<List<OlapTuple>> getDefinition() {
        return this.subSelectAxes;
    }

    @Override
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    @Nullable
    public OlapTupleSet<OlapTuple> getAxisForMdxFunction(int number) {
        if (number < 0 || number >= this.subSelectAxes.size()) {
            return null;
        }
        List<OlapTuple> axis = this.subSelectAxes.get(number);
        return OlapSetFactory.instance(axis);
    }

    @Override
    public void forEachNoCollidingMember(Consumer<OlapMember> consumer, Predicate<OlapMember> filter) {
        if (this.collidingDimensionality == null) {
            this.collidingDimensionality = this.calculateCollidingDimensionality();
        }
        for (int idx = 0; idx < this.subSelectAxes.size(); ++idx) {
            List<OlapTuple> axe = this.subSelectAxes.get(idx);
            for (int i = 0; i < axe.size(); ++i) {
                OlapTuple olapTuple = axe.get(i);
                olapTuple.forEach(consumer, member -> filter.test((OlapMember)member) && !this.collidingDimensionality.get(member.getTupleDimensionalityIndex()));
            }
        }
    }

    @Override
    public List<OlapMember> getDefinedMembers(OlapHierarchy hierarchy) {
        return this.cachedDefinedMember.computeIfAbsent(hierarchy, hier -> {
            ArrayList<OlapMember> list = new ArrayList<OlapMember>();
            for (List<OlapTuple> axe : this.subSelectAxes) {
                for (OlapTuple olapTuple : axe) {
                    @Nullable OlapMember m = olapTuple.getMember(hierarchy);
                    if (m == null) continue;
                    list.add(m);
                }
            }
            return list;
        });
    }

    private OlapBitSet calculateCollidingDimensionality() {
        OlapBitSet res = new OlapBitSet();
        for (int i = 0; i < this.dimDimensionalities.size(); ++i) {
            OlapBitSet bitSet = this.dimDimensionalities.get(i);
            for (int j = i + 1; j < this.dimDimensionalities.size(); ++j) {
                OlapBitSet bitSet2 = this.dimDimensionalities.get(j);
                if (!bitSet.intersects(bitSet2)) continue;
                OlapBitSet and = OlapBitSet.and(bitSet, bitSet2);
                res.or(and);
            }
        }
        return res;
    }
}

