/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.set;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResDropSetBlankStatementDataSet;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapScriptCommandStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapDropSetStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDropSetStatementInstr
extends OlapScriptCommandStatementInstr<OlapDropSetStatementExecutionContext> {
    private final boolean sessionScoped;
    private final List<String> names;

    public OlapDropSetStatementInstr(OlapInstrLocationRange range, boolean sessionScoped, List<String> names) {
        super(range);
        this.sessionScoped = sessionScoped;
        this.names = names;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.WRITE;
    }

    @Override
    public String typeForError() {
        return "DROP SET";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected OlapDropSetStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapDropSetStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapDropSetStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapResDropSetBlankStatementDataSet executeForGlobalScope(OlapDropSetStatementExecutionContext context) {
        this.assertAuthorizationForDropStatement(context);
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResDropSetBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        for (String name : this.names) {
            schema.removeSetDeclaration(context.getErrorLocation(), context.getSchemaPermissions(), name);
        }
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResDropSetBlankStatementDataSet(schema.getName(), "?", this.getSetNames());
    }

    private OlapResDropSetBlankStatementDataSet executeForSessionScope(OlapDropSetStatementExecutionContext context) {
        OlapSchema schema = context.getSchema();
        context.removeSessionSetDeclarations(this.names);
        this.onScriptStatementApplied(context, schema, false);
        return new OlapResDropSetBlankStatementDataSet(schema.getName(), "?", this.getSetNames());
    }

    private String getSetNames() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.names) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public String toStringForDebugger() {
        return "DROP SET : " + this.names.toString();
    }
}

