/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.set;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResCreateSetBlankStatementDataSet;
import crazydev.iccube.olap.eval.create.OlapCreateStatementInstr;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateSetStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCreateSetStatementInstr
extends OlapCreateStatementInstr<OlapCreateSetStatementExecutionContext> {
    @Nullable
    private final String cube;
    private final String name;
    private final boolean sessionScoped;
    private final boolean dynamicEvaluation;
    private final String mdx;
    private final OlapInstr formula;
    @Nullable
    private final String displayFolder;
    @Nullable
    private final String description;

    public OlapCreateSetStatementInstr(OlapInstrLocationRange range, @Nullable String cube, String name, boolean sessionScoped, boolean dynamicEvaluation, String mdx, OlapInstr formula, @Nullable String displayFolder, @Nullable String description) {
        super(range);
        this.cube = cube;
        this.name = name;
        this.sessionScoped = sessionScoped;
        this.dynamicEvaluation = dynamicEvaluation;
        this.mdx = mdx;
        this.formula = formula;
        this.formula.setParent(this);
        this.displayFolder = displayFolder;
        this.description = description;
    }

    @Override
    public String typeForError() {
        return "CREATE SET";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.formula.accept(v);
        }
    }

    @Override
    protected OlapCreateSetStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapCreateSetStatementExecutionContext(requestContext, props, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapCreateSetStatementExecutionContext context) {
        if (!this.sessionScoped) {
            return this.executeForGlobalScope(context);
        }
        return this.executeForSessionScope(context);
    }

    private OlapResCreateSetBlankStatementDataSet executeForGlobalScope(OlapCreateSetStatementExecutionContext context) {
        OlapRoleApplicationPermissions perms = context.getApplicationPermissions();
        if (!perms.isBuilderEnabled()) {
            throw new OlapEvaluationException(context, OlapErrorCode.NOT_AUTHORIZED, new Serializable[]{"app.builder"});
        }
        OlapSchema schema = context.getSchema();
        if (context.isPrepareExecutionMode()) {
            return new OlapResCreateSetBlankStatementDataSet(schema.getName(), "?", "preparing");
        }
        OlapInstrLocationRange definitionRange = this.getLocationRange();
        schema.addSetDeclarationIfNotContained(definitionRange, context.getSchemaPermissions(), this.cube, this.name, this.sessionScoped, this.dynamicEvaluation, this.mdx, this.formula, this.displayFolder, this.description);
        this.onScriptStatementApplied(context, schema, true);
        return new OlapResCreateSetBlankStatementDataSet(schema.getName(), "?", this.name);
    }

    private OlapResCreateSetBlankStatementDataSet executeForSessionScope(OlapCreateSetStatementExecutionContext context) {
        if (context.isSessionLess()) {
            throw new OlapEvaluationException(context, OlapErrorCode.MDX_SESSION_MISMATCH, new Serializable[]{"set"});
        }
        OlapSchema schema = context.getSchema();
        context.addSessionSetDeclarationIfNotContained(this.getLocationRange(), this.cube, this.name, this.sessionScoped, this.dynamicEvaluation, this.mdx, this.formula, this.displayFolder, this.description);
        this.onScriptStatementApplied(context, schema, false);
        return new OlapResCreateSetBlankStatementDataSet(schema.getName(), "?", this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toStringForDebugger() {
        return "CREATE SET : " + this.name;
    }
}

