/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.tidypostprocessor;

import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTable;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;

public abstract class OlapTidyPostProcessorInstr {
    private final OlapTidyPostProcessor meta;
    private final OlapInstrLocationRange range;
    private final int step;
    private final boolean addToResult;

    public OlapTidyPostProcessorInstr(OlapTidyPostProcessor meta, OlapInstrLocationRange range, int step, boolean addToResult) {
        this.meta = meta;
        this.range = range;
        this.step = step;
        this.addToResult = addToResult;
    }

    public OlapInstrLocationRange getRange() {
        return this.range;
    }

    public int getStep() {
        return this.step;
    }

    public boolean isMdxResult() {
        return false;
    }

    public boolean isAddToResult() {
        return this.addToResult;
    }

    public Serializable getName() {
        return this.meta.getName();
    }

    public boolean canHandleCellOnError() {
        return this.meta.canHandleCellOnError();
    }

    public boolean canHandleTruncatedResult() {
        return this.meta.canHandleTruncatedResult();
    }

    public boolean canHandlePaging() {
        return this.meta.canHandlePaging();
    }

    public final OlapResTidyTable postProcess(OlapSelectStatementExecutionContext sContext, OlapResTidyTable table) {
        try {
            return this.doPostProcess(sContext, table);
        }
        catch (OlapEvaluationException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            OlapLoggers.MDX_EVALUATION.error((Object)"[MDX POST_PROCESSING]", (Throwable)exception);
            throw new OlapEvaluationException(exception, new OlapError<OlapInstrLocationRange, OlapErrorCode>(this.getRange(), OlapErrorCode.TIDY_POST_PROCESSOR_ERROR, new Serializable[]{this.getName(), exception.toString()}));
        }
    }

    protected abstract OlapResTidyTable doPostProcess(OlapSelectStatementExecutionContext var1, OlapResTidyTable var2);

    public OlapEvaluationException createError(OlapErrorCode code, Serializable ... params) {
        return new OlapEvaluationException(this.getRange(), code, params);
    }
}

