/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.tidypostprocessor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import crazydev.common.collection.CdStrPair;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResTidyMaterializedTable;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceFactory;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapPostProcessedMdxResult {
    private final String schemaName;
    private final String cubeName;
    @Nullable
    private final OlapException cellError;
    private final String logCellCount;
    private final String logAxesTupleCount;
    private final String logRowCount;
    private final String maxRowCount;
    private final String maxRowCountReached;
    private final Map<Integer, OlapResTidyTable> tables = new HashMap<Integer, OlapResTidyTable>();

    public OlapPostProcessedMdxResult(OlapResMdxTidyTable rawMdxResult) {
        this.schemaName = rawMdxResult.getSchemaName();
        this.cubeName = rawMdxResult.getCubeName();
        this.cellError = rawMdxResult.getCellError();
        this.logCellCount = rawMdxResult.logCellCount();
        this.logAxesTupleCount = rawMdxResult.logAxesTupleCount();
        this.logRowCount = rawMdxResult.logRowCount();
        this.maxRowCount = "" + rawMdxResult.getTidyMaxRowCount();
        this.maxRowCountReached = "" + rawMdxResult.isTidyMaxRowCountReached();
    }

    public void addToResult(int step, OlapResTidyTable table) {
        this.tables.put(step, table);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    @Nullable
    public OlapException getCellError() {
        return this.cellError;
    }

    public String logCellCount() {
        return this.logCellCount;
    }

    public String logAxesTupleCount() {
        return this.logAxesTupleCount;
    }

    public String logRowCount() {
        return this.logRowCount;
    }

    public String getTidyMaxRowCount() {
        return this.maxRowCount;
    }

    public String isTidyMaxRowCountReached() {
        return this.maxRowCountReached;
    }

    public OlapResTidyMaterializedTable<?> materialize(boolean json, @Nullable OlapResultStoreInformation info) {
        List steps = this.tables.keySet().stream().sorted().toList();
        Integer lastStep = (Integer)steps.get(steps.size() - 1);
        OlapResTidyTable lastStepTable = this.tables.get(lastStep);
        OlapResTidyMaterializedTable<?> materialized = lastStepTable.materialize(json);
        if (info != null) {
            ArrayList<CdStrPair> cacheProperties = new ArrayList<CdStrPair>();
            info.createQueryProperties(cacheProperties);
            materialized.addCacheProperties(cacheProperties);
        }
        for (int ii = 0; ii < steps.size() - 1; ++ii) {
            int step = (Integer)steps.get(ii);
            OlapResTidyTable stepTable = this.tables.get(step);
            OlapResTidyMaterializedTable<?> table = stepTable.materialize(json);
            materialized.addStep(step, table);
        }
        return materialized;
    }

    public IOlapSerializedTidyResource serializeAsJson(OlapEngineRequestContext context, @Nullable OlapResultStoreInformation info) throws IOException {
        return OlapSerializedTidyResourceFactory.create(OlapSerializedTidyResourceFactory.Prefix.mdx, context, out -> {
            JsonWriter w = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            GsonBuilder gsonB = new GsonBuilder();
            w.setStrictness(Strictness.LENIENT);
            gsonB.serializeSpecialFloatingPointValues();
            Gson gson = gsonB.create();
            this.serializeTable(w, gson, context, true, false, info);
            w.close();
        });
    }

    public void serializeTable(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, boolean flat, @Nullable OlapResultStoreInformation info) throws IOException {
        List stepIndices = this.tables.keySet().stream().sorted().toList();
        int lastStepIndex = (Integer)stepIndices.get(stepIndices.size() - 1);
        OlapResTidyTable lastStep = this.tables.get(lastStepIndex);
        HashMap steps = new HashMap();
        for (int ii = 0; ii < stepIndices.size() - 1; ++ii) {
            int step = (Integer)stepIndices.get(ii);
            steps.put(step, this.tables.get(step));
        }
        lastStep.serializeTable(w, g, context, json, flat, info, steps, 0L);
    }
}

