/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.tidypostprocessor;

import crazydev.common.collection.CdArrayList;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxDoubleLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxTrueLiteralExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.entity.result.tidy.IOlapResTidyTableColumn;
import crazydev.iccube.olap.entity.result.tidy.OlapResFlatTidyTable;
import crazydev.iccube.olap.entity.result.tidy.OlapResFlatTidyTableColumn;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTable;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTableMdxInfo;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntityTidyType;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessor;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessorInstr;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.util.FastMath;

public class OlapMultiLinearRegressionTidyPostProcessor
extends OlapTidyPostProcessor {
    @Override
    public String getName() {
        return "MultiLinearRegression";
    }

    @Override
    public OlapTidyPostProcessorInstr create(OlapCompilationContext context, OlapInstrLocationRange range, int step, boolean addToResult, List<MdxFunctionArgExpression> args) {
        if (args.size() > 3) {
            throw new OlapCompilationException(context, OlapErrorCode.TIDY_POST_PROCESSOR_UNEXPECTED_ARGS_COUNT, new Serializable[]{this.getName(), Integer.valueOf(args.size())});
        }
        final boolean addErrors = !args.isEmpty() && args.get(0).getArg() instanceof MdxTrueLiteralExpression;
        final boolean addCorrelations = args.size() > 1 && args.get(1).getArg() instanceof MdxTrueLiteralExpression;
        final double threshold = args.size() > 2 && args.get(2).getArg() instanceof MdxDoubleLiteralExpression ? ((MdxDoubleLiteralExpression)args.get(2).getArg()).value() : 1.0E-7;
        return new OlapTidyPostProcessorInstr(this, this, range, step, addToResult){
            final /* synthetic */ OlapMultiLinearRegressionTidyPostProcessor this$0;
            {
                OlapMultiLinearRegressionTidyPostProcessor olapMultiLinearRegressionTidyPostProcessor = this$0;
                Objects.requireNonNull(olapMultiLinearRegressionTidyPostProcessor);
                this.this$0 = olapMultiLinearRegressionTidyPostProcessor;
                super(meta, range, step, addToResult);
            }

            @Override
            public OlapResTidyTable doPostProcess(OlapSelectStatementExecutionContext sContext, OlapResTidyTable table) {
                try {
                    return this.calculateRegression(sContext, table);
                }
                catch (RuntimeException ex) {
                    OlapLoggers.MDX_EVALUATION.error((Object)"[mdx] multi-linear post-processing regression error", (Throwable)ex);
                    throw this.createError(OlapErrorCode.TIDY_POST_PROCESSOR_ERROR, new Serializable[]{this.this$0.getName(), "Unexpected Error : " + OlapMultiLinearRegressionTidyPostProcessor.getExceptionMessage(ex)});
                }
            }

            private OlapResTidyTable calculateRegression(OlapSelectStatementExecutionContext sContext, OlapResTidyTable table) {
                List allColumns = table.getColumns();
                List<IOlapResTidyTableColumn> numericColumns = allColumns.stream().filter(col -> col.getType() == OlapScalarEntityTidyType.NUMERIC).toList();
                int numericColumnsCount = numericColumns.size();
                if (numericColumnsCount < 2) {
                    throw this.createError(OlapErrorCode.TIDY_POST_PROCESSOR_ERROR, new Serializable[]{this.this$0.getName(), "Expected at least 2 numerical columns, got " + numericColumnsCount});
                }
                ArrayList cols = new ArrayList();
                ArrayList<String> labels = new ArrayList<String>();
                double[] y = numericColumns.get(0).toDoubleArray(0.0);
                double[][] x = new double[y.length][numericColumnsCount - 1];
                for (int i = 1; i < numericColumnsCount; ++i) {
                    IOlapResTidyTableColumn numericColumn = numericColumns.get(i);
                    for (int j = 0; j < numericColumn.getRowCount(); ++j) {
                        x[j][i - 1] = numericColumn.getDoubleValue(j, 0.0);
                    }
                    labels.add(numericColumns.get(i).getName());
                }
                OlapResFlatTidyTableColumn<String> labelCol = new OlapResFlatTidyTableColumn<String>(OlapScalarEntityTidyType.CHARACTER, "label", "label");
                labelCol.add("u");
                for (int i = 1; i < numericColumnsCount; ++i) {
                    String name = (String)labels.get(i - 1);
                    labelCol.add(name);
                }
                if (addErrors) {
                    labelCol.add("\u02c6RSquared");
                    labelCol.add("\u02c6AdjustedRSquared");
                    labelCol.add("\u02c6TotalSumOfSquares");
                    labelCol.add("\u02c6ResidualSumOfSquares");
                }
                cols.add(labelCol);
                OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression(threshold);
                try {
                    OlapResFlatTidyTableColumn<Double> valueCol = new OlapResFlatTidyTableColumn<Double>(OlapScalarEntityTidyType.NUMERIC, "value", "value");
                    regression.newSampleData(y, x);
                    double[] b = regression.estimateRegressionParameters();
                    valueCol.add(b[0]);
                    for (int i = 1; i < numericColumnsCount; ++i) {
                        valueCol.add(b[i]);
                    }
                    if (addErrors) {
                        valueCol.add(regression.calculateRSquared());
                        valueCol.add(regression.calculateAdjustedRSquared());
                        valueCol.add(regression.calculateTotalSumOfSquares());
                        valueCol.add(regression.calculateResidualSumOfSquares());
                    }
                    cols.add(valueCol);
                }
                catch (RuntimeException ex) {
                    1.addErrorColumn(ex, cols, "value", labelCol.getRowCount());
                }
                try {
                    OlapResFlatTidyTableColumn<Double> pCol = new OlapResFlatTidyTableColumn<Double>(OlapScalarEntityTidyType.NUMERIC, "pValues", "pValues");
                    double[] pValues = OlapMultiLinearRegressionTidyPostProcessor.calculatePValues(regression);
                    OlapMultiLinearRegressionTidyPostProcessor.decorateValues(pCol, pValues, addErrors);
                    cols.add(pCol);
                }
                catch (RuntimeException ex) {
                    1.addErrorColumn(ex, cols, "pValues", labelCol.getRowCount());
                }
                if (addCorrelations) {
                    try {
                        OlapResFlatTidyTableColumn<Double> colCorr = new OlapResFlatTidyTableColumn<Double>(OlapScalarEntityTidyType.NUMERIC, "absMaxCorrelation", "absMaxCorrelation");
                        if (numericColumnsCount > 2) {
                            double[] corr = OlapMultiLinearRegressionTidyPostProcessor.calculateHighestCorrelation(x);
                            colCorr.add(null);
                            OlapMultiLinearRegressionTidyPostProcessor.decorateValues(colCorr, corr, addErrors);
                        } else {
                            colCorr.add(labelCol.getRowCount(), null);
                        }
                        cols.add(colCorr);
                    }
                    catch (RuntimeException ex) {
                        1.addErrorColumn(ex, cols, "correlation", labelCol.getRowCount());
                    }
                }
                CdArrayList infos = new CdArrayList();
                for (int i = 1; i < numericColumnsCount; ++i) {
                    OlapResTidyTableMdxInfo info = numericColumns.get(i).getHeaderMdxInfo();
                    if (info == null) continue;
                    infos.set(i, (Object)info);
                }
                if (!infos.isEmpty()) {
                    if (infos.size() < labelCol.getRowCount()) {
                        infos.set(labelCol.getRowCount() - 1, null);
                    }
                    OlapResFlatTidyTableColumn infoCol = new OlapResFlatTidyTableColumn(OlapScalarEntityTidyType.CHARACTER, OlapResFlatTidyTable.propertyColumnName("label", "mdxInfo"), "label", infos);
                    cols.add(infoCol);
                }
                OlapResFlatTidyTable regTable = new OlapResFlatTidyTable(table, cols);
                regTable.addQueryProperty("post-processing", "OLSMultipleLinearRegression");
                return regTable;
            }

            private static void addErrorColumn(RuntimeException ex, List<OlapResFlatTidyTableColumn<?>> cols, String columnName, int columnSize) {
                OlapResFlatTidyTableColumn<String> colPValues = new OlapResFlatTidyTableColumn<String>(OlapScalarEntityTidyType.CHARACTER, columnName, columnName);
                colPValues.add(OlapMultiLinearRegressionTidyPostProcessor.getExceptionMessage(ex));
                colPValues.add(columnSize - 1, null);
                cols.add(colPValues);
            }
        };
    }

    private static String getExceptionMessage(RuntimeException ex) {
        return CdStringUtils.isNullOrBlank((String)ex.getMessage()) ? ex.getClass().getSimpleName() : ex.getMessage();
    }

    private static void decorateValues(OlapResFlatTidyTableColumn<Double> pCol, double[] pValues, boolean addErrors) {
        Arrays.stream(pValues).forEach(pCol::add);
        if (addErrors) {
            pCol.add(4, null);
        }
    }

    private static double[] calculateHighestCorrelation(double[][] x) {
        PearsonsCorrelation corr = new PearsonsCorrelation(x);
        RealMatrix corrMatrix = corr.getCorrelationMatrix();
        double[] maxCorr = new double[corrMatrix.getColumnDimension()];
        for (int col = 0; col < corrMatrix.getColumnDimension(); ++col) {
            for (int row = 0; row < corrMatrix.getRowDimension(); ++row) {
                if (col == row) continue;
                maxCorr[col] = Math.max(maxCorr[col], FastMath.abs((double)corrMatrix.getEntry(row, col)));
            }
        }
        return maxCorr;
    }

    private static double[] calculatePValues(OLSMultipleLinearRegression regression) {
        double[] beta = regression.estimateRegressionParameters();
        double[] standardErrors = regression.estimateRegressionParametersStandardErrors();
        int residualdf = regression.estimateResiduals().length - beta.length;
        TDistribution tdistribution = new TDistribution((double)residualdf);
        double[] pVvalues = new double[beta.length];
        for (int i = 0; i < beta.length; ++i) {
            double pvalue;
            double tstat = beta[i] / standardErrors[i];
            pVvalues[i] = pvalue = tdistribution.cumulativeProbability(-FastMath.abs((double)tstat)) * 2.0;
        }
        return pVvalues;
    }

    public static void main(String[] args) {
        double[] y = new double[]{0.0, 0.0, 0.0, 8.0, 22.0, 26.0, 39.0, 45.0, 61.0, 75.0, 97.0, 106.0, 129.0, 149.0, 149.0, 157.0, 180.0, 183.0, 215.0, 203.0, 221.0, 223.0, 240.0, 304.0, 297.0, 296.0, 294.0, 300.0, 304.0, 314.0, 313.0, 301.0, 316.0, 331.0, 313.0, 300.0, 311.0, 302.0, 337.0, 317.0, 331.0, 288.0, 303.0, 305.0, 304.0, 345.0, 299.0, 304.0, 320.0, 284.0, 331.0, 282.0, 330.0, 309.0, 271.0, 314.0, 303.0, 284.0, 299.0, 319.0, 323.0, 285.0, 309.0, 287.0, 299.0, 321.0, 308.0, 300.0, 306.0, 287.0, 287.0, 314.0, 302.0, 282.0, 318.0, 318.0, 312.0, 294.0, 332.0, 291.0, 284.0, 318.0, 327.0, 332.0, 298.0, 293.0, 312.0, 309.0, 313.0, 291.0, 308.0, 319.0, 319.0, 319.0, 317.0, 314.0, 298.0, 304.0, 307.0, 305.0, 299.0, 287.0, 283.0, 288.0, 293.0, 287.0, 302.0, 279.0, 250.0, 257.0, 253.0, 275.0, 265.0, 249.0, 244.0, 239.0, 250.0, 240.0, 248.0, 249.0, 214.0, 204.0, 225.0, 216.0, 213.0, 164.0, 186.0, 145.0, 124.0, 124.0, 119.0, 115.0, 96.0, 76.0, 81.0, 67.0, 51.0, 40.0, 24.0, 14.0, 9.0};
        double[] xT = new double[]{0.0, 0.0, 0.0, 2.0, 0.0, 1.0, 1.0, 2.0, 5.0, 5.0, 6.0, 4.0, 3.0, 5.0, 9.0, 14.0, 10.0, 6.0, 12.0, 7.0, 7.0, 8.0, 7.0, 15.0, 10.0, 15.0, 15.0, 7.0, 10.0, 15.0, 14.0, 14.0, 8.0, 16.0, 14.0, 13.0, 12.0, 9.0, 8.0, 15.0, 6.0, 12.0, 12.0, 16.0, 11.0, 11.0, 12.0, 7.0, 16.0, 8.0, 11.0, 16.0, 13.0, 15.0, 9.0, 16.0, 17.0, 18.0, 10.0, 15.0, 13.0, 5.0, 11.0, 14.0, 9.0, 14.0, 17.0, 9.0, 10.0, 9.0, 11.0, 19.0, 12.0, 11.0, 6.0, 9.0, 11.0, 9.0, 20.0, 12.0, 10.0, 13.0, 14.0, 9.0, 10.0, 13.0, 11.0, 18.0, 11.0, 10.0, 10.0, 9.0, 14.0, 11.0, 17.0, 22.0, 10.0, 13.0, 13.0, 8.0, 12.0, 12.0, 13.0, 11.0, 10.0, 17.0, 12.0, 11.0, 5.0, 10.0, 11.0, 9.0, 7.0, 7.0, 6.0, 7.0, 7.0, 4.0, 11.0, 14.0, 6.0, 3.0, 8.0, 7.0, 5.0, 8.0, 4.0, 2.0, 3.0, 1.0, 5.0, 5.0, 3.0, 6.0, 7.0, 4.0, 3.0, 1.0, 2.0, 0.0, 1.0};
        Random random = new Random();
        double[][] x = new double[y.length][2];
        for (int j = 0; j < y.length; ++j) {
            x[j][0] = xT[j];
            x[j][1] = xT[j] + random.nextDouble() * 20.0;
        }
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.newSampleData(y, x);
        double[] toto = OlapMultiLinearRegressionTidyPostProcessor.calculateHighestCorrelation(x);
        double[] p = OlapMultiLinearRegressionTidyPostProcessor.calculatePValues(regression);
        double[] b = regression.estimateRegressionParameters();
        boolean i = false;
    }
}

