/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.tidypostprocessor;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxLongLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxNoFunctionArgExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.ast.id.MdxIdentifierExpressionCompiler;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierNamePart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTable;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapTopLevelAxisEvaluationContext;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapDimensionPropertiesTidyPostProcessorArg;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessor;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessorInstr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapDimensionPropertiesTidyPostProcessor
extends OlapTidyPostProcessor {
    @Override
    public String getName() {
        return "DimensionProperties";
    }

    @Override
    public boolean canHandleCellOnError() {
        return true;
    }

    @Override
    public boolean canHandleTruncatedResult() {
        return true;
    }

    @Override
    public boolean canHandlePaging() {
        return true;
    }

    @Override
    public OlapTidyPostProcessorInstr create(OlapCompilationContext context, final OlapInstrLocationRange range, int step, boolean addToResult, List<MdxFunctionArgExpression> args) {
        if (args.isEmpty()) {
            return new OlapTidyPostProcessorInstr(this, this, range, step, addToResult){
                {
                    Objects.requireNonNull(this$0);
                    super(meta, range, step, addToResult);
                }

                @Override
                protected OlapResTidyTable doPostProcess(OlapSelectStatementExecutionContext sContext, OlapResTidyTable table) {
                    return table;
                }
            };
        }
        final ArrayList<OlapDimensionPropertiesTidyPostProcessorArg> properties = new ArrayList<OlapDimensionPropertiesTidyPostProcessorArg>();
        for (int aa = 0; aa < args.size(); ++aa) {
            MdxExpression expr = args.get(aa).getArg();
            OlapDimensionPropertiesTidyPostProcessorArg arg = OlapDimensionPropertiesTidyPostProcessor.createArg(range, aa, expr);
            if (arg == null) continue;
            properties.add(arg);
        }
        return new OlapTidyPostProcessorInstr(this, this, range, step, addToResult){
            {
                Objects.requireNonNull(this$0);
                super(meta, range2, step, addToResult);
            }

            @Override
            public OlapResTidyTable doPostProcess(OlapSelectStatementExecutionContext sContext, OlapResTidyTable table) {
                if (table instanceof OlapResMdxTidyTable) {
                    OlapResMdxTidyTable mdxTable = (OlapResMdxTidyTable)table;
                    List<OlapDimensionPropertiesTidyPostProcessorArg> propertiesR = OlapDimensionPropertiesTidyPostProcessor.resolveProperties(mdxTable, range, properties);
                    table = mdxTable.postProcessForDimensionProperties(propertiesR);
                }
                return table;
            }
        };
    }

    @Nullable
    private static OlapDimensionPropertiesTidyPostProcessorArg createArg(OlapInstrLocationRange range, int index, MdxExpression arg) {
        MdxFunctionCallExpression fun;
        if (arg instanceof MdxIdentifierExpression) {
            MdxIdentifierExpression id = (MdxIdentifierExpression)arg;
            OlapEntityIdentifier prop = OlapDimensionPropertiesTidyPostProcessor.extractProperty(range, index, id);
            return new OlapDimensionPropertiesTidyPostProcessorArg(prop, null, -index - 1);
        }
        if (arg instanceof MdxFunctionCallExpression && "_".equals((fun = (MdxFunctionCallExpression)arg).getName())) {
            List<MdxFunctionArgExpression> exprs = fun.getArgs();
            OlapEntityIdentifier prop = OlapDimensionPropertiesTidyPostProcessor.extractProperty(range, index, exprs);
            Integer axis = OlapDimensionPropertiesTidyPostProcessor.extractAxis(range, index, exprs);
            int pos = OlapDimensionPropertiesTidyPostProcessor.extractPos(range, index, exprs, -index - 1);
            return new OlapDimensionPropertiesTidyPostProcessorArg(prop, axis, pos);
        }
        if (arg instanceof MdxNoFunctionArgExpression) {
            return null;
        }
        throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_ARG_MISMATCH, Integer.valueOf(index + 1));
    }

    private static OlapEntityIdentifier extractProperty(OlapInstrLocationRange range, int index, MdxIdentifierExpression id) {
        OlapEntityIdentifier oid = MdxIdentifierExpressionCompiler.createOlapIdentifier(id);
        if (oid.isKey()) {
            throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_ARG_MISMATCH, Integer.valueOf(index + 1));
        }
        if (oid.getPartCount() < 2) {
            throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_ARG_MISMATCH, Integer.valueOf(index + 1));
        }
        return oid;
    }

    private static OlapEntityIdentifier extractProperty(OlapInstrLocationRange range, int index, List<MdxFunctionArgExpression> exprs) {
        if (exprs.isEmpty()) {
            throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_ARG_MISMATCH, Integer.valueOf(index + 1));
        }
        MdxExpression expr = exprs.getFirst().getArg();
        if (expr instanceof MdxIdentifierExpression) {
            MdxIdentifierExpression id = (MdxIdentifierExpression)expr;
            return OlapDimensionPropertiesTidyPostProcessor.extractProperty(range, index, id);
        }
        throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_ARG_MISMATCH, Integer.valueOf(index + 1));
    }

    @Nullable
    private static Integer extractAxis(OlapInstrLocationRange range, int index, List<MdxFunctionArgExpression> exprs) {
        if (exprs.size() <= 1) {
            return null;
        }
        MdxExpression expr = exprs.get(1).getArg();
        if (expr instanceof MdxNoFunctionArgExpression) {
            return null;
        }
        if (expr instanceof MdxLongLiteralExpression) {
            MdxLongLiteralExpression val = (MdxLongLiteralExpression)expr;
            return (int)val.value();
        }
        throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_ARG_MISMATCH, Integer.valueOf(index + 1));
    }

    private static int extractPos(OlapInstrLocationRange range, int index, List<MdxFunctionArgExpression> exprs, int defaultValue) {
        if (exprs.size() <= 2) {
            return defaultValue;
        }
        MdxExpression expr = exprs.get(2).getArg();
        if (expr instanceof MdxNoFunctionArgExpression) {
            return defaultValue;
        }
        if (expr instanceof MdxLongLiteralExpression) {
            MdxLongLiteralExpression val = (MdxLongLiteralExpression)expr;
            return (int)val.value();
        }
        throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_ARG_MISMATCH, Integer.valueOf(index + 1));
    }

    private static List<OlapDimensionPropertiesTidyPostProcessorArg> resolveProperties(OlapResMdxTidyTable table, OlapInstrLocationRange range, List<OlapDimensionPropertiesTidyPostProcessorArg> properties) {
        ArrayList<OlapDimensionPropertiesTidyPostProcessorArg> resolvedProperties = new ArrayList<OlapDimensionPropertiesTidyPostProcessorArg>();
        for (int pp = 0; pp < properties.size(); ++pp) {
            OlapDimensionPropertiesTidyPostProcessorArg resolvedProperty;
            OlapDimensionPropertiesTidyPostProcessorArg property = properties.get(pp);
            String propertyName = ((OlapEntityIdentifierNamePart)property.id.getLastPart()).getName();
            OlapEntityIdentifier propertyScope = property.id.prefix();
            OlapAxisInstr axisInstr = null;
            OlapTopLevelAxisEvaluationContext axisEvalContext = new OlapTopLevelAxisEvaluationContext(table.getContext(), axisInstr);
            OlapNonScalarEntity entity = axisEvalContext.lookupEntityByMdxIdentifier(axisEvalContext.getNameContext(), OlapMdxEntityLookupKinds.CUBE_ENTITY, propertyScope);
            if (entity instanceof OlapHierarchy) {
                OlapHierarchy hierarchy = (OlapHierarchy)entity;
                resolvedProperty = new OlapDimensionPropertiesTidyPostProcessorArg(property.id, hierarchy, property.axis, property.pos);
                resolvedProperties.add(resolvedProperty);
            } else if (entity instanceof OlapLevel) {
                OlapLevel level = (OlapLevel)entity;
                resolvedProperty = new OlapDimensionPropertiesTidyPostProcessorArg(property.id, level.getHierarchy(), property.axis, property.pos);
                resolvedProperties.add(resolvedProperty);
            } else {
                throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_HIERARCHY_UNKNOWN, new Serializable[]{Integer.valueOf(pp + 1), property.id.asString()});
            }
            OlapMemberPropertyManager propertyManager = axisEvalContext.getMemberPropertyManager();
            IOlapHierarchyPermission permissions = axisEvalContext.getHierarchyPermissions(resolvedProperty.hierarchy);
            List<OlapUserDefinedMemberProperty> props = propertyManager.getUserDefinedProperties(permissions, resolvedProperty.hierarchy, propertyName);
            if (props != null && !props.isEmpty()) continue;
            throw new OlapEvaluationException(range, OlapErrorCode.TPP_DIMENSION_PROPERTIES_PROPERTY_UNKNOWN, new Serializable[]{Integer.valueOf(pp + 1), property.id.asString()});
        }
        return resolvedProperties;
    }
}

