/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context.sets;

import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluation;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetGraph;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class OlapSetEvaluationGraph {
    private final Map<String, OlapStack<OlapSetDeclaration>> evaluationThreads = new HashMap<String, OlapStack<OlapSetDeclaration>>();
    private final Set<OlapSetDeclaration> evaluating = new HashSet<OlapSetDeclaration>();

    public void clear() {
        String th = Thread.currentThread().getName();
        this.evaluationThreads.remove(th);
    }

    public OlapStack<OlapSetDeclaration> forkForParallelLambdaProcessing() {
        String th = Thread.currentThread().getName();
        OlapStack<OlapSetDeclaration> fork = new OlapStack<OlapSetDeclaration>();
        OlapStack<OlapSetDeclaration> stack = this.evaluationThreads.get(th);
        if (stack != null) {
            fork.setupForParallelLambdaProcessing(stack);
        }
        return fork;
    }

    public void initForParallelLambdaProcessing(OlapStack<OlapSetDeclaration> from) {
        String th = Thread.currentThread().getName();
        OlapStack<OlapSetDeclaration> stack = new OlapStack<OlapSetDeclaration>();
        stack.setupForParallelLambdaProcessing(from);
        this.evaluationThreads.put(th, stack);
    }

    public void push(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        String th = Thread.currentThread().getName();
        OlapStack stack = this.evaluationThreads.computeIfAbsent(th, s -> new OlapStack());
        stack.push(set);
        boolean pop = false;
        try {
            OlapSetEvaluation cycle = this.checkForCycle(eContext, set);
            if (cycle != null) {
                pop = true;
                RuntimeException err = cycle.getError();
                if (err == null) {
                    throw new RuntimeException("internal error: unexpected missing exception while pushing evaluating set for thread [" + th + "] set [" + set.getQualifiedSetName() + "]");
                }
                throw err;
            }
        }
        catch (RuntimeException ex) {
            pop = true;
            OlapLoggers.MDX_EVALUATION.error((Object)("unexpected exception while pushing evaluating set for thread [" + th + "] set [" + set.getQualifiedSetName() + "]"), (Throwable)ex);
            throw ex;
        }
        finally {
            if (pop) {
                this.pop(set);
            }
        }
    }

    public void pop(OlapSetDeclaration set) {
        String th = Thread.currentThread().getName();
        OlapStack<OlapSetDeclaration> stack = this.evaluationThreads.get(th);
        if (stack == null) {
            throw new RuntimeException("internal error: unexpected missing set evaluation stack for thread [" + th + "] while pop set [" + set.getQualifiedSetName() + "]");
        }
        OlapSetDeclaration prev = stack.pop();
        if (prev != set) {
            throw new RuntimeException("internal error: set mismatch for thread [" + th + "] while pop set [" + set.getQualifiedSetName() + "] [prev:" + prev.getQualifiedSetName() + "]");
        }
    }

    @Nullable
    private OlapSetEvaluation checkForCycle(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        String th = Thread.currentThread().getName();
        OlapStack<OlapSetDeclaration> stack = this.evaluationThreads.get(th);
        if (stack == null) {
            throw new RuntimeException("internal error: unexpected missing set evaluation stack for thread [" + th + "] while checking for cycle while evaluating set [" + set.getQualifiedSetName() + "]");
        }
        if (stack.isEmpty()) {
            throw new RuntimeException("internal error: unexpected empty set evaluation stack for thread [" + th + "] while checking for cycle while evaluating set [" + set.getQualifiedSetName() + "]");
        }
        OlapSetDeclaration top = stack.peek();
        if (!top.equals(set)) {
            throw new RuntimeException("internal error: unexpected set stack for thread [" + th + "] while checking for cycle while evaluating set [" + set.getQualifiedSetName() + "] [top:" + top.getQualifiedSetName() + "]");
        }
        OlapSetEvaluation cycle = this.checkForCycle(eContext, th, stack, set);
        return cycle;
    }

    @Nullable
    private OlapSetEvaluation checkForCycle(OlapEvaluationContext eContext, String th, OlapStack<OlapSetDeclaration> stack, OlapSetDeclaration set) {
        OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] checkForCycle for set [" + set.getQualifiedSetName() + "]"));
        ArrayList<String> cycle = new ArrayList<String>();
        cycle.add(set.getQualifiedSetName());
        MutableBoolean found = new MutableBoolean();
        stack.forEachItem((prev, item, count, index) -> {
            if (index > 0) {
                cycle.add(item.getQualifiedSetName());
                if (item.equals(set)) {
                    found.setValue(true);
                    return false;
                }
            }
            return true;
        });
        if (found.isTrue()) {
            OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] checkForCycle for set [" + set.getQualifiedSetName() + "] from stack: " + String.valueOf(cycle)));
            return new OlapSetEvaluation(set, null, (RuntimeException)((Object)new OlapEvaluationException(eContext, OlapErrorCode.SET_FORMULA_INFINITE_LOOP, new Serializable[]{set.getQualifiedSetName(), ((Object)cycle).toString()})));
        }
        if (this.evaluationThreads.size() > 1) {
            OlapSetGraph graph = new OlapSetGraph();
            for (OlapStack<OlapSetDeclaration> value : this.evaluationThreads.values()) {
                graph.add(value);
            }
            if (graph.hasCycle()) {
                OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] checkForCycle for set [" + set.getQualifiedSetName() + "] from graph: " + String.valueOf(graph)));
                return new OlapSetEvaluation(set, null, (RuntimeException)((Object)new OlapEvaluationException(eContext, OlapErrorCode.SET_FORMULA_INFINITE_LOOP, new Serializable[]{set.getQualifiedSetName(), graph.toString()})));
            }
        }
        return null;
    }

    public boolean isEvaluating(OlapSetDeclaration set) {
        return this.evaluating.contains(set);
    }

    public void addEvaluating(OlapSetDeclaration set) {
        this.evaluating.add(set);
    }

    public void removeEvaluating(OlapSetDeclaration set) {
        if (!this.evaluating.contains(set)) {
            throw new RuntimeException("internal error: unexpected missing evaluating set [" + set.getQualifiedSetName() + "] while removing evaluation");
        }
        this.evaluating.remove(set);
    }
}

