/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context.sets;

import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.eval.cache.OlapCacheManager;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluation;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationGraph;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationToken;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationTokenKind;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class OlapSetEvaluationController {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition evaluating = this.lock.newCondition();
    private final OlapSetEvaluationGraph evaluations = new OlapSetEvaluationGraph();

    public void clear() {
        this.lock.lock();
        try {
            this.evaluations.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public OlapStack<OlapSetDeclaration> forkForParallelLambdaProcessing() {
        this.lock.lock();
        try {
            OlapStack<OlapSetDeclaration> olapStack = this.evaluations.forkForParallelLambdaProcessing();
            return olapStack;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void initForParallelLambdaProcessing(OlapStack<OlapSetDeclaration> from) {
        this.lock.lock();
        try {
            this.evaluations.initForParallelLambdaProcessing(from);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void push(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        this.lock.lock();
        try {
            this.evaluations.push(eContext, set);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pop(OlapSetDeclaration set) {
        this.lock.lock();
        try {
            this.evaluations.pop(set);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSetEvaluationToken getEvaluationToken(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        this.lock.lock();
        try {
            OlapSetEvaluationToken olapSetEvaluationToken = this.doGetEvaluationToken(eContext, set);
            return olapSetEvaluationToken;
        }
        finally {
            this.lock.unlock();
        }
    }

    private OlapSetEvaluationToken doGetEvaluationToken(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        OlapSetEvaluation evaluation = this.getEvaluation(eContext, set);
        if (evaluation != null) {
            return new OlapSetEvaluationToken(OlapSetEvaluationTokenKind.AVAILABLE, evaluation);
        }
        if (this.evaluations.isEvaluating(set)) {
            return new OlapSetEvaluationToken(OlapSetEvaluationTokenKind.EVALUATING);
        }
        this.evaluations.addEvaluating(set);
        return new OlapSetEvaluationToken(OlapSetEvaluationTokenKind.EVALUATE);
    }

    @Nullable
    public OlapSetEvaluation getEvaluation(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        if (set.isDynamicEvaluation()) {
            OlapSetEvaluation eval = this.statementContext(eContext).getEvaluatedDynamicSetDeclaration(eContext, set);
            return eval;
        }
        if (set.isForSelect()) {
            OlapSetEvaluation eval = this.statementContext(eContext).getEvaluatedStaticSetDeclaration(eContext, set);
            return eval;
        }
        if (set.isSessionScoped()) {
            OlapSetEvaluation eval = this.sessionContext(eContext).getEvaluatedStaticSetDeclaration(eContext, set);
            return eval;
        }
        OlapSetEvaluation eval = this.cacheManager(eContext).getEvaluatedStaticSetDeclaration(eContext, set);
        return eval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapSetEvaluation evaluate(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] evaluating set [" + set.getQualifiedSetName() + "]"));
        try {
            OlapSetEvaluation eval = this.doEvaluate(eContext, set);
            this.lock.lock();
            try {
                this.evaluations.removeEvaluating(set);
                this.evaluating.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            OlapSetEvaluation olapSetEvaluation = eval;
            return olapSetEvaluation;
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] evaluating set [" + set.getQualifiedSetName() + "] unexpected exception"));
            this.lock.lock();
            try {
                this.evaluations.removeEvaluating(set);
                this.evaluating.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            throw ex;
        }
        finally {
            OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] evaluating set [" + set.getQualifiedSetName() + "] done"));
        }
    }

    private OlapSetEvaluation doEvaluate(OlapEvaluationContext eContext, OlapSetDeclaration set) {
        if (set.isDynamicEvaluation()) {
            OlapSetEvaluation eval = this.statementContext(eContext).evaluateDynamicSetDeclaration(eContext, set);
            return eval;
        }
        if (set.isForSelect()) {
            OlapSetEvaluation eval = this.statementContext(eContext).evaluateStaticSetDeclaration(eContext, set);
            return eval;
        }
        if (set.isSessionScoped()) {
            OlapSetEvaluation eval = this.sessionContext(eContext).evaluateStaticSetDeclaration(eContext, set);
            return eval;
        }
        OlapSetEvaluation eval = this.cacheManager(eContext).evaluateStaticSetDeclaration(eContext, set);
        return eval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(OlapEvaluationContext eContext, OlapSetDeclaration set) throws InterruptedException {
        OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] waiting for set [" + set.getQualifiedSetName() + "]"));
        try {
            this.lock.lock();
            try {
                if (this.evaluations.isEvaluating(set)) {
                    this.evaluating.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        finally {
            OlapLoggers.MDX_EVALUATION_SET.info((Object)("[set-evaluation] waiting for set [" + set.getQualifiedSetName() + "] done"));
        }
    }

    public void onEvaluationInterrupted(OlapSetDeclaration set, RuntimeException error) {
        this.lock.lock();
        try {
            this.evaluations.removeEvaluating(set);
            this.evaluating.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private OlapMdxStatementExecutionContext statementContext(OlapEvaluationContext eContext) {
        return eContext.getStatementExecutionContext();
    }

    private OlapEngineSessionContext sessionContext(OlapEvaluationContext eContext) {
        OlapMdxStatementExecutionContext statementContext = this.statementContext(eContext);
        OlapEngineRequestContext requestContext = statementContext.getRequestContext();
        OlapEngineSessionContext sessionContext = requestContext.getSessionContext();
        return sessionContext;
    }

    private OlapCacheManager cacheManager(OlapEvaluationContext eContext) {
        OlapMdxStatementExecutionContext statementContext = this.statementContext(eContext);
        OlapEngineRequestContext requestContext = statementContext.getRequestContext();
        OlapCacheManager cacheManager = requestContext.getCacheManager();
        return cacheManager;
    }
}

