/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFStaticCategoryMemberEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFEvalTupleVisibility;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.mdx.set.OlapVisualTotalsFunction;
import crazydev.iccube.olap.eval.select.context.OlapCategoryMemberFormulaEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_COMPATIBLE)
public class OlapStaticCategoryMemberFormulaEvaluationContext
extends OlapCategoryMemberFormulaEvaluationContext {
    private static final Set<Class<? extends OlapFunction>> FORBIDDEN_FUNCTIONS = new HashSet<Class>(Arrays.asList(OlapVisualTotalsFunction.class));
    private final OlapCube cube;

    public OlapStaticCategoryMemberFormulaEvaluationContext(OlapMdxStatementExecutionContext scontext, OlapCube cube) {
        super(scontext);
        this.cube = cube;
    }

    @Override
    public String getUsage() {
        return "static category member";
    }

    @Override
    protected Set<Class<? extends OlapFunction>> getForbiddenFunctions() {
        return FORBIDDEN_FUNCTIONS;
    }

    @Override
    public OlapCube getCube() {
        return this.cube;
    }

    @Override
    public void assertDynamicCategoryUsage(OlapEntityIdentifier id, OlapNonScalarEntity entity) {
        throw new OlapEvaluationException(this, OlapErrorCode.DYNAMIC_CATEGORY_USAGE, new Serializable[]{id.asString(), this.getUsage()});
    }

    @Override
    public GFContext createGFContext() {
        return new GFStaticCategoryMemberEvalContext(this);
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public GFEvalTupleVisibility getEvalTupleVisibility() {
        return GFEvalTupleVisibility.STATIC;
    }

    @Override
    protected OlapEvaluationContext doForkForParallelLambdaProcessing() {
        return new OlapStaticCategoryMemberFormulaEvaluationContext(this.statementExecutionContext, this.cube);
    }
}

