/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapSubSelectCube;
import crazydev.iccube.olap.entity.cmember.OlapSelectCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.result.slicer.OlapSlicerFilter;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutors;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.CONDITIONALLY_THREAD_SAFE)
public class OlapSelectStatementExecutionContext
extends OlapMdxStatementWithCubeSelectExecutionContext {
    private final boolean subSelect;
    private final boolean onAxes;
    private final List<OlapTupleSet<OlapTuple>> axes = new ArrayList<OlapTupleSet<OlapTuple>>();
    private final Map<String, OlapDeclaredFunction> declaredFunctions;
    private final Map<String, OlapSetDeclaration> setDeclarations;
    @Nullable
    private OlapResSlicer slicer;
    @Nullable
    private OlapSlicerFilter slicerDimensionFilter;
    private boolean isSlicerAsSet;
    private volatile boolean hasEvaluatedSlicer;
    private volatile boolean hasEvaluatedSlicerAndSubSelect;

    public OlapSelectStatementExecutionContext(OlapEngineRequestContext requestContext, OlapProperties requestProperties, @Nullable MdxAnnotation[] annotations, @Nullable OlapInstrExecListener instrExecListener, boolean subSelect, boolean onAxes, OlapSchema schema, OlapCube cube) {
        this(requestContext, requestProperties, annotations, instrExecListener, null, null, null, subSelect, onAxes, schema, cube, null, true);
    }

    private OlapSelectStatementExecutionContext(OlapEngineRequestContext requestContext, OlapProperties requestProperties, @Nullable MdxAnnotation[] annotations, @Nullable OlapInstrExecListener instrExecListener, @Nullable Map<String, OlapDeclaredFunction> declaredFunctions, @Nullable Map<String, OlapSetDeclaration> setDeclarations, @Nullable OlapSelectCalculatedMemberManager calcMemberManager, boolean subSelect, boolean onAxes, OlapSchema schema, OlapCube cube, @Nullable List<OlapTupleSet<? extends OlapTuple>> filterByInfo, boolean withEval) {
        super(requestContext, requestProperties, annotations, instrExecListener, calcMemberManager, schema, cube, withEval, filterByInfo);
        this.subSelect = subSelect;
        this.onAxes = onAxes;
        this.declaredFunctions = declaredFunctions != null ? declaredFunctions : new CdCaseInsensitiveHashMap();
        this.setDeclarations = setDeclarations != null ? setDeclarations : new CdCaseInsensitiveHashMap();
    }

    public OlapSelectStatementExecutionContext copyForNonEmptyBehaviorSetup() {
        OlapSelectStatementExecutionContext copy = new OlapSelectStatementExecutionContext(this.getRequestContext(), this.getRequestProperties(), this.getAnnotations(), this.getInstrExecListener(), this.declaredFunctions, this.setDeclarations, this.getCalcMemberManager(), false, this.onAxes, this.getSchema(), this.getCube(), null, false);
        copy.staticSets.putAll(this.staticSets);
        copy.dynamicSets.putAll(this.dynamicSets);
        return copy;
    }

    public OlapSelectStatementExecutionContext copyForSubSelectEvaluation() {
        return new OlapSelectStatementExecutionContext(this.getRequestContext(), this.getRequestProperties(), this.getAnnotations(), this.getInstrExecListener(), this.declaredFunctions, this.setDeclarations, this.getCalcMemberManager(), true, this.onAxes, this.getSchema(), this.getCube(), this.getFilterByInfo(), this.isWithEval());
    }

    public OlapSelectStatementExecutionContext copyForPostProcessing() {
        return new OlapSelectStatementExecutionContext(this.getRequestContext(), this.getRequestProperties(), this.getAnnotations(), this.getInstrExecListener(), this.declaredFunctions, this.setDeclarations, this.getCalcMemberManager(), this.subSelect, false, this.getSchema(), this.getCube(), this.getFilterByInfo(), this.isWithEval());
    }

    @Override
    public boolean isDimensionalityCheck() {
        OlapProperties props = this.getRequestProperties();
        return props.isDimensionalityCheck();
    }

    @Override
    public boolean isSubSelect() {
        return this.subSelect;
    }

    @Override
    public boolean isOnAxes() {
        return this.onAxes;
    }

    @Override
    public String getUsage() {
        return "select [cube:" + ONames.name4Log(this.getCube()) + "]";
    }

    @Override
    @Nullable
    public OlapSetDeclaration lookupSetDeclaration(OlapEntityIdentifier identifier) {
        OlapSetDeclaration declaration = null;
        String name = identifier.asSingleRegularName();
        if (name != null && (declaration = this.setDeclarations.get(name)) == null) {
            declaration = super.lookupSetDeclaration(identifier);
        }
        return declaration;
    }

    public boolean containsStatementSetDeclaration(String name) {
        return this.setDeclarations.containsKey(name);
    }

    public void addStatementSetDeclaration(@Nullable String cube, String name, boolean dynamicEvaluation, String mdx, OlapInstr formula) {
        if (this.containsStatementSetDeclaration(name)) {
            throw new CdProgrammingException("internal error : duplicated named-set [" + name + "]!");
        }
        this.setDeclarations.put(name, new OlapSetDeclaration(true, cube, name, false, dynamicEvaluation, mdx, formula, null, null));
    }

    @Override
    public OlapTupleSet<OlapTuple> getAxis(int number) {
        if (number < 0 || number >= this.axes.size()) {
            throw new OlapEvaluationException(this, OlapErrorCode.MDX_AXIS_FUNCTION_MISSING_AXIS, Integer.valueOf(number));
        }
        return this.axes.get(number);
    }

    @Override
    @Nullable
    public OlapTupleSet<OlapTuple> getSubSelectAxis(int number) {
        OlapCube cube = this.getCube();
        if (cube instanceof OlapSubSelectCube) {
            OlapSubSelectCube subSelectCube = (OlapSubSelectCube)cube;
            return subSelectCube.getAxisForMdxFunction(number);
        }
        return null;
    }

    public void addAxis(OlapTupleSet<OlapTuple> axis) {
        this.axes.add(axis);
    }

    @Override
    @Nullable
    public OlapFunction lookupFunction(String name) {
        OlapFunction function = super.lookupFunction(name);
        if (function == null) {
            function = this.declaredFunctions.get(name);
        }
        return function;
    }

    @Override
    public OlapDeclaredFunction lookupDeclaredFunction(String name) {
        OlapDeclaredFunction function = super.lookupDeclaredFunction(name);
        if (function == null) {
            function = this.declaredFunctions.get(name);
        }
        return function;
    }

    public void addDeclaredFunctionIfNotContained(@Nullable OlapInstrLocationRange range, OlapDeclaredFunction function) {
        if (this.lookupDeclaredFunction(function.getName()) != null) {
            throw new OlapEvaluationException(range, OlapErrorCode.DUPLICATED_FUNCTION, new Serializable[]{function.getName()});
        }
        this.declaredFunctions.put(function.getName(), function);
    }

    public boolean isSubSelectOff() {
        return this.getCube().getSubSelectTupleFilter() == null;
    }

    public int getMdxCellCountMax() {
        OlapEngineRequestContext context = this.getRequestContext();
        Integer requestCellCountMax = context.getMdxCellCountMax();
        OlapMdxExecutors executors = this.getMdxExecutors();
        int cellCountMax = executors.getCellCountMax(requestCellCountMax);
        return cellCountMax;
    }

    @Override
    public int getMdxTimeoutS() {
        OlapEngineRequestContext context = this.getRequestContext();
        Integer requestTimeoutS = context.getMdxTimeoutS();
        OlapMdxExecutors executors = this.getMdxExecutors();
        int timeoutS = executors.getTimeoutS(requestTimeoutS);
        return timeoutS;
    }

    @Override
    @Nullable
    public OlapResSlicer getSlicer() {
        return this.slicer;
    }

    public void setSlicer(@Nullable OlapResSlicer slicer) {
        if (slicer == null) {
            this.slicer = null;
            this.isSlicerAsSet = false;
            this.slicerDimensionFilter = null;
        } else {
            this.slicer = slicer;
            this.isSlicerAsSet = slicer.getTupleCount() > 1;
            this.slicerDimensionFilter = slicer.getSlicerDimensionFilter();
        }
    }

    @Override
    @Nullable
    public OlapSlicerFilter getSlicerTupleFilter() {
        return this.slicerDimensionFilter;
    }

    public void setHasEvaluatedSlicer() {
        this.hasEvaluatedSlicer = true;
    }

    @Override
    @Nullable
    public boolean hasEvaluatedSlicer() {
        return this.hasEvaluatedSlicer;
    }

    public void setHasEvaluatedSlicerAndSubSelect() {
        this.hasEvaluatedSlicerAndSubSelect = true;
    }

    @Override
    @Nullable
    public boolean hasEvaluatedSlicerAndSubSelect() {
        return this.hasEvaluatedSlicerAndSubSelect;
    }

    @Override
    public void assertSlicerAndSubSelectEvaluated() {
        if (!this.hasEvaluatedSlicerAndSubSelect()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }
}

