/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapCubeEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.OlapNullEntity;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFPerspectiveExprEvalContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.Serializable;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_COMPATIBLE)
public class OlapPerspectiveExpressionEvaluationContext
extends OlapExpressionEvaluationContext {
    private final IOlapBuilderPerspectiveDef perspective;
    private final OlapSchema schema;
    private final OlapMemberFilter memberFilter;
    private OlapCube cube;

    public OlapPerspectiveExpressionEvaluationContext(OlapMdxStatementWithCubeSelectExecutionContext scontext, IOlapBuilderPerspectiveDef perspective) {
        super(scontext);
        this.perspective = perspective;
        this.schema = scontext.getSchema();
        this.cube = scontext.getCube().getUnderlying();
        this.memberFilter = scontext.getSchemaPermissionsWithoutPerspective().getDimensionsPermissions(this.cube).getMemberFilter();
    }

    @Override
    public String getUsage() {
        return "perspective-expression";
    }

    @Override
    public OlapCube getCube() {
        return this.cube;
    }

    @Override
    public IOlapSchemaPermission getSchemaPermissions() {
        return this.getSchemaPermissionsWithoutPerspective();
    }

    @Override
    @Nullable
    public OlapMemberFilter getMemberFilter() {
        return this.memberFilter;
    }

    @Override
    public OlapNonScalarEntity lookupUserDefinedMeasureByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        OlapCube specifiedCube;
        if (identifier.getPartCount() > 1 && (specifiedCube = this.lookupSpecifiedCube(nameContext, identifier)) != null) {
            if (!this.perspective.isDefault() && !specifiedCube.equals(this.cube)) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.PERSPECTIVE_NON_DEFAULT_CUBE_MISMATCH, new Serializable[]{this.perspective.getName(), this.cube.getName(nameContext), specifiedCube.getName(nameContext)});
            }
            OlapNonScalarEntity entity = this.lookupUserDefinedMeasure(nameContext, specifiedCube, identifier.subIdentifier(1));
            if (entity != null) {
                return entity;
            }
            return OlapNullEntity.INSTANCE;
        }
        OlapNonScalarEntity entity = this.lookupUserDefinedMeasure(nameContext, this.cube, identifier);
        if (!this.perspective.isDefault() || entity != null) {
            return entity == null ? OlapNullEntity.INSTANCE : entity;
        }
        for (OlapRegularCube schemaCube : this.schema.getCubes()) {
            if (schemaCube.equals(this.cube) || (entity = this.lookupUserDefinedMeasure(nameContext, schemaCube, identifier)) == null) continue;
            return entity;
        }
        return OlapNullEntity.INSTANCE;
    }

    @Nullable
    private OlapNonScalarEntity lookupUserDefinedMeasure(OlapNameContext nameContext, OlapCube specifiedCube, OlapEntityIdentifier identifier) {
        OlapCubeCalculatedMemberManager manager = specifiedCube.getCalcMemberManager();
        OlapUserMeasureMember cmember = manager.lookupUserMeasure(this.getNameContext(), identifier);
        return cmember;
    }

    @Override
    public OlapNonScalarEntity lookupCalculatedMemberByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        OlapCube specifiedCube;
        if (identifier.getPartCount() > 1 && (specifiedCube = this.lookupSpecifiedCube(nameContext, identifier)) != null) {
            if (!this.perspective.isDefault() && !specifiedCube.equals(this.cube)) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.PERSPECTIVE_NON_DEFAULT_CUBE_MISMATCH, new Serializable[]{this.perspective.getName(), this.cube.getName(nameContext), specifiedCube.getName(nameContext)});
            }
            OlapNonScalarEntity entity = this.lookupCalculatedMember(nameContext, specifiedCube, identifier.subIdentifier(1));
            if (entity != null) {
                return entity;
            }
            return OlapNullEntity.INSTANCE;
        }
        OlapNonScalarEntity entity = this.lookupCalculatedMember(nameContext, this.cube, identifier);
        if (!this.perspective.isDefault() || entity != null) {
            return entity == null ? OlapNullEntity.INSTANCE : entity;
        }
        for (OlapRegularCube schemaCube : this.schema.getCubes()) {
            if (schemaCube.equals(this.cube) || (entity = this.lookupCalculatedMember(nameContext, schemaCube, identifier)) == null) continue;
            return entity;
        }
        return OlapNullEntity.INSTANCE;
    }

    @Nullable
    private OlapNonScalarEntity lookupCalculatedMember(OlapNameContext nameContext, OlapCube specifiedCube, OlapEntityIdentifier identifier) {
        OlapEngineSessionContext sessionContext = this.getSessionContext();
        OlapCubeCalculatedMemberManager calcMemberManager = specifiedCube.getCalcMemberManager();
        IOlapCalculatedMembers calcMembers = sessionContext.getCalcMemberManagerForLookup(this.getSchema(), calcMemberManager);
        OlapMember cmember = calcMembers.lookupCalculatedMember(this.getNameContext(), identifier);
        return cmember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OlapNonScalarEntity lookupCubeEntityByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        OlapCube specifiedCube;
        if (identifier.getPartCount() > 0 && (specifiedCube = this.lookupSpecifiedCube(nameContext, identifier)) != null) {
            if (!this.perspective.isDefault() && !specifiedCube.equals(this.cube)) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.PERSPECTIVE_NON_DEFAULT_CUBE_MISMATCH, new Serializable[]{this.perspective.getName(), this.cube.getName(nameContext), specifiedCube.getName(nameContext)});
            }
            OlapNonScalarEntity entity = this.lookupWithSpecifiedCube(nameContext, specifiedCube, identifier);
            if (entity != null) {
                return entity;
            }
            return super.lookupCubeEntityByMdxIdentifier(nameContext, identifier);
        }
        OlapNonScalarEntity entity = super.lookupCubeEntityByMdxIdentifier(nameContext, identifier);
        if (!this.perspective.isDefault() || !entity.isMdxNull()) {
            return entity;
        }
        for (OlapRegularCube schemaCube : this.schema.getCubes()) {
            if (schemaCube.equals(this.cube)) continue;
            OlapCube contextCube = this.cube;
            try {
                this.cube = schemaCube;
                entity = super.lookupCubeEntityByMdxIdentifier(nameContext, identifier);
                if (entity.isMdxNull()) continue;
                OlapNonScalarEntity olapNonScalarEntity = entity;
                return olapNonScalarEntity;
            }
            finally {
                this.cube = contextCube;
            }
        }
        return OlapNullEntity.INSTANCE;
    }

    @Nullable
    private OlapCube lookupSpecifiedCube(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        String specifiedCubeName = identifier.getPartAsName(0);
        return this.schema.lookupCubeByName(this.getSchemaPermissions(), nameContext, specifiedCubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OlapNonScalarEntity lookupWithSpecifiedCube(OlapNameContext nameContext, OlapCube specifiedCube, OlapEntityIdentifier identifier) {
        if (identifier.getPartCount() == 1) {
            return new OlapCubeEntity(specifiedCube);
        }
        if (identifier.getPartCount() == 2) {
            Set<String> groupNames = specifiedCube.getMeasureGroupNames(null);
            String asName = identifier.getPartAsName(1);
            for (String measureGroup : groupNames) {
                if (!measureGroup.equalsIgnoreCase(asName)) continue;
                return new OlapMeasureGroup(specifiedCube, measureGroup);
            }
        }
        OlapCube contextCube = this.cube;
        try {
            this.cube = specifiedCube;
            OlapNonScalarEntity measure = super.lookupCubeEntityByMdxIdentifier(nameContext, identifier.subIdentifier(1));
            if (measure instanceof OlapMeasureMember || measure instanceof OlapCalculatedMember) {
                OlapNonScalarEntity olapNonScalarEntity = measure;
                return olapNonScalarEntity;
            }
        }
        finally {
            this.cube = contextCube;
        }
        return null;
    }

    @Override
    public GFContext createGFContext() {
        return new GFPerspectiveExprEvalContext(this);
    }

    @Override
    protected OlapEvaluationContext doForkForParallelLambdaProcessing() {
        return new OlapPerspectiveExpressionEvaluationContext((OlapMdxStatementWithCubeSelectExecutionContext)this.statementExecutionContext, this.perspective);
    }
}

