/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutors;
import crazydev.iccube.olap.eval.facts.cells.IOlapFactsCellEvaluationTask;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellEvaluationTaskFactory;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.parallel.OlapExecutableTaskExecutor;
import crazydev.iccube.olap.eval.select.parallel.OlapExecutableTaskExecutorX;
import crazydev.iccube.olap.eval.select.parallel.OlapExecutableTaskProducer;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapMdxExtraExecutionLock {
    private final OlapMdxStatementExecutionContext context;

    public OlapMdxExtraExecutionLock(OlapMdxStatementExecutionContext context) {
        this.context = context;
    }

    public OlapExecutableTaskExecutor getParallelExecutor() {
        final OlapMdxExecutors executors = this.context.getMdxExecutors();
        final OlapMdxExecutionPermit permit = this.context.getMdxExecutionPermit();
        boolean cellsEvaluation = this.context.isCellsEvaluation();
        if (!cellsEvaluation) {
            return new OlapExecutableTaskExecutor(){
                final /* synthetic */ OlapMdxExtraExecutionLock this$0;
                {
                    OlapMdxExtraExecutionLock olapMdxExtraExecutionLock = this$0;
                    Objects.requireNonNull(olapMdxExtraExecutionLock);
                    this.this$0 = olapMdxExtraExecutionLock;
                }

                @Override
                public int threadCount() {
                    return executors.cellThreadCount();
                }

                @Override
                public void parallelExecution(int numberTasks, OlapExecutableTaskProducer producer) {
                    if (numberTasks == 0) {
                        return;
                    }
                    if (numberTasks == 1) {
                        producer.execute(0);
                    } else {
                        OlapFactsCellEvaluationTaskFactory tasks = OlapMdxExtraExecutionLock.createTasks(this.this$0.context, numberTasks, producer);
                        executors.executeForCellsProcessing(this.this$0.context, tasks, permit);
                    }
                }
            };
        }
        return new OlapExecutableTaskExecutor(){
            final /* synthetic */ OlapMdxExtraExecutionLock this$0;
            {
                OlapMdxExtraExecutionLock olapMdxExtraExecutionLock = this$0;
                Objects.requireNonNull(olapMdxExtraExecutionLock);
                this.this$0 = olapMdxExtraExecutionLock;
            }

            @Override
            public int threadCount() {
                return executors.extraThreadCount();
            }

            @Override
            public void parallelExecution(int numberTasks, OlapExecutableTaskProducer producer) {
                if (numberTasks == 0) {
                    return;
                }
                if (numberTasks == 1) {
                    producer.execute(0);
                } else {
                    OlapFactsCellEvaluationTaskFactory tasks = OlapMdxExtraExecutionLock.createTasks(this.this$0.context, numberTasks, producer);
                    executors.executeForExtraProcessing(this.this$0.context, tasks, permit);
                }
            }
        };
    }

    public OlapExecutableTaskExecutorX getParallelExecutorX() {
        final OlapMdxExecutors executors = this.context.getMdxExecutors();
        final OlapMdxExecutionPermit permit = this.context.getMdxExecutionPermit();
        boolean cellsEvaluation = this.context.isCellsEvaluation();
        if (!cellsEvaluation) {
            return new OlapExecutableTaskExecutorX(){
                final /* synthetic */ OlapMdxExtraExecutionLock this$0;
                {
                    OlapMdxExtraExecutionLock olapMdxExtraExecutionLock = this$0;
                    Objects.requireNonNull(olapMdxExtraExecutionLock);
                    this.this$0 = olapMdxExtraExecutionLock;
                }

                @Override
                public int threadCount() {
                    return executors.cellThreadCount();
                }

                @Override
                public void parallelExecution(OlapFactsCellEvaluationTaskFactory tasks) {
                    executors.executeForCellsProcessing(this.this$0.context, tasks, permit);
                }
            };
        }
        return new OlapExecutableTaskExecutorX(){
            final /* synthetic */ OlapMdxExtraExecutionLock this$0;
            {
                OlapMdxExtraExecutionLock olapMdxExtraExecutionLock = this$0;
                Objects.requireNonNull(olapMdxExtraExecutionLock);
                this.this$0 = olapMdxExtraExecutionLock;
            }

            @Override
            public int threadCount() {
                return executors.extraThreadCount();
            }

            @Override
            public void parallelExecution(OlapFactsCellEvaluationTaskFactory tasks) {
                executors.executeForExtraProcessing(this.this$0.context, tasks, permit);
            }
        };
    }

    private static OlapFactsCellEvaluationTaskFactory createTasks(OlapMdxStatementExecutionContext context, final int numberTasks, final OlapExecutableTaskProducer producer) {
        return new OlapFactsCellEvaluationTaskFactory(context){
            int currentTask;
            boolean stop;
            {
                super(context);
                this.currentTask = 0;
                this.stop = false;
            }

            @Override
            @Nullable
            protected IOlapFactsCellEvaluationTask nextTask() {
                int taskId = this.currentTask++;
                if (!this.stop && taskId < numberTasks) {
                    return () -> this.stop |= !producer.execute(taskId);
                }
                return null;
            }
        };
    }
}

