/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCurrent;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapCubeEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.CdCaseInsensitiveHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_COMPATIBLE)
public class OlapFlatAuthorizationExpressionEvaluationContext
extends OlapExpressionEvaluationContext {
    private final OlapSchema schema;
    private final OlapCube cube;
    private final Map<String, OlapTupleSet> sets;
    private final Map<String, OlapDeclaredFunction> functions = new CdCaseInsensitiveHashMap();
    @Nullable
    private final MdxAuthorizationCurrent current;

    public OlapFlatAuthorizationExpressionEvaluationContext(OlapMdxStatementWithCubeSelectExecutionContext scontext, Map<String, OlapTupleSet> sets, Map<String, OlapDeclaredFunction> functions, @Nullable MdxAuthorizationCurrent current) {
        super(scontext);
        this.schema = scontext.getSchema();
        this.cube = scontext.getCube().getUnderlying();
        this.sets = sets;
        this.functions.putAll(functions);
        this.current = current;
    }

    @Override
    public String getUsage() {
        return "flat-authorization-expression";
    }

    @Override
    public boolean isForAuthExpression() {
        return true;
    }

    @Override
    public OlapCube getCube() {
        return this.cube;
    }

    @Override
    @Nullable
    public OlapEntity lookupCurrent(String key) {
        if (this.current != null) {
            return this.current.lookupCurrent(key);
        }
        return null;
    }

    @Override
    @Nullable
    public OlapTupleSet lookupAsNamedSet(String identifier) {
        return this.sets.get(identifier);
    }

    @Override
    @Nullable
    public OlapDeclaredFunction lookupDeclaredFunction(String name) {
        OlapDeclaredFunction function = this.functions.get(name);
        if (function != null) {
            return function;
        }
        return super.lookupDeclaredFunction(name);
    }

    @Override
    protected OlapNonScalarEntity lookupCubeEntityByMdxIdentifier(OlapNameContext nameContext, OlapEntityIdentifier identifier) {
        if (identifier.getPartCount() > 1) {
            String cubeName = identifier.getPartAsName(0);
            OlapCube schemaCube = this.schema.lookupCubeByName(this.getSchemaPermissions(), nameContext, cubeName);
            if (schemaCube instanceof OlapRegularCube) {
                String measureGroupName;
                OlapRegularCube referencedCube = (OlapRegularCube)schemaCube;
                if (identifier.getPartCount() == 1) {
                    return new OlapCubeEntity(referencedCube);
                }
                if (identifier.getPartCount() == 2 && referencedCube.hasMeasureGroup(measureGroupName = identifier.getPartAsName(1))) {
                    return new OlapMeasureGroup(schemaCube, measureGroupName);
                }
            }
        }
        return super.lookupCubeEntityByMdxIdentifier(nameContext, identifier);
    }

    @Override
    protected OlapEvaluationContext doForkForParallelLambdaProcessing() {
        return new OlapFlatAuthorizationExpressionEvaluationContext((OlapMdxStatementWithCubeSelectExecutionContext)this.statementExecutionContext, this.sets, this.functions, this.current);
    }
}

