/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select.context;

import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellsTupleEvaluator;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OlapCellsEvaluationContext {
    private final boolean isNonEmptyActive;
    private final GFCellsTupleEvaluator tupleEvaluator;
    private final OlapSelectStatementExecutionContext sContext;
    private final List<OlapCellProperty> requestedCellProperties;
    private final Set<OlapCellProperty> requestedCellProperties_;
    private final OlapCube cube;
    private final Object initLOCK = new Object();
    private volatile boolean initialized;

    public OlapCellsEvaluationContext(OlapSelectStatementExecutionContext sContext, boolean isNonEmptyActive, List<OlapCellProperty> requestedCellProperties) {
        this.sContext = sContext;
        this.tupleEvaluator = new GFCellsTupleEvaluator(this);
        this.isNonEmptyActive = isNonEmptyActive;
        this.requestedCellProperties = requestedCellProperties;
        this.requestedCellProperties_ = new HashSet<OlapCellProperty>(requestedCellProperties);
        this.cube = sContext.getCube();
        this.initialized = false;
    }

    public OlapSelectStatementExecutionContext getStatementContext() {
        return this.sContext;
    }

    public GFCellsTupleEvaluator getTupleEvaluator() {
        return this.tupleEvaluator;
    }

    public boolean isNonEmptyActive() {
        return this.isNonEmptyActive;
    }

    public List<OlapCellProperty> getRequestedCellProperties() {
        return this.requestedCellProperties;
    }

    public boolean isCellPropertyRequested(OlapCellProperty property) {
        return this.requestedCellProperties_.contains(property);
    }

    public OlapCube getCube() {
        return this.cube;
    }

    public void onCellValuesProcessed() {
        this.tupleEvaluator.onCellValuesProcessed(this.sContext);
    }

    public void onNewCell(OlapTuple[] cell, int[] si) {
        if (!this.initialized) {
            this.init(cell, si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(OlapTuple[] cell, int[] si) {
        Object object = this.initLOCK;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            this.tupleEvaluator.init(cell);
            this.initialized = true;
        }
    }
}

