/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.common.xmla.CdXmlaCellOrdinalHelper;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapCellPropertyValue;
import crazydev.iccube.olap.entity.result.OlapResAxis;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.result.OlapResCellData;
import crazydev.iccube.olap.entity.result.OlapResRegularCell;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFCellPropertyEvalContext;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFCellPropertiesHelper;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFCellsTupleEvaluator;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellScalarValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.select.context.OlapCellEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCellsEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapTopLevelSelectInstrHelper {
    public static OlapMember getCalculatingMember(OlapResSelectStatementDataSet original) {
        if (original.getAxisCount() != 1) {
            throw new RuntimeException("internal error : inconsistent result set");
        }
        OlapResAxis axis0 = original.getAxes()[0];
        OlapTuple aTuple = axis0.getAnyTuple();
        if (aTuple == null) {
            throw new RuntimeException("internal error : inconsistent result set");
        }
        return aTuple.getMember(0);
    }

    public static OlapResCellData computePostProcessedCellData(OlapSelectStatementExecutionContext sContext, List<OlapCellProperty> cellProperties, final OlapMember calculatingMember, List<OlapTuple> axisAsList_0, List<OlapTuple> axisAsList_1, Value value_) {
        OlapCellsEvaluationContext cellsEvaluationContext = new OlapCellsEvaluationContext(sContext, false, Collections.emptyList());
        GFCellsTupleEvaluator cellsTupleEvaluator = new GFCellsTupleEvaluator(cellsEvaluationContext);
        CdXmlaCellOrdinalHelper ordinals = new CdXmlaCellOrdinalHelper(new int[]{axisAsList_0.size(), axisAsList_1.size()});
        OlapResCell[] ppCells = new OlapResCell[ordinals.getCellCount()];
        for (int axis_0_idx = 0; axis_0_idx < axisAsList_0.size(); ++axis_0_idx) {
            for (int axis_1_idx = 0; axis_1_idx < axisAsList_1.size(); ++axis_1_idx) {
                double value = value_.value(axis_0_idx, axis_1_idx);
                OlapNumericEntity svalue = new OlapNumericEntity(value);
                OlapEvalResultSi cellSi = new OlapEvalResultSi(new int[]{axis_0_idx, axis_1_idx});
                OlapEvalResultCellScalarValue cellResValue = new OlapEvalResultCellScalarValue(cellSi, svalue);
                OlapCellsEvaluationContext eContext_ = new OlapCellsEvaluationContext(sContext, false, cellProperties);
                OlapCellEvaluationContext eContext = new OlapCellEvaluationContext(eContext_);
                OlapTuple tuple_0 = axisAsList_0.get(axis_0_idx);
                OlapTuple tuple_1 = axisAsList_1.get(axis_1_idx);
                OlapTuple tuple = OlapTupleFactory.instance((IOlapEvaluationExceptionContext)sContext, sContext.getTupleDimensionalityCache(), null, tuple_0, tuple_1);
                GFCellEvalContext cContext = new GFCellEvalContext(cellsTupleEvaluator, eContext, tuple);
                GFCellPropertyEvalContext pContext = new GFCellPropertyEvalContext(cContext, cellProperties, cellResValue){

                    @Override
                    @Nullable
                    public OlapCellPropertyValue getCellPropertyValue(OlapCellProperty property) {
                        return calculatingMember.getCellPropertyValue(property);
                    }
                };
                OlapScalarEntity[] properties = GFCellPropertiesHelper.evalRequestedCellProperties(pContext);
                int ordinal = ordinals.computeCellOrdinal(cellSi.getSi());
                ppCells[ordinal] = new OlapResRegularCell(ordinal, cellProperties, properties);
            }
        }
        return new OlapResCellData(cellProperties, ordinals, ppCells);
    }

    public static interface Value {
        public double value(int var1, int var2);
    }
}

