/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.common.collection.CdArrayList;
import crazydev.common.exception.ICdException;
import crazydev.common.xmla.CdXmlaCellOrdinalHelper;
import crazydev.iccube.cluster.shared.context.S_MdxStatementRequestContextRef;
import crazydev.iccube.collection.OlapIterable;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapCombinationIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectQueryInfo;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapSubSelectCube;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapNameIdentifiableEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierNamePart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperty;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.OlapResAxis;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.result.OlapResCellData;
import crazydev.iccube.olap.entity.result.OlapResEmptyCell;
import crazydev.iccube.olap.entity.result.OlapResErrorCell;
import crazydev.iccube.olap.entity.result.OlapResErrorMdxStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResIntrinsicScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.OlapResRegularCell;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetT;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetTpp;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResSubSelect;
import crazydev.iccube.olap.entity.result.OlapResUserDefinedScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyUtils;
import crazydev.iccube.olap.entity.result.tidy.OlapResTidyTable;
import crazydev.iccube.olap.entity.result.tidy.debug.OlapResMdxTidyMaterializedTableCellError;
import crazydev.iccube.olap.entity.scalar.OlapDoubleMatrixAEntity;
import crazydev.iccube.olap.entity.scalar.OlapDoubleVectorAEntity;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.eval.catmember.OlapRequestCategoryMemberManager;
import crazydev.iccube.olap.eval.evaluator.OlapMdxExecutionPermit;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapMdxEvaluationCancelled;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellDataEvaluator;
import crazydev.iccube.olap.eval.facts.cells.OlapFactsCellDataEvaluatorForNoAxis;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.result.OlapEvalResult;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellScalarValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapBaseSubSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateCalcMemberSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateCategoryHierarchySelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateCategoryMemberSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateFunctionSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateMeasureSelectInstr;
import crazydev.iccube.olap.eval.select.OlapCreateSetSelectInstr;
import crazydev.iccube.olap.eval.select.OlapSelectAxisExprResult;
import crazydev.iccube.olap.eval.select.OlapSelectInstr;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import crazydev.iccube.olap.eval.select.OlapTopLevelSelectInstrHelper;
import crazydev.iccube.olap.eval.select.context.OlapAxisEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCalcMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryHierarchyEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryMemberEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapCreateMeasureEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxEntityLookupKinds;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapTopLevelAxisEvaluationContext;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapPostProcessedMdxResult;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessorInstr;
import crazydev.iccube.olap.eval.subselect.OlapSubSelectFilterFactory;
import crazydev.iccube.olap.eval.subselect.dimension.OlapSubSelectTupleFilter;
import crazydev.iccube.olap.facts.column.aggregator.OlapFactColumnSumDoubleAggregator;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.OlapServerCancelledRequestException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapTopLevelSelectInstr
extends OlapSelectInstr {
    private final MdxSelectQueryInfo queryInfo;
    private final OlapInstr cubeInstr;
    private final String cubeName;
    private final OlapCreateFunctionSelectInstr[] declaredFunctions;
    private final OlapCreateSetSelectInstr[] namedSetInstrs;
    private final OlapCreateCategoryHierarchySelectInstr[] categoryHierarchyInstrs;
    private final OlapCreateCategoryMemberSelectInstr[] categoryMemberInstrs;
    private final OlapCategoryMember[] dynamicCategoryMembers;
    private final OlapCreateCalcMemberSelectInstr[] calcMemberInstrs;
    private final OlapCreateMeasureSelectInstr[] measureInstrs;
    private final List<OlapCellProperty> cellProperties;
    private final boolean isEvalOrdinalOnly;
    @Nullable
    private final List<OlapTidyPostProcessorInstr> tidyPostProcessors;
    @Nullable
    private String[] initialSelection;

    public OlapTopLevelSelectInstr(MdxSelectQueryInfo queryInfo, OlapInstrLocationRange range, OlapInstr cubeInstr, MdxAnnotation[] annotations, OlapCreateFunctionSelectInstr[] declaredFunctions, OlapCreateSetSelectInstr[] namedSetInstrs, OlapCreateCategoryHierarchySelectInstr[] categoryHierarchyInstrs, OlapCreateCategoryMemberSelectInstr[] categoryMemberInstrs, OlapCreateCalcMemberSelectInstr[] calcMemberInstrs, OlapCreateMeasureSelectInstr[] measureInstrs, OlapAxisInstr[] axisInstrs, @Nullable OlapSlicerInstr slicerInstr, List<OlapCellProperty> cellProperties, @Nullable List<OlapTidyPostProcessorInstr> tidyPostProcessors) {
        super(annotations, range, axisInstrs, slicerInstr);
        this.queryInfo = queryInfo;
        this.cubeInstr = cubeInstr;
        this.cubeName = OlapTopLevelSelectInstr.setupCubeName(cubeInstr);
        this.declaredFunctions = declaredFunctions;
        this.namedSetInstrs = namedSetInstrs;
        this.categoryHierarchyInstrs = categoryHierarchyInstrs;
        this.categoryMemberInstrs = categoryMemberInstrs;
        this.dynamicCategoryMembers = new OlapCategoryMember[categoryMemberInstrs.length];
        this.calcMemberInstrs = calcMemberInstrs;
        this.measureInstrs = measureInstrs;
        this.cellProperties = cellProperties;
        this.isEvalOrdinalOnly = OlapTopLevelSelectInstr.isEvalOrdinalOnly(cellProperties);
        this.tidyPostProcessors = tidyPostProcessors;
        this.cubeInstr.setParent(this);
        for (OlapCreateFunctionSelectInstr olapCreateFunctionSelectInstr : this.declaredFunctions) {
            olapCreateFunctionSelectInstr.setParent(this);
        }
        for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.namedSetInstrs) {
            olapExecutedWithoutPreparedInstr.setParent(this);
        }
        for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : categoryHierarchyInstrs) {
            olapExecutedWithoutPreparedInstr.setParent(this);
        }
        for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : categoryMemberInstrs) {
            olapExecutedWithoutPreparedInstr.setParent(this);
        }
        for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.calcMemberInstrs) {
            olapExecutedWithoutPreparedInstr.setParent(this);
        }
        for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.measureInstrs) {
            olapExecutedWithoutPreparedInstr.setParent(this);
        }
    }

    private static boolean isEvalOrdinalOnly(List<OlapCellProperty> cellProperties) {
        if (cellProperties != null && cellProperties.size() == 1) {
            OlapCellProperty prop = cellProperties.get(0);
            return prop.isCellOrdinal();
        }
        return false;
    }

    private static String setupCubeName(OlapInstr cube) {
        if (cube instanceof OlapBaseSubSelectInstr) {
            OlapBaseSubSelectInstr subSelect = (OlapBaseSubSelectInstr)cube;
            return subSelect.getCubeName();
        }
        OlapIdentifierInstr instr = (OlapIdentifierInstr)cube;
        return instr.getId().getLastPartAsName();
    }

    private static String extractPropertyName(OlapEntityIdentifier propertyId) {
        return ((OlapEntityIdentifierNamePart)propertyId.getLastPart()).getName();
    }

    @Nullable
    private static OlapEntityIdentifier extractPropertyScope(OlapEntityIdentifier propertyId) {
        return propertyId.prefix();
    }

    private static Map<OlapMember, OlapMemberPropertyValues> evaluateRequestedMemberProperties(OlapMemberPropertyEvalContext context, List<OlapResScopedDimensionProperty> requestedProperties, List<OlapTuple> tuples) {
        HashMap<OlapMember, OlapMemberPropertyValues> values = new HashMap<OlapMember, OlapMemberPropertyValues>();
        for (OlapTuple tuple : tuples) {
            for (int idx = 0; idx < tuple.getMemberCount(); ++idx) {
                OlapMember member = tuple.getMember(idx);
                if (values.containsKey(member)) continue;
                OlapMemberPropertyValues memberPropertyValues = OlapMemberPropertyValues.evaluate(context, requestedProperties, member);
                values.put(member, memberPropertyValues);
            }
        }
        return values;
    }

    private static OlapIterable<Integer> integers(final int len) {
        return new OlapIterable<Integer>(){

            @Override
            public OlapIterator<Integer> getIterator(boolean forceCache) {
                return OlapIteratorFactory.integers(len);
            }

            @Override
            @Nullable
            public OlapTupleDimensionality getTupleDimensionality() {
                return null;
            }

            @Override
            public long fastEstimatedSize() {
                return len;
            }

            @Override
            public boolean mightHaveCalcMember() {
                return false;
            }
        };
    }

    private static void getHierarchies(Set<OlapHierarchy> hierarchies, OlapTuple anyTuple) {
        if (anyTuple != null) {
            for (int midx = 0; midx < anyTuple.getMemberCount(); ++midx) {
                OlapMember member = anyTuple.getMember(midx);
                hierarchies.add(member.getHierarchy());
            }
        }
    }

    @Override
    public boolean isResultCacheEnabled() {
        return true;
    }

    @Override
    public String typeForError() {
        return "SELECT";
    }

    public MdxSelectQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public List<OlapCellProperty> getCellProperties() {
        return this.cellProperties;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    public OlapCreateSetSelectInstr[] getNamedSetInstrs() {
        return this.namedSetInstrs;
    }

    public OlapCreateCalcMemberSelectInstr[] getCalcMemberInstrs() {
        return this.calcMemberInstrs;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.cubeInstr.accept(v);
            for (OlapCreateFunctionSelectInstr olapCreateFunctionSelectInstr : this.declaredFunctions) {
                olapCreateFunctionSelectInstr.accept(v);
            }
            for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.namedSetInstrs) {
                ((OlapCreateSetSelectInstr)olapExecutedWithoutPreparedInstr).accept(v);
            }
            for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.categoryHierarchyInstrs) {
                ((OlapCreateCategoryHierarchySelectInstr)olapExecutedWithoutPreparedInstr).accept(v);
            }
            for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.categoryMemberInstrs) {
                ((OlapCreateCategoryMemberSelectInstr)olapExecutedWithoutPreparedInstr).accept(v);
            }
            for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.calcMemberInstrs) {
                ((OlapCreateCalcMemberSelectInstr)olapExecutedWithoutPreparedInstr).accept(v);
            }
            for (OlapExecutedWithoutPreparedInstr olapExecutedWithoutPreparedInstr : this.measureInstrs) {
                ((OlapCreateMeasureSelectInstr)olapExecutedWithoutPreparedInstr).accept(v);
            }
            for (OlapInstr olapInstr : this.axisInstrs) {
                ((OlapAxisInstr)olapInstr).accept(v);
            }
            if (this.slicerInstr != null) {
                this.slicerInstr.accept(v);
            }
        }
    }

    public void setInitialSelection(@Nullable String[] initialSelection) {
        this.initialSelection = initialSelection;
    }

    @Override
    protected OlapSelectStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        OlapCube cube = this.getExistingCube(requestContext, schema);
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        return new OlapSelectStatementExecutionContext(requestContext, props, this.getAnnotations(), instrExecutionListener, false, this.isOnAxes(), schema, cube);
    }

    public OlapCube getExistingCube(OlapEngineRequestContext requestContext, OlapSchema schema) {
        return requestContext.getExistingCubeByName(requestContext.getNameContext(), this.cubeInstr.getLocationRange(), schema, this.cubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OlapResStatementDataSet doExecute(OlapSelectStatementExecutionContext context) {
        OlapMdxExecutionPermit permit = context.acquireMdxExecutionPermit();
        if (permit.isCancelled()) {
            return OlapResMdxTidyUtils.emptyStatementResult(context);
        }
        try {
            OlapResStatementDataSet olapResStatementDataSet;
            try {
                OlapResStatementDataSet res;
                olapResStatementDataSet = res = this.doExecuteWithPermit(context, permit);
            }
            catch (Throwable throwable) {
                context.performHousekeeping();
                throw throwable;
            }
            context.performHousekeeping();
            return olapResStatementDataSet;
        }
        finally {
            context.releaseMdxExecutionPermit(permit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapResStatementDataSet doExecuteWithPermit(OlapSelectStatementExecutionContext context, OlapMdxExecutionPermit permit) {
        try {
            OlapMdxStatementEvalStatistics stats;
            OlapInstrExecListener instrExecListener = context.getInstrExecListener();
            if (instrExecListener != null) {
                instrExecListener.beginQuery();
            }
            if (OlapLoggers.MDX_EVALUATION.isDebugEnabled()) {
                OlapProperties requestProperties = context.getRequestProperties();
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] mdxSumAlgo                  : " + String.valueOf((Object)OlapFactColumnSumDoubleAggregator.SUM_ALGO)));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] mdxEvalFastNonEmptyAxis     : " + requestProperties.isMdxEvalFastNonEmptyAxis()));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] mdxEvalMeasureVector        : " + requestProperties.isMdxEvalMeasureVector()));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] mdxEvalLambdaProcessingMode : " + String.valueOf(requestProperties.getMdxEvalLambdaProcessingMode())));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] mdxEvalFilterProcessingMode : " + String.valueOf((Object)requestProperties.getMdxEvalFilterProcessingMode())));
            }
            OlapResStatementDataSet res = this.doExecuteX(context, permit);
            res = this.postProcess(context, res);
            if (instrExecListener != null) {
                stats = context.getEvalStatistics();
                instrExecListener.endQuery(stats);
            }
            if (OlapLoggers.MDX_EVALUATION_STATS.isDebugEnabled()) {
                stats = context.getEvalStatistics();
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] tuple-aggregate         : " + stats.tupleAggregateCount()));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] tuple-aggregate-set     : " + stats.tupleAggregateSetCount()));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] set-evaluator           : " + stats.setEvaluatorCount()));
                for (OlapMdxStatementEvalStatistics.CellCache cellCache : stats.cellCaches()) {
                    OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] cell cache size         : " + cellCache.size));
                    OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] cell cache get          : " + cellCache.get));
                    OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] cell cache miss         : " + cellCache.miss));
                }
                long sizeT = 0L;
                long getT = 0L;
                long missT = 0L;
                for (OlapMdxStatementEvalStatistics.CalcMemberCache cache : stats.calcMemberCaches().values()) {
                    sizeT += cache.size;
                    getT += cache.get;
                    missT += cache.miss;
                    OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] calc. member cache      : " + cache.name + " [size:" + cache.size + "] [get:" + cache.get + "] [miss:" + cache.miss + "]"));
                }
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] calc. member cache size : " + sizeT));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] calc. member cache get  : " + getT));
                OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] calc. member cache miss : " + missT));
            }
            OlapResStatementDataSet olapResStatementDataSet = res;
            return olapResStatementDataSet;
        }
        finally {
            OlapRequestCategoryMemberManager categoryManager = context.getRequestCategoryMemberManager();
            categoryManager.deleteAll();
        }
    }

    private OlapResStatementDataSet postProcess(OlapSelectStatementExecutionContext scontext, OlapResStatementDataSet res) {
        if (res instanceof OlapResSelectStatementDataSet) {
            OlapResSelectStatementDataSet dataSet = (OlapResSelectStatementDataSet)res;
            if (this.isOnAxes()) {
                if (dataSet.getCells().getCellCount() == 1) {
                    OlapResCell cell = dataSet.getCells().getCell(0);
                    if (cell.isOnError()) {
                        return res;
                    }
                    OlapScalarEntity value = cell.getRequestPropertyValue(OlapIntrinsicCellProperties.VALUE);
                    if (value instanceof OlapDoubleMatrixAEntity) {
                        return this.postProcessMatrixA(scontext.copyForPostProcessing(), dataSet, (OlapDoubleMatrixAEntity)value);
                    }
                    if (value instanceof OlapDoubleVectorAEntity) {
                        return this.postProcessVectorA(scontext.copyForPostProcessing(), dataSet, (OlapDoubleVectorAEntity)value);
                    }
                }
                throw new OlapEvaluationException(scontext, OlapErrorCode.SELECT_EVAL_AXES_ERROR, new Serializable[0]);
            }
        }
        return res;
    }

    private OlapResSelectStatementDataSet postProcessMatrixA(OlapSelectStatementExecutionContext scontext, OlapResSelectStatementDataSet original, final OlapDoubleMatrixAEntity matrix) {
        OlapMember calculatingMember = OlapTopLevelSelectInstrHelper.getCalculatingMember(original);
        List<OlapTuple> axisAsList_0 = matrix.getAxisList(0);
        List<OlapResScopedDimensionProperty> axisRequestedProperties_0 = Collections.emptyList();
        Map<OlapMember, OlapMemberPropertyValues> axisProperties_0 = OlapTopLevelSelectInstr.evaluateRequestedMemberProperties(scontext.getMemberPropertyEvalContext(), axisRequestedProperties_0, axisAsList_0);
        OlapResAxis axis_0 = new OlapResAxis(new OlapResAxisName(0L), false, axisAsList_0, axisRequestedProperties_0, axisProperties_0);
        List<OlapTuple> axisAsList_1 = matrix.getAxisList(1);
        List<OlapResScopedDimensionProperty> axisRequestedProperties_1 = Collections.emptyList();
        Map<OlapMember, OlapMemberPropertyValues> axisProperties_1 = OlapTopLevelSelectInstr.evaluateRequestedMemberProperties(scontext.getMemberPropertyEvalContext(), axisRequestedProperties_1, axisAsList_1);
        OlapResAxis axis_1 = new OlapResAxis(new OlapResAxisName(1L), false, axisAsList_1, axisRequestedProperties_1, axisProperties_1);
        OlapResAxis[] ppAxes = new OlapResAxis[]{axis_0, axis_1};
        OlapResCellData ppCellData = OlapTopLevelSelectInstrHelper.computePostProcessedCellData(scontext, this.cellProperties, calculatingMember, axisAsList_0, axisAsList_1, new OlapTopLevelSelectInstrHelper.Value(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public double value(int axis0, int axis1) {
                return matrix.value(axis0, axis1);
            }
        });
        return this.setupPostProcessedResult(scontext, ppAxes, ppCellData);
    }

    private OlapResSelectStatementDataSet postProcessVectorA(OlapSelectStatementExecutionContext scontext, OlapResSelectStatementDataSet original, final OlapDoubleVectorAEntity vector) {
        OlapMember calculatingMember = OlapTopLevelSelectInstrHelper.getCalculatingMember(original);
        ArrayList<OlapTuple> axisAsList_0 = new ArrayList<OlapTuple>(Collections.singletonList(calculatingMember));
        List<OlapResScopedDimensionProperty> axisRequestedProperties_0 = Collections.emptyList();
        Map<OlapMember, OlapMemberPropertyValues> axisProperties_0 = OlapTopLevelSelectInstr.evaluateRequestedMemberProperties(scontext.getMemberPropertyEvalContext(), axisRequestedProperties_0, axisAsList_0);
        OlapResAxis axis_0 = new OlapResAxis(new OlapResAxisName(0L), false, axisAsList_0, axisRequestedProperties_0, axisProperties_0);
        List<OlapTuple> axisAsList_1 = vector.getAxisList(0);
        List<OlapResScopedDimensionProperty> axisRequestedProperties_1 = Collections.emptyList();
        Map<OlapMember, OlapMemberPropertyValues> axisProperties_1 = OlapTopLevelSelectInstr.evaluateRequestedMemberProperties(scontext.getMemberPropertyEvalContext(), axisRequestedProperties_1, axisAsList_1);
        OlapResAxis axis_1 = new OlapResAxis(new OlapResAxisName(1L), false, axisAsList_1, axisRequestedProperties_1, axisProperties_1);
        OlapResAxis[] ppAxes = new OlapResAxis[]{axis_0, axis_1};
        OlapResCellData ppCellData = OlapTopLevelSelectInstrHelper.computePostProcessedCellData(scontext, this.cellProperties, calculatingMember, axisAsList_0, axisAsList_1, new OlapTopLevelSelectInstrHelper.Value(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public double value(int axis0, int axis1) {
                return vector.value(axis1);
            }
        });
        return this.setupPostProcessedResult(scontext, ppAxes, ppCellData);
    }

    private OlapResSelectStatementDataSet setupPostProcessedResult(OlapSelectStatementExecutionContext scontext, OlapResAxis[] ppAxes, OlapResCellData ppCellData) {
        String ppMdx = this.getLocationRange().mdx();
        MdxSelectQueryInfo ppQueryInfo = new MdxSelectQueryInfo(ppAxes.length);
        String ppCubeName = this.cubeName;
        Date ppCubeLastUpdate = scontext.getCube().getLastDataUpdatedTime();
        OlapResSlicer ppSlicer = scontext.getSlicer();
        List<OlapMember> ppDefaultMembers = this.setupXmlaDefaultMembers(scontext, ppAxes);
        List<OlapMember> ppInitialMembers = null;
        OlapResSelectStatementDataSet ppRes = new OlapResSelectStatementDataSet(scontext, ppMdx, ppQueryInfo, ppCubeName, ppCubeLastUpdate, ppAxes, ppSlicer, ppDefaultMembers, ppInitialMembers, ppCellData);
        ppRes.disableDrilldown();
        return ppRes;
    }

    protected OlapResStatementDataSet doExecuteX(OlapSelectStatementExecutionContext context, OlapMdxExecutionPermit permit) {
        long startMS = System.currentTimeMillis();
        OlapResStatementDataSet res = this.doExecuteX_(context, permit);
        if (res instanceof OlapResSelectStatementDataSet) {
            OlapResSelectStatementDataSet res_ = (OlapResSelectStatementDataSet)res;
            OlapMdxStatementExecutionContext context_ = res_.getContext();
            context_.setTotalElapsedMS(System.currentTimeMillis() - startMS);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OlapResStatementDataSet doExecuteX_(OlapSelectStatementExecutionContext context, OlapMdxExecutionPermit permit) {
        OlapResStatementDataSet olapResStatementDataSet;
        S_MdxStatementRequestContextRef clusterContextRef = null;
        try {
            OlapSubSelectCube subSelectCube;
            context.pushCurrentInstruction(this);
            clusterContextRef = context.createClusterContext();
            context.createClusterStaticContext();
            OlapInstrExecListener instrExecListener = context.getInstrExecListener();
            if (instrExecListener != null && !this.isWithEmpty()) {
                instrExecListener.beginWith();
            }
            try {
                if (context.isForTidyEvaluation() && this.isOnAxes()) {
                    throw new OlapEvaluationException(context, OlapErrorCode.TIDY_ON_AXES_NOT_SUPPORTED, new Serializable[0]);
                }
                this.setupDeclaredFunctions(context);
                this.setupMeasures(context);
                this.setupCategoryHierarchies(context);
                this.setupStaticCategoryMembers(context);
                this.setupCalculatedMembers(context);
                OlapResSlicer slicer = this.evaluateSlicer(context, false);
                context.setHasEvaluatedSlicer();
                context.setSlicer(slicer);
                this.setupSetDeclarations(context);
                if (instrExecListener != null && !this.isWithEmpty()) {
                    instrExecListener.endWith();
                }
            }
            catch (RuntimeException ex) {
                if (instrExecListener != null && !this.isWithEmpty()) {
                    instrExecListener.endWithOnError(ex);
                }
                throw ex;
            }
            OlapResStatementDataSet result = null;
            if (this.cubeInstr instanceof OlapBaseSubSelectInstr && (subSelectCube = this.executeSubSelect(context)) != null) {
                context.resetCubeForSubSelect(subSelectCube);
                result = this.evaluateAxesAndCells(context, permit);
            }
            olapResStatementDataSet = result = result != null ? result : this.evaluateAxesAndCells(context, permit);
        }
        catch (OlapEvaluationException ex) {
            OlapResErrorMdxStatementDataSet olapResErrorMdxStatementDataSet;
            try {
                olapResErrorMdxStatementDataSet = new OlapResErrorMdxStatementDataSet(context.getSchema().getName(), this.getLocationRange().mdx(), (ICdException)ex);
            }
            catch (Throwable throwable) {
                context.deleteClusterContext(clusterContextRef);
                throw throwable;
            }
            context.deleteClusterContext(clusterContextRef);
            return olapResErrorMdxStatementDataSet;
        }
        context.deleteClusterContext(clusterContextRef);
        return olapResStatementDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private OlapSubSelectCube executeSubSelect(OlapSelectStatementExecutionContext context) {
        OlapSelectStatementExecutionContext xContext = context.copyForSubSelectEvaluation();
        xContext.adoptMdxExtraExecutionLOCK(context);
        xContext.setHasEvaluatedSlicer();
        xContext.setSlicer(context.getSlicer());
        S_MdxStatementRequestContextRef xClusterContextRef = xContext.createClusterContext();
        xContext.createClusterStaticContext();
        xContext.setHasEvaluatedSlicerAndSubSelect();
        xContext.createClusterDynamicContext();
        try {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] sub-select processing started");
            OlapBaseSubSelectInstr instr = (OlapBaseSubSelectInstr)this.cubeInstr;
            OlapResSubSelect selection = (OlapResSubSelect)instr.execute(xContext);
            List<OlapSubCubeEntity> subCubes = selection.getSubCubes();
            if (selection.isVoidAxis() && subCubes == null) {
                OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] sub-select ignored (no selection)");
                OlapSubSelectCube olapSubSelectCube = null;
                return olapSubSelectCube;
            }
            OlapCube underlyingCube = this.getExistingCube(context.getRequestContext(), context.getSchema());
            OlapTupleDimensionalityCache cache = context.getTupleDimensionalityCache();
            OlapSubSelectTupleFilter subSelectDimensionFilter = OlapSubSelectFilterFactory.createDimensionFilter(cache, selection);
            OlapSubSelectCube subSelectCube = new OlapSubSelectCube(instr, subSelectDimensionFilter, subCubes, underlyingCube);
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] sub-select processing completed");
            OlapSubSelectCube olapSubSelectCube = subSelectCube;
            return olapSubSelectCube;
        }
        finally {
            xContext.deleteClusterContext(xClusterContextRef);
        }
    }

    private OlapResStatementDataSet evaluateAxesAndCells(OlapSelectStatementExecutionContext scontext, OlapMdxExecutionPermit permit) throws OlapEvaluationException {
        try {
            List<OlapTupleSet<OlapTuple>> axesAsSets = this.unsafeEvaluateAxes(scontext);
            OlapResStatementDataSet res = !scontext.isForTidyEvaluation() ? this.unsafeEvaluateCells(scontext, permit, axesAsSets) : this.unsafeEvaluateCellsT(scontext, permit, axesAsSets);
            return res;
        }
        catch (OlapMdxEvaluationCancelled ex) {
            throw new OlapEvaluationException(ex, scontext, OlapErrorCode.EVAL_CANCELLED, new Serializable[0]);
        }
        catch (RuntimeException ex) {
            if (ex instanceof OlapEvaluationException) {
                throw ex;
            }
            if (ex instanceof OlapServerCancelledRequestException) {
                throw new OlapEvaluationException(ex, scontext, OlapErrorCode.EVAL_CANCELLED, new Serializable[0]);
            }
            OlapLoggers.MDX_EVALUATION.error((Object)"MDX evaluation unexpected (unchecked) error", (Throwable)ex);
            throw new OlapEvaluationException(ex, scontext, OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"( class :" + ex.getClass().getSimpleName() + " - message : " + ex.getMessage() + " )"});
        }
    }

    private List<OlapTupleSet<OlapTuple>> unsafeEvaluateAxes(OlapSelectStatementExecutionContext scontext) {
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis/cells started");
        if (!scontext.hasEvaluatedSlicerAndSubSelect()) {
            scontext.setHasEvaluatedSlicerAndSubSelect();
            OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis/cells: setup dynamic context");
            scontext.createClusterDynamicContext();
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] axis/cells: setup dynamic category members");
        this.setupDynamicCategoryMembers(scontext);
        OlapInstrExecListener instrExecListener = scontext.getInstrExecListener();
        if (instrExecListener != null) {
            instrExecListener.beginAxes();
        }
        List<OlapTupleSet<OlapTuple>> axesAsSets = null;
        try {
            scontext.onAxisStart();
            OlapSelectAxisExprResult res = this.evaluateAxisExpressions(scontext, scontext.getSlicer(), false);
            if (res.subCubes() != null) {
                throw new RuntimeException("internal error: unexpected sub-cube function in axis");
            }
            axesAsSets = res.axes();
            if (instrExecListener != null) {
                instrExecListener.endAxes();
            }
        }
        catch (RuntimeException ex) {
            if (instrExecListener != null) {
                instrExecListener.endAxesOnError(ex);
            }
            throw ex;
        }
        return axesAsSets;
    }

    private OlapResSelectStatementDataSet unsafeEvaluateCells(OlapSelectStatementExecutionContext scontext, OlapMdxExecutionPermit permit, List<OlapTupleSet<OlapTuple>> axesAsSets) {
        OlapResCellData cells;
        OlapResAxis[] axes = new OlapResAxis[this.axisInstrs.length];
        OlapInstrExecListener instrExecListener = scontext.getInstrExecListener();
        if (instrExecListener != null) {
            instrExecListener.beginCellsEval();
        }
        if (axesAsSets.size() == 0) {
            cells = this.evaluateCellDataForNoAxis(scontext, permit);
        } else {
            OlapTupleSet[] _axesAsSets = axesAsSets.toArray(new OlapTupleSet[axesAsSets.size()]);
            cells = this.evaluateCellData(scontext, permit, _axesAsSets, axes);
        }
        if (instrExecListener != null) {
            instrExecListener.endCellsEval();
        }
        List<OlapMember> defaultMembers = this.setupXmlaDefaultMembers(scontext, axes);
        Date cubeLastUpdate = scontext.getCube().getLastDataUpdatedTime();
        List<OlapMember> initialMembers = this.evaluateInitialSelection(scontext, axes);
        OlapResSelectStatementDataSet selection = new OlapResSelectStatementDataSet(scontext, this.getLocationRange().mdx(), this.queryInfo, this.cubeName, cubeLastUpdate, axes, scontext.getSlicer(), defaultMembers, initialMembers, cells);
        return selection;
    }

    private OlapResCellData evaluateCellDataForNoAxis(OlapSelectStatementExecutionContext context, OlapMdxExecutionPermit permit) throws OlapMdxEvaluationCancelled {
        OlapFactsCellDataEvaluatorForNoAxis evaluator = new OlapFactsCellDataEvaluatorForNoAxis(permit, this, this.cellProperties);
        int[] Si = new int[]{0};
        boolean ordinal = false;
        OlapEvalResultCellValue cellValue = evaluator.evaluateCellValue(context, new OlapEvalResultSi(Si));
        OlapResCell cell = null;
        if (cellValue != null && !cellValue.isEmpty()) {
            cell = this.createCell(context, 0, Si, new OlapEvalResultSi(Si), cellValue);
        } else {
            cell = this.createEmptyCell(context, 0, Si, new OlapEvalResultSi(Si));
            cell.attachCellMeasure(cellValue);
        }
        OlapResCell[] cells = new OlapResCell[]{cell};
        CdXmlaCellOrdinalHelper ordinals = new CdXmlaCellOrdinalHelper(new int[0]);
        return new OlapResCellData(this.cellProperties, ordinals, cells);
    }

    private OlapResCellData evaluateCellData(OlapSelectStatementExecutionContext context, OlapMdxExecutionPermit permit, OlapTupleSet<OlapTuple>[] axesAsSets, OlapResAxis[] axes) throws OlapMdxEvaluationCancelled {
        OlapFactsCellDataEvaluator evaluator = new OlapFactsCellDataEvaluator(permit, this, this.hasNonEmpties(this.axisInstrs), this.cellProperties, this.isEvalOrdinalOnly);
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] evaluate cell-values");
        OlapEvalResult cellValues = evaluator.evaluateCellValues(context, axesAsSets);
        OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] compute axes-content [" + cellValues.tupleCount() + "][" + cellValues.cellCount() + "]"));
        OlapEvalResult.Axes axesContent = cellValues.computeAxesContent();
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] setup res-axes");
        this.setupResAxes(context, axes, axesContent);
        if (cellValues.isEmpty()) {
            return OlapResCellData.EMPTY;
        }
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] generate cell-data");
        return this.generateCellData(context, cellValues, axesContent);
    }

    @Nullable
    private List<OlapMember> evaluateInitialSelection(OlapSelectStatementExecutionContext context, OlapResAxis[] axes) {
        try {
            if (this.initialSelection == null || this.initialSelection.length == 0 || axes.length != 1) {
                return null;
            }
            OlapResAxis axis = axes[0];
            if (axis.getTupleCount() == 0 || axis.getHierarchyCount() != 1) {
                return null;
            }
            OlapTuple aTuple = axis.getAnyTuple();
            if (aTuple == null || aTuple.getMemberCount() != 1) {
                return null;
            }
            OlapHierarchy hierarchy = aTuple.getMember(0).getHierarchy();
            HashSet<OlapMember> members = new HashSet<OlapMember>();
            OlapNameContext nameContext = context.getNameContext();
            IOlapDimensionsPermission permissions = context.getDimensionsPermissions();
            OlapSubSelectCube subSelect = context.getSubSelectCube();
            for (String selection : this.initialSelection) {
                OlapEntityIdentifier id = new OlapEntityIdentifier(selection);
                OlapNonScalarEntity entity = hierarchy.lookupEntityByMdxIdentifier(nameContext, permissions, id);
                if (entity.isFilteredOut() || !(entity instanceof OlapMember)) continue;
                OlapMember member = (OlapMember)entity;
                if (subSelect != null && !subSelect.isAcceptingMember(member)) continue;
                members.add(member);
            }
            return new ArrayList<OlapMember>(members);
        }
        catch (RuntimeException ignored) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] initial-selection error", (Throwable)ignored);
            return null;
        }
    }

    private OlapResStatementDataSet unsafeEvaluateCellsT(OlapSelectStatementExecutionContext sContext, OlapMdxExecutionPermit permit, List<OlapTupleSet<OlapTuple>> axesAsSets) {
        OlapInstrExecListener instrExecListener = sContext.getInstrExecListener();
        if (instrExecListener != null) {
            instrExecListener.beginCellsEval();
        }
        OlapResMdxTidyTable tidy = axesAsSets.size() == 0 ? this.evaluateCellDataForNoAxisT(sContext, permit) : this.evaluateCellDataT(sContext, permit, axesAsSets.toArray(new OlapTupleSet[axesAsSets.size()]));
        if (instrExecListener != null) {
            if (instrExecListener instanceof OlapMdxDebugNodeCollector) {
                OlapMdxDebugNodeCollector debugger = (OlapMdxDebugNodeCollector)instrExecListener;
                debugger.createCells(tidy);
            }
            instrExecListener.endCellsEval();
        }
        tidy.evaluateInitialSelection(this.initialSelection);
        OlapPostProcessedMdxResult postProcessedTidy = this.performTidyPostProcessing(sContext, tidy);
        if (postProcessedTidy != null) {
            return new OlapResSelectStatementDataSetTpp(tidy.getContext(), postProcessedTidy, this.getLocationRange().mdx());
        }
        return new OlapResSelectStatementDataSetT(tidy, this.getLocationRange().mdx());
    }

    @Nullable
    private OlapPostProcessedMdxResult performTidyPostProcessing(OlapSelectStatementExecutionContext sContext, OlapResMdxTidyTable tidy) {
        if (this.tidyPostProcessors == null || this.tidyPostProcessors.isEmpty()) {
            return null;
        }
        OlapPostProcessedMdxResult postProcessed = new OlapPostProcessedMdxResult(tidy);
        OlapResMdxTidyTable mdxResult = tidy;
        OlapResTidyTable prev = mdxResult;
        for (int pp = 0; pp < this.tidyPostProcessors.size(); ++pp) {
            OlapTidyPostProcessorInstr tidyPostProcessor = this.tidyPostProcessors.get(pp);
            if (tidyPostProcessor.isMdxResult()) {
                prev = tidyPostProcessor.postProcess(sContext, mdxResult);
            } else {
                OlapResMdxTidyMaterializedTableCellError cellOnError = prev.getErrorInCells();
                if (!tidyPostProcessor.canHandleCellOnError() && cellOnError != null) {
                    String code = cellOnError.getErrorCode();
                    String description = cellOnError.getErrorDescription();
                    throw tidyPostProcessor.createError(OlapErrorCode.TIDY_POST_PROCESSOR_NO_CELL_ON_ERROR, new Serializable[]{Integer.valueOf(tidyPostProcessor.getStep()), tidyPostProcessor.getName(), code, description});
                }
                if (!tidyPostProcessor.canHandleTruncatedResult() && prev.isTidyMaxRowCountReached()) {
                    throw tidyPostProcessor.createError(OlapErrorCode.TIDY_POST_PROCESSOR_NO_MAX_ROW_COUNT_REACHED, Integer.valueOf(tidyPostProcessor.getStep()), tidyPostProcessor.getName());
                }
                if (!tidyPostProcessor.canHandlePaging() && prev.isWithPaging()) {
                    throw tidyPostProcessor.createError(OlapErrorCode.TIDY_POST_PROCESSOR_NO_PAGING, Integer.valueOf(tidyPostProcessor.getStep()), tidyPostProcessor.getName());
                }
                prev = tidyPostProcessor.postProcess(sContext, prev);
            }
            if (!tidyPostProcessor.isAddToResult() && pp != this.tidyPostProcessors.size() - 1) continue;
            postProcessed.addToResult(tidyPostProcessor.getStep(), prev);
        }
        return postProcessed;
    }

    private OlapResMdxTidyTable evaluateCellDataForNoAxisT(OlapSelectStatementExecutionContext context, OlapMdxExecutionPermit permit) throws OlapMdxEvaluationCancelled {
        boolean withCellValue = false;
        boolean withFormattedValue = false;
        for (OlapCellProperty cellProperty : this.cellProperties) {
            if (cellProperty.isValue()) {
                withCellValue = true;
                continue;
            }
            if (!cellProperty.isFormattedValue()) continue;
            withFormattedValue = true;
        }
        int tidyMaxRowCount = context.getTidyMaxRowCount();
        int tidyMaxColumnCount = context.getTidyMaxColumnCount();
        int tidyMaxCellCount = context.getTidyMaxCellCount();
        int tidyMaxCellCountNE = context.getTidyMaxCellCountNE();
        OlapResMdxTidyTable result = new OlapResMdxTidyTable(context, tidyMaxRowCount, tidyMaxColumnCount, tidyMaxCellCount, tidyMaxCellCountNE, this, this.axisInstrs, this.cubeName, this.cellProperties, this.isEvalOrdinalOnly);
        if (withCellValue || withFormattedValue) {
            OlapMember cellMeasure;
            OlapResCellData cells = this.evaluateCellDataForNoAxis(context, permit);
            OlapResCell cell = cells.getCell(0);
            OlapEvalResultCellValue cellMeasureV = cell.getAttachedCellMeasure();
            OlapMember olapMember = cellMeasure = cellMeasureV != null ? cellMeasureV.getAttachedCellMeasure() : null;
            if (cellMeasure != null) {
                List<OlapTuple> axis0 = Collections.singletonList(cellMeasure);
                result.init(axis0, null);
                OlapTuple[] cellTuple = new OlapTuple[]{cellMeasure};
                OlapEvalResultCellValue cellValue = cellMeasureV;
                result.addCellValue((IOlapEvaluationExceptionContext)context, 0, cellTuple, cellValue);
                result.onEvaluateCellValuesDone(false, 0);
            }
        }
        return result;
    }

    private OlapResMdxTidyTable evaluateCellDataT(OlapSelectStatementExecutionContext context, OlapMdxExecutionPermit permit, OlapTupleSet<OlapTuple>[] axesAsSets) throws OlapMdxEvaluationCancelled {
        OlapFactsCellDataEvaluator evaluator = new OlapFactsCellDataEvaluator(permit, this, this.hasNonEmpties(this.axisInstrs), this.cellProperties, this.isEvalOrdinalOnly);
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] evaluate cell-data [tidy]");
        OlapResMdxTidyTable cellValues = evaluator.evaluateCellValuesT(context, this.axisInstrs, axesAsSets, this.cubeName);
        OlapLoggers.MDX_EVALUATION.debug((Object)"[mdx] evaluate cell-data [tidy] done");
        return cellValues;
    }

    private boolean[] hasNonEmpties(OlapAxisInstr[] axisInstrs) {
        boolean[] isNonEmpty = new boolean[axisInstrs.length];
        for (int idx = 0; idx < axisInstrs.length; ++idx) {
            isNonEmpty[idx] = axisInstrs[idx].hasNonEmptyKeyword();
        }
        return isNonEmpty;
    }

    private void setupResAxes(OlapMdxStatementExecutionContext context, OlapResAxis[] axes, OlapEvalResult.Axes axesContent) {
        for (int idx = 0; idx < axes.length; ++idx) {
            OlapAxisInstr axisInstr = this.axisInstrs[idx];
            List<OlapTuple> axis = axesContent.getAxis(idx);
            axes[idx] = this.setupResAxis(context, axisInstr, axis);
        }
    }

    private OlapResAxis setupResAxis(OlapMdxStatementExecutionContext context, OlapAxisInstr axisInstr, List<OlapTuple> tuples) {
        OlapTopLevelAxisEvaluationContext axisEvalContext = new OlapTopLevelAxisEvaluationContext(context, axisInstr);
        List<OlapResScopedDimensionProperty> properties = OlapTopLevelSelectInstr.extractRequestedMemberProperties(axisEvalContext, axisInstr);
        if (context.isReportingMF()) {
            OlapMemberFilter memberFilter = context.getSchemaPermissionsDimensionFilter();
            HashSet<OlapUserDefinedMemberProperty> walkedProperties = new HashSet<OlapUserDefinedMemberProperty>();
            for (OlapResScopedDimensionProperty property : properties) {
                walkedProperties.addAll(property.getUserDefinedProperties());
            }
            HashSet<OlapLevel> walkedLevels = new HashSet<OlapLevel>();
            for (OlapTuple tuple : tuples) {
                int mc = tuple.getMemberCount();
                for (int mm = 0; mm < mc; ++mm) {
                    OlapMember member = tuple.getMember(mm);
                    OlapLevel level = member.getLevel();
                    if (walkedLevels.contains(level)) continue;
                    walkedLevels.add(level);
                    List<OlapUserDefinedMemberProperty> props = level.getMemberProperties(memberFilter);
                    for (OlapUserDefinedMemberProperty prop : props) {
                        if (walkedProperties.contains(prop)) continue;
                        walkedProperties.add(prop);
                        if (!prop.isUserDefined() || !prop.isAutoExportedToReportingMF()) continue;
                        properties.add(new OlapResUserDefinedScopedDimensionProperty(prop, (OlapNameIdentifiableEntity)level));
                    }
                }
            }
        }
        Map<OlapMember, OlapMemberPropertyValues> propertyValues = OlapTopLevelSelectInstr.evaluateRequestedMemberProperties(context.getMemberPropertyEvalContext(), properties, tuples);
        return new OlapResAxis(axisInstr.getName(), axisInstr.hasNonEmptyKeyword(), tuples, properties, propertyValues);
    }

    public static List<OlapResScopedDimensionProperty> extractRequestedMemberProperties(OlapAxisEvaluationContext context, OlapAxisInstr axisInstr) {
        ArrayList<OlapResScopedDimensionProperty> dimensionProperties = new ArrayList<OlapResScopedDimensionProperty>();
        List<OlapEntityIdentifier> propertyIds = axisInstr.getDimProperties();
        for (OlapEntityIdentifier propertyId : propertyIds) {
            String propertyName = OlapTopLevelSelectInstr.extractPropertyName(propertyId);
            OlapEntityIdentifier propertyScope = OlapTopLevelSelectInstr.extractPropertyScope(propertyId);
            if (propertyScope == null) {
                OlapMemberPropertyManager propertyManager = context.getMemberPropertyManager();
                OlapIntrinsicMemberProperty property = propertyManager.getIntrinsicProperty(propertyName);
                if (property == null) {
                    throw new OlapEvaluationException(context, OlapErrorCode.MEMBER_PROPERTY_UNKNOWN, new Serializable[]{propertyName});
                }
                if (property.isContextSensitive() && !property.isKEYx()) {
                    throw new OlapEvaluationException(context, OlapErrorCode.MEMBER_PROPERTY_CONTEXT_SENSITIVE, new Serializable[]{propertyName});
                }
                dimensionProperties.add(new OlapResIntrinsicScopedDimensionProperty(property, null));
                continue;
            }
            OlapNonScalarEntity entity = context.lookupEntityByMdxIdentifier(context.getNameContext(), OlapMdxEntityLookupKinds.ALL_BUT_SET, propertyScope);
            if (entity.isMdxNull()) {
                throw new OlapEvaluationException(context, OlapErrorCode.MEMBER_PROPERTY_UNKNOWN_CONTEXT, new Serializable[]{propertyName, propertyScope.asString()});
            }
            if (entity.isFilteredOut()) continue;
            OlapMemberPropertyManager propertyManager = context.getMemberPropertyManager();
            OlapIntrinsicMemberProperty intrinsicProperty = propertyManager.getIntrinsicProperty(propertyName);
            if (intrinsicProperty != null) {
                if (entity instanceof OlapMember || entity instanceof OlapLevel || entity instanceof OlapHierarchy || entity instanceof OlapDimension) {
                    if (!intrinsicProperty.isContextSensitive()) {
                        // empty if block
                    }
                    dimensionProperties.add(new OlapResIntrinsicScopedDimensionProperty(intrinsicProperty, (OlapNameIdentifiableEntity)((Object)entity)));
                    continue;
                }
                throw new OlapEvaluationException(context, OlapErrorCode.MEMBER_PROPERTY_CONTEXT_TYPE_MISMATCH, new Serializable[]{propertyName, propertyScope.asString()});
            }
            if (entity instanceof OlapLevel) {
                OlapLevel level = (OlapLevel)entity;
                OlapUserDefinedMemberProperty property = propertyManager.getUserDefinedProperty(level, propertyName);
                if (property != null) {
                    dimensionProperties.add(new OlapResUserDefinedScopedDimensionProperty(property, (OlapNameIdentifiableEntity)level));
                    continue;
                }
                throw new OlapEvaluationException(context, OlapErrorCode.MEMBER_PROPERTY_UNKNOWN_X, new Serializable[]{propertyName, propertyScope.asString()});
            }
            if (entity instanceof OlapHierarchy) {
                OlapHierarchy hierarchy = (OlapHierarchy)entity;
                IOlapHierarchyPermission permissions = context.getHierarchyPermissions(hierarchy);
                List<OlapUserDefinedMemberProperty> properties = propertyManager.getUserDefinedProperties(permissions, hierarchy, propertyName);
                if (properties != null && !properties.isEmpty()) {
                    dimensionProperties.add(new OlapResUserDefinedScopedDimensionProperty(properties, (OlapNameIdentifiableEntity)hierarchy));
                    continue;
                }
                throw new OlapEvaluationException(context, OlapErrorCode.MEMBER_PROPERTY_UNKNOWN_X, new Serializable[]{propertyName, propertyScope.asString()});
            }
            throw new OlapEvaluationException(context, OlapErrorCode.MEMBER_PROPERTY_UNKNOWN_X, new Serializable[]{propertyName, propertyScope.asString()});
        }
        return dimensionProperties;
    }

    private OlapResCellData generateCellData(OlapSelectStatementExecutionContext context, OlapEvalResult cellValues, OlapEvalResult.Axes axesContent) {
        CdXmlaCellOrdinalHelper ordinals = axesContent.getOrdinals();
        OlapResCell[] cells = new OlapResCell[ordinals.getCellCount()];
        cellValues.processValues(context, (Si, value) -> {
            int[] newSi = axesContent.convert(Si.getSi());
            int newOrdinal = ordinals.computeCellOrdinal(newSi);
            cells[newOrdinal] = this.createCell(context, newOrdinal, newSi, Si, value);
        });
        if (cells.length > 0) {
            OlapIterable[] tupleSets = new OlapIterable[ordinals.getUk().length];
            for (int idx = 0; idx < tupleSets.length; ++idx) {
                tupleSets[idx] = OlapTopLevelSelectInstr.integers(ordinals.getUk()[idx]);
            }
            int[] Si2 = new int[tupleSets.length];
            OlapCombinationIterator<Integer> tupleCombinations = new OlapCombinationIterator<Integer>(Integer.class, tupleSets, Si2);
            tupleCombinations.reset();
            while (tupleCombinations.next() != null) {
                int ordinal = ordinals.computeCellOrdinal(Si2);
                if (cells[ordinal] != null) continue;
                OlapInstrExecListener instrExecListener = context.getInstrExecListener();
                OlapEvalResultSi reverseSi = instrExecListener != null ? new OlapEvalResultSi(axesContent.reverseConvert(Si2)) : null;
                cells[ordinal] = this.createEmptyCell(context, ordinal, Si2, reverseSi);
            }
        }
        return new OlapResCellData(this.cellProperties, ordinals, cells);
    }

    private OlapResCell createEmptyCell(OlapSelectStatementExecutionContext context, int ordinal, int[] Si, @Nullable OlapEvalResultSi reverseSi) {
        OlapEmptyEntity scalarCellValue = OlapEmptyEntity.INSTANCE;
        OlapScalarEntity[] propertyValues = new OlapScalarEntity[this.cellProperties.size()];
        for (int idx = 0; idx < this.cellProperties.size(); ++idx) {
            OlapCellProperty property = this.cellProperties.get(idx);
            if (!property.isValue()) continue;
            propertyValues[idx] = scalarCellValue;
        }
        OlapEvalResultCellScalarValue cellValue = new OlapEvalResultCellScalarValue(new OlapEvalResultSi(Si), scalarCellValue);
        ((OlapEvalResultCellValue)cellValue).setCellPropertyValues(propertyValues);
        return this.createCell(context, ordinal, Si, reverseSi, cellValue);
    }

    protected OlapResCell createCell(OlapSelectStatementExecutionContext context, int ordinal, int[] Si, @Nullable OlapEvalResultSi reverseSi, OlapEvalResultCellValue cellValue) {
        OlapScalarEntity scalar;
        OlapException error = cellValue.getError();
        OlapResCell cell = error == null ? ((scalar = cellValue.getScalarValue()) == null || scalar.isMdxNull() ? new OlapResEmptyCell(ordinal, this.cellProperties, cellValue.getCellPropertyValues()) : new OlapResRegularCell(ordinal, this.cellProperties, cellValue.getCellPropertyValues())) : new OlapResErrorCell(ordinal, error, this.cellProperties, cellValue.getCellPropertyValues());
        OlapInstrExecListener instrExecListener = context.getInstrExecListener();
        if (instrExecListener != null) {
            instrExecListener.createCell(Si, ordinal, cell, reverseSi, cellValue);
        }
        cell.attachCellMeasure(cellValue);
        return cell;
    }

    private boolean isWithEmpty() {
        return false;
    }

    private void setupSetDeclarations(OlapSelectStatementExecutionContext scontext) {
        for (OlapCreateSetSelectInstr instr : this.namedSetInstrs) {
            instr.execute(scontext);
        }
    }

    private void setupDeclaredFunctions(OlapSelectStatementExecutionContext context) {
        for (OlapCreateFunctionSelectInstr instr : this.declaredFunctions) {
            instr.execute(context);
        }
    }

    private void setupCalculatedMembers(OlapSelectStatementExecutionContext context) {
        OlapCreateCalcMemberEvaluationContext ccontext = new OlapCreateCalcMemberEvaluationContext(context, false);
        for (OlapCreateCalcMemberSelectInstr instr : this.calcMemberInstrs) {
            instr.execute(ccontext);
        }
    }

    private void setupMeasures(OlapSelectStatementExecutionContext context) {
        OlapCreateMeasureEvaluationContext ccontext = new OlapCreateMeasureEvaluationContext(context);
        for (OlapCreateMeasureSelectInstr instr : this.measureInstrs) {
            instr.execute(ccontext);
        }
    }

    private void setupCategoryHierarchies(OlapSelectStatementExecutionContext context) {
        OlapCreateCategoryHierarchyEvaluationContext ccontext = new OlapCreateCategoryHierarchyEvaluationContext(context);
        for (OlapCreateCategoryHierarchySelectInstr instr : this.categoryHierarchyInstrs) {
            instr.execute(ccontext);
        }
    }

    private void setupStaticCategoryMembers(OlapSelectStatementExecutionContext context) {
        OlapCreateCategoryMemberEvaluationContext ccontext = new OlapCreateCategoryMemberEvaluationContext(context);
        for (int idx = 0; idx < this.categoryMemberInstrs.length; ++idx) {
            OlapCreateCategoryMemberSelectInstr instr = this.categoryMemberInstrs[idx];
            OlapCategoryMember member = (OlapCategoryMember)instr.execute(ccontext);
            if (!instr.isDynamicEvaluation()) continue;
            if (member.hasLogic()) {
                throw new RuntimeException("internal error : inconsistent DYNAMIC category member");
            }
            this.dynamicCategoryMembers[idx] = member;
        }
    }

    private void setupDynamicCategoryMembers(OlapSelectStatementExecutionContext context) {
        CdArrayList list = new CdArrayList();
        for (int idx = 0; idx < this.categoryMemberInstrs.length; ++idx) {
            OlapCategoryMember member = this.dynamicCategoryMembers[idx];
            if (member == null) continue;
            list.addIfNotPresent((Object)member.getHierarchy());
        }
        this.setupDynamicCategoryMembers(context, null);
        list.forEach(hierarchy -> this.setupDynamicCategoryMembers(context, (OlapHierarchy)hierarchy));
    }

    private void setupDynamicCategoryMembers(OlapSelectStatementExecutionContext context, @Nullable OlapHierarchy hierarchy) {
        OlapCreateCategoryMemberEvaluationContext ccontext = new OlapCreateCategoryMemberEvaluationContext(context);
        for (int idx = 0; idx < this.categoryMemberInstrs.length; ++idx) {
            OlapCreateCategoryMemberSelectInstr instr = this.categoryMemberInstrs[idx];
            OlapCategoryMember member2 = this.dynamicCategoryMembers[idx];
            if (!instr.isDynamicEvaluation() || member2.getHierarchy() != hierarchy) continue;
            try {
                instr.setupDynamicLogic(ccontext, member2);
                continue;
            }
            catch (RuntimeException ex) {
                if (ex instanceof OlapException) {
                    throw ex;
                }
                String mess = "Error on setup dynamic category " + member2.getUniqueName(OlapNameContext.DEFAULT_VALUES) + " : " + ex.getMessage();
                OlapLoggers.MDX_EVALUATION.error((Object)mess, (Throwable)ex);
                throw new OlapEvaluationException(context, OlapErrorCode.CAT_EVAL_ERROR, new Serializable[]{mess});
            }
        }
        Arrays.stream(this.dynamicCategoryMembers).filter(member -> member != null && member.getHierarchy() == hierarchy).sorted((m1, m2) -> {
            int comp = Integer.compare(m1.getHierarchy().getTupleDimensionalityIndex(), m2.getHierarchy().getTupleDimensionalityIndex());
            if (comp != 0) {
                return comp;
            }
            return m1.isOtherCategory() ? (m2.isOtherCategory() ? 0 : 1) : (m2.isOtherCategory() ? -1 : 1);
        }).forEach(member -> member.initRequestDynamicLogic(context));
    }

    private List<OlapMember> setupXmlaDefaultMembers(OlapSelectStatementExecutionContext scontext, OlapResAxis[] axes) {
        OlapResSlicer slicer;
        ArrayList<OlapMember> dmembers = new ArrayList<OlapMember>();
        HashSet<OlapHierarchy> hierarchies = new HashSet<OlapHierarchy>();
        if (axes != null) {
            for (int idx = 0; idx < axes.length; ++idx) {
                OlapResAxis axis = axes[idx];
                if (axis == null) continue;
                OlapTopLevelSelectInstr.getHierarchies(hierarchies, axis.getAnyTuple());
            }
        }
        if ((slicer = scontext.getSlicer()) != null) {
            OlapTopLevelSelectInstr.getHierarchies(hierarchies, slicer.getAnyTuple());
        }
        List<OlapDimension> cubeDimensions = scontext.getCubeDimensions();
        for (OlapDimension dimension : cubeDimensions) {
            for (OlapHierarchy hierarchy : dimension.getHierarchies(scontext.getDimensionsPermissions())) {
                OlapMemberFilter perms;
                OlapMember defaultMember;
                if (hierarchies.contains(hierarchy) || (defaultMember = hierarchy.getNullableDefaultMember(perms = scontext.getSchemaPermissionsDimensionFilter())) == null) continue;
                dmembers.add(defaultMember);
            }
        }
        return dmembers;
    }

    @Override
    public boolean isWorthProfiling() {
        return true;
    }

    @Override
    public String toStringForDebugger() {
        return "Root";
    }
}

