/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.olap.entity.result.OlapResSubSelect;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapBaseSubSelectInstr;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import org.jetbrains.annotations.Nullable;

public class OlapSubSelectInstr
extends OlapBaseSubSelectInstr {
    private final String cubeName;
    private final OlapIdentifierInstr cubeIdentifier;

    public OlapSubSelectInstr(MdxAnnotation[] annotations, OlapInstrLocationRange range, OlapIdentifierInstr cube, boolean isNonVisual, OlapAxisInstr[] axisInstrs, @Nullable OlapSlicerInstr slicerInstr) {
        super(annotations, range, axisInstrs, slicerInstr, isNonVisual);
        this.cubeIdentifier = cube;
        this.cubeName = cube.getId().getLastPartAsName();
        this.cubeIdentifier.setParent(this);
    }

    @Override
    public String typeForError() {
        return "SUB-SELECT";
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.cubeIdentifier.accept(v);
            for (OlapAxisInstr axisInstr : this.axisInstrs) {
                axisInstr.accept(v);
            }
            if (this.slicerInstr != null) {
                this.slicerInstr.accept(v);
            }
        }
    }

    protected OlapResSubSelect doExecute(OlapSelectStatementExecutionContext context) {
        return this.executeSubSelect(context);
    }

    @Override
    public String toStringForDebugger() {
        return "Sub-Select";
    }
}

