/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.exception.OlapError;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.result.slicer.OlapResSlicer;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.subcube.OlapSubCubeEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRanges;
import crazydev.iccube.olap.eval.select.OlapAxisInstr;
import crazydev.iccube.olap.eval.select.OlapMdxStatementInstr;
import crazydev.iccube.olap.eval.select.OlapSelectAxisExprResult;
import crazydev.iccube.olap.eval.select.OlapSlicerInstr;
import crazydev.iccube.olap.eval.select.context.OlapAxisEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSlicerEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapSubSelectAxisEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapTopLevelAxisEvaluationContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapSelectInstr
extends OlapMdxStatementInstr<OlapSelectStatementExecutionContext> {
    protected final OlapAxisInstr[] axisInstrs;
    @Nullable
    protected final OlapSlicerInstr slicerInstr;
    private final MdxAnnotation[] annotations;

    protected OlapSelectInstr(MdxAnnotation[] annotations, OlapInstrLocationRange range, OlapAxisInstr[] axisInstrs, @Nullable OlapSlicerInstr slicerInstr) {
        super(range);
        this.annotations = annotations;
        for (OlapAxisInstr instr : this.axisInstrs = axisInstrs) {
            instr.setParent(this);
        }
        this.slicerInstr = slicerInstr;
        if (this.slicerInstr != null) {
            this.slicerInstr.setParent(this);
        }
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    public abstract String getCubeName();

    @Override
    public MdxAnnotation[] getAnnotations() {
        return this.annotations;
    }

    public OlapAxisInstr[] getAxisInstrs() {
        return this.axisInstrs;
    }

    public boolean isOnAxes() {
        if (this.axisInstrs != null) {
            for (OlapAxisInstr axisInstr : this.axisInstrs) {
                if (!axisInstr.isAxes()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public OlapSlicerInstr getSlicerInstr() {
        return this.slicerInstr;
    }

    protected OlapSelectAxisExprResult evaluateAxisExpressions(OlapSelectStatementExecutionContext sContext, @Nullable OlapResSlicer slicer, boolean isInSubQuery) {
        ArrayList<OlapTupleSet<OlapTuple>> axesAsSets = new ArrayList<OlapTupleSet<OlapTuple>>();
        ArrayList<OlapSubCubeEntity> subCubes = new ArrayList<OlapSubCubeEntity>();
        for (int idx = 0; idx < this.axisInstrs.length; ++idx) {
            OlapAxisInstr axisInstr = this.axisInstrs[idx];
            OlapAxisEvaluationContext axisEvaluationContext = !isInSubQuery ? new OlapTopLevelAxisEvaluationContext((OlapMdxStatementExecutionContext)sContext, axisInstr) : new OlapSubSelectAxisEvaluationContext((OlapMdxStatementExecutionContext)sContext, slicer, axisInstr);
            long startMS = System.currentTimeMillis();
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] " + (isInSubQuery ? "(sub-query) " : "") + "axis(" + idx + ") (instr) started"));
            OlapEntity axisAsEntity = axisInstr.execute(axisEvaluationContext);
            OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] " + (isInSubQuery ? "(sub-query) " : "") + "axis(" + idx + ") (instr) completed in " + CdTimeUtils.formatMillisEx((long)startMS)));
            if (axisAsEntity instanceof OlapSubCubeEntity) {
                OlapSubCubeEntity sce = (OlapSubCubeEntity)axisAsEntity;
                subCubes.add(sce);
            } else if (axisAsEntity.isMdxNull()) {
                axesAsSets.add(OlapSetFactory.empty());
            } else {
                OlapTupleSet mySet = (OlapTupleSet)axisAsEntity;
                if (mySet.isNeutralElement()) continue;
                if (isInSubQuery) {
                    long size = mySet.fastEstimatedSize();
                    OlapLoggers.MDX_EVALUATION.debug((Object)("[mdx] (sub-query) axis(" + idx + ") (instr) size: " + size));
                    OlapIterator mySetIterator = mySet.getIterator(false);
                    mySetIterator.reset();
                    OlapTuple firstTuple = (OlapTuple)mySetIterator.next();
                    if (firstTuple == null) {
                        axesAsSets.add(OlapSetFactory.empty());
                        continue;
                    }
                    if (firstTuple.isAll()) continue;
                }
                axesAsSets.add(mySet);
            }
            if (isInSubQuery) continue;
            sContext.addAxis((OlapTupleSet)axesAsSets.get(idx));
        }
        int axisWithMeasures = -1;
        for (int ii = 0; ii < axesAsSets.size(); ++ii) {
            OlapHierarchy measuresHierarchy;
            OlapTupleSet axisAsSet = (OlapTupleSet)axesAsSets.get(ii);
            OlapTupleDimensionality dimensionality = axisAsSet.getTupleDimensionality();
            if (dimensionality == null || !dimensionality.isIn(measuresHierarchy = sContext.getMeasuresHierarchy())) continue;
            if (axisWithMeasures != -1) {
                OlapInstrLocationRange range = this.axisInstrs[ii].getLocationRange();
                OlapError<OlapInstrLocationRange, OlapErrorCode> error = new OlapError<OlapInstrLocationRange, OlapErrorCode>(range, OlapErrorCode.AXIS_SELECT_MULTIPLE_HIERARCHY, new Serializable[]{"Measures"});
                throw new OlapEvaluationException(error);
            }
            axisWithMeasures = ii;
        }
        return new OlapSelectAxisExprResult(axesAsSets, !subCubes.isEmpty() ? subCubes : null);
    }

    public void assertHierarchyUsage(OlapMdxStatementExecutionContext context, OlapTuple[] anyAxisTuples) {
        if (context.isDimensionalityCheck()) {
            HashMap<OlapHierarchy, List<Integer>> hierarchies = new HashMap<OlapHierarchy, List<Integer>>();
            for (int idx = 0; idx < anyAxisTuples.length; ++idx) {
                OlapTuple anyTuple = anyAxisTuples[idx];
                OlapSelectInstr.setupHierarchyUsage(hierarchies, anyTuple, idx);
            }
            for (Map.Entry entry : hierarchies.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                ArrayList<OlapInstrLocationRange> ranges = new ArrayList<OlapInstrLocationRange>();
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int axisNumber = (Integer)iterator.next();
                    ranges.add(this.axisInstrs[axisNumber].getLocationRange());
                }
                OlapInstrLocationRanges axisRanges = new OlapInstrLocationRanges(this.getLocationRange().mdx(), this.getLocationRange().mdxHash(), ranges);
                OlapError<OlapInstrLocationRanges, OlapErrorCode> error = new OlapError<OlapInstrLocationRanges, OlapErrorCode>(axisRanges, OlapErrorCode.AXIS_SELECT_MULTIPLE_HIERARCHY, new Serializable[]{((OlapHierarchy)entry.getKey()).getUniqueName(context.getNameContext())});
                throw new OlapEvaluationException(error);
            }
        }
    }

    private static void setupHierarchyUsage(Map<OlapHierarchy, List<Integer>> hierarchies, @Nullable OlapTuple anyTuple, int axisNumber) {
        if (anyTuple == null) {
            return;
        }
        for (int idx = 0; idx < anyTuple.getMemberCount(); ++idx) {
            OlapHierarchy hierarchy = anyTuple.getMember(idx).getHierarchy();
            List<Integer> axes = hierarchies.get(hierarchy);
            if (axes == null) {
                axes = new ArrayList<Integer>();
                hierarchies.put(hierarchy, axes);
            }
            axes.add(axisNumber);
        }
    }

    @Nullable
    protected OlapResSlicer evaluateSlicer(OlapSelectStatementExecutionContext scontext, boolean isInSubQuery) {
        if (this.slicerInstr == null) {
            return null;
        }
        OlapSlicerEvaluationContext slicerEvaluationContext = new OlapSlicerEvaluationContext(scontext, isInSubQuery);
        OlapEntity slicerAsEntity = this.slicerInstr.execute(slicerEvaluationContext);
        if (slicerAsEntity.isMdxNull()) {
            throw new OlapEvaluationException(new OlapError<OlapInstrLocationRange, OlapErrorCode>(this.slicerInstr.getLocationRange(), OlapErrorCode.SLICER_NULL_EVAL, new Serializable[0]));
        }
        OlapTupleSet slicerAsSet = (OlapTupleSet)slicerAsEntity;
        if (slicerAsSet.isNeutralElement()) {
            return null;
        }
        OlapResSlicer slicer = OlapResSlicer.create(slicerEvaluationContext, this.slicerInstr, slicerAsSet);
        if (slicer == null) {
            throw new OlapEvaluationException(new OlapError<OlapInstrLocationRange, OlapErrorCode>(this.slicerInstr.getLocationRange(), OlapErrorCode.SLICER_NULL_EVAL, new Serializable[0]));
        }
        slicer.assertConsistency(scontext);
        return slicer;
    }
}

