/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.eval.execinstr.OlapLambdaPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;

public class OlapLambdaInstr
extends OlapExecutedWithPreparedInstr<OlapEvaluationContext> {
    private final OlapFunction function;
    private OlapInstr arg;

    public OlapLambdaInstr(OlapInstrLocationRange range, OlapInstr arg, OlapFunction function) {
        super(range);
        if (arg.isNull()) {
            throw new CdProgrammingException("Inconsistent LambdaInstr usage - use Null Lambda instead!");
        }
        this.function = function;
        this.setupLambda(arg);
    }

    @Override
    public String typeForError() {
        return "LAMBDA";
    }

    private void setupLambda(OlapInstr arg) {
        this.arg = arg;
        this.arg.setParent(this);
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.arg.accept(v);
        }
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapPreparedInstr prepared = this.arg.prepare(context);
        return new OlapLambdaPreparedInstr(this, prepared);
    }

    @Override
    public String toStringForDebugger() {
        return "lambda:" + this.function.getName();
    }

    public String toString() {
        return this.toStringForDebugger();
    }
}

