/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyUtils;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapMdxStatementInstr;
import crazydev.iccube.olap.eval.select.context.OlapEmptyStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapEmptySelectStatementInstr
extends OlapMdxStatementInstr<OlapMdxStatementExecutionContext> {
    public OlapEmptySelectStatementInstr(OlapInstrLocationRange range) {
        super(range);
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    public String typeForError() {
        return "EMPTY SELECT STATEMENT";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        v.visit(this);
    }

    @Override
    protected boolean isEmptyStatement() {
        return true;
    }

    @Override
    protected OlapMdxStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        return new OlapEmptyStatementExecutionContext(requestContext, requestContext.getOlapEngineProperties().override(properties), null, instrExecutionListener, schema);
    }

    @Override
    protected OlapEntity doExecute(OlapMdxStatementExecutionContext context) {
        return OlapResMdxTidyUtils.emptyStatementResult(context);
    }

    @Override
    public String toStringForDebugger() {
        return "Empty SELECT statement";
    }
}

