/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.catmember.OlapCategoryHierarchyProperties;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.eval.catmember.OlapRequestCategoryMemberManager;
import crazydev.iccube.olap.eval.function.OlapExecutedWithoutPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.OlapCreateCategoryHierarchyEvaluationContext;

public class OlapCreateCategoryHierarchySelectInstr
extends OlapExecutedWithoutPreparedInstr<OlapCreateCategoryHierarchyEvaluationContext> {
    private final OlapInstrLocationRange idRange;
    private final OlapEntityIdentifier id;
    private final OlapCategoryHierarchyProperties properties;

    public OlapCreateCategoryHierarchySelectInstr(OlapInstrLocationRange idRange, OlapInstrLocationRange range, OlapEntityIdentifier id, OlapCategoryHierarchyProperties properties) {
        super(range);
        this.idRange = idRange;
        this.id = id;
        this.properties = properties;
    }

    @Override
    public String toStringForDebugger() {
        return "Category Hierarchy : " + this.id.asString();
    }

    @Override
    public String typeForError() {
        return "CATEGORY HIERARCHY";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            // empty if block
        }
    }

    public OlapEntityIdentifier getId() {
        return this.id;
    }

    public OlapCategoryHierarchyProperties getProperties() {
        return this.properties;
    }

    @Override
    protected OlapEntity doExecute(OlapCreateCategoryHierarchyEvaluationContext context) {
        OlapDimension schemaDimension = this.lookupCategoryDimension(context.getStatementExecutionContext(), this.id);
        String hierarchyName = this.getCategoryHierarchyName(context, this.id);
        OlapRequestCategoryMemberManager manager = context.getRequestCategoryMemberManager();
        OlapHierarchy hierarchy = manager.createCategoryMemberHierarchy(context, context.getNameContext(), schemaDimension, hierarchyName, this.properties);
        return hierarchy;
    }
}

