/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.select;

import crazydev.iccube.mdx.parser.ast.select.MdxSelectQueryAxisClause;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.eval.execinstr.OlapAxisPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.function.OlapExecutedWithPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapAxisEvaluationContext;
import java.util.Collections;
import java.util.List;

public class OlapAxisInstr
extends OlapExecutedWithPreparedInstr<OlapAxisEvaluationContext> {
    private final MdxSelectQueryAxisClause mdxEntity;
    private final OlapResAxisName name;
    private final boolean hasNonEmptyKeyword;
    private final List<OlapEntityIdentifier> dimProperties;
    private final boolean allMemberProperties;
    private OlapInstr content;

    public OlapAxisInstr(MdxSelectQueryAxisClause mdxEntity, OlapInstrLocationRange range, OlapResAxisName name, boolean hasNonEmptyKeyword, OlapInstr content, List<OlapEntityIdentifier> dimProperties) {
        super(range);
        this.mdxEntity = mdxEntity;
        this.name = name;
        this.hasNonEmptyKeyword = hasNonEmptyKeyword;
        this.dimProperties = dimProperties;
        this.allMemberProperties = false;
        this.setupContent(content);
    }

    public OlapAxisInstr(MdxSelectQueryAxisClause mdxEntity, OlapInstrLocationRange range, OlapResAxisName name, boolean hasNonEmptyKeyword, OlapInstr content, boolean allMemberProperties) {
        super(range);
        this.mdxEntity = mdxEntity;
        this.name = name;
        this.hasNonEmptyKeyword = hasNonEmptyKeyword;
        this.dimProperties = Collections.emptyList();
        this.allMemberProperties = allMemberProperties;
        this.setupContent(content);
    }

    @Override
    public String typeForError() {
        return "AXIS";
    }

    private void setupContent(OlapInstr instr) {
        this.content = instr;
        this.content.setParent(this);
    }

    public boolean isAxes() {
        return this.name.isAxes();
    }

    public boolean isFromFilterBy() {
        return this.mdxEntity.isFromFilterBy();
    }

    public MdxSelectQueryAxisClause getMdxEntity() {
        return this.mdxEntity;
    }

    public OlapResAxisName getName() {
        return this.name;
    }

    public boolean hasNonEmptyKeyword() {
        return this.hasNonEmptyKeyword;
    }

    public OlapInstr getContent() {
        return this.content;
    }

    public List<OlapEntityIdentifier> getDimProperties() {
        return this.dimProperties;
    }

    public boolean isAllMemberProperties() {
        return this.allMemberProperties;
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.content.accept(v);
        }
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapPreparedInstr pContent = this.content.prepare(context);
        return new OlapAxisPreparedInstr(this, pContent);
    }

    @Override
    public String toStringForDebugger() {
        return "On " + this.name.toString();
    }

    public String toString() {
        return this.name.toString();
    }
}

