/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.scase;

import crazydev.iccube.olap.eval.execinstr.OlapIifPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapOnErrorPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.scase.OlapConditionalInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.loggers.OlapLoggers;

public class OlapIifInstr
extends OlapConditionalInstr {
    protected OlapInstr conditionArg;
    protected OlapInstr thenArg;
    protected OlapInstr elseArg;

    public OlapIifInstr(OlapInstrLocationRange range, OlapInstr conditionArg, OlapInstr thenArg, OlapInstr elseArg) {
        super(range);
        this.setupCondition(conditionArg);
        this.setupThen(thenArg);
        this.setupElse(elseArg);
    }

    @Override
    public String typeForError() {
        return "IIF";
    }

    private void setupCondition(OlapInstr conditionArg) {
        this.conditionArg = conditionArg;
        this.conditionArg.setParent(this);
    }

    private void setupThen(OlapInstr thenArg) {
        this.thenArg = thenArg;
        this.thenArg.setParent(this);
    }

    private void setupElse(OlapInstr elseArg) {
        this.elseArg = elseArg;
        this.elseArg.setParent(this);
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.conditionArg.accept(v);
            this.thenArg.accept(v);
            this.elseArg.accept(v);
        }
    }

    @Override
    public String toStringForDebugger() {
        return "IIF";
    }

    @Override
    protected OlapPreparedInstr doPrepare(IOlapPrepareContext context) {
        OlapOnErrorPreparedInstr<OlapInstr> pElse;
        OlapOnErrorPreparedInstr<OlapInstr> pThen;
        OlapPreparedInstr pCondition = this.conditionArg.prepare(context);
        try {
            pThen = this.thenArg.prepare(context);
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"IIF evaluation: error while preparing the THEN branch", (Throwable)ex);
            pThen = new OlapOnErrorPreparedInstr<OlapInstr>(this.thenArg, ex);
        }
        try {
            pElse = this.elseArg.prepare(context);
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"IIF evaluation: error while preparing the ELSE branch", (Throwable)ex);
            pElse = new OlapOnErrorPreparedInstr<OlapInstr>(this.elseArg, ex);
        }
        return new OlapIifPreparedInstr(this, pCondition, pThen, pElse);
    }
}

