/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.operator.scalar;

import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.entity.scalar.OlapComparableVectorEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapNumericWithUnitEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarMissingOperatorException;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import org.joda.time.ReadablePartial;

public class OlapScalarCompareOperator {
    protected static final Compare INVALID = (ent1, ent2) -> {
        throw new OlapScalarMissingOperatorException("compare", ent1, ent2);
    };

    protected static void register() {
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> 0);
        OlapScalarOperators.register(OlapNumericEntity.class, OlapNumericEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), ent2.value()));
        OlapScalarOperators.register(OlapNumericEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), 0.0));
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapNumericEntity.class, (ent1, ent2) -> Double.compare(0.0, ent2.value()));
        OlapScalarOperators.register(OlapNumericEntity.class, OlapBooleanEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), OlapScalarCompareOperator.toNumeric(ent2)));
        OlapScalarOperators.register(OlapBooleanEntity.class, OlapNumericEntity.class, (ent1, ent2) -> Double.compare(OlapScalarCompareOperator.toNumeric(ent1), ent2.value()));
        OlapScalarOperators.register(OlapNumericWithUnitEntity.class, OlapNumericWithUnitEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), ent2.value()));
        OlapScalarOperators.register(OlapNumericWithUnitEntity.class, OlapNumericEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), ent2.value()));
        OlapScalarOperators.register(OlapNumericEntity.class, OlapNumericWithUnitEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), ent2.value()));
        OlapScalarOperators.register(OlapNumericWithUnitEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), 0.0));
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapNumericWithUnitEntity.class, (ent1, ent2) -> Double.compare(0.0, ent2.value()));
        OlapScalarOperators.register(OlapNumericWithUnitEntity.class, OlapBooleanEntity.class, (ent1, ent2) -> Double.compare(ent1.value(), OlapScalarCompareOperator.toNumeric(ent2)));
        OlapScalarOperators.register(OlapBooleanEntity.class, OlapNumericWithUnitEntity.class, (ent1, ent2) -> Double.compare(OlapScalarCompareOperator.toNumeric(ent1), ent2.value()));
        OlapScalarOperators.register(OlapDateEntity.class, OlapDateEntity.class, (ent1, ent2) -> ent1.value().compareTo((ReadablePartial)ent2.value()));
        OlapScalarOperators.register(OlapDateEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> 1);
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapDateEntity.class, (ent1, ent2) -> -1);
        OlapScalarOperators.register(OlapDateTimeEntity.class, OlapDateTimeEntity.class, (ent1, ent2) -> ent1.value().compareTo((ReadablePartial)ent2.value()));
        OlapScalarOperators.register(OlapDateEntity.class, OlapDateTimeEntity.class, (ent1, ent2) -> ent1.value().compareTo((ReadablePartial)ent2.value().toLocalDate()));
        OlapScalarOperators.register(OlapDateTimeEntity.class, OlapDateEntity.class, (ent1, ent2) -> ent1.value().toLocalDate().compareTo((ReadablePartial)ent2.value()));
        OlapScalarOperators.register(OlapDateTimeEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> 1);
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapDateTimeEntity.class, (ent1, ent2) -> -1);
        OlapScalarOperators.register(OlapDateEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> 1);
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapDateEntity.class, (ent1, ent2) -> -1);
        OlapScalarOperators.register(OlapStringEntity.class, OlapStringEntity.class, (ent1, ent2) -> ent1.value().compareTo(ent2.value()));
        OlapScalarOperators.register(OlapStringEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> 1);
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapStringEntity.class, (ent1, ent2) -> -1);
        OlapScalarOperators.register(OlapBooleanEntity.class, OlapBooleanEntity.class, (a, b) -> Boolean.compare(a.value(), b.value()));
        OlapScalarOperators.register(OlapBooleanEntity.class, OlapEmptyEntity.class, (a, ent2) -> Boolean.compare(a.value(), false));
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapBooleanEntity.class, (ent1, b) -> Boolean.compare(false, b.value()));
        OlapScalarOperators.register(OlapEmptyEntity.class, OlapComparableVectorEntity.class, (ent1, ent2) -> -1);
        OlapScalarOperators.register(OlapComparableVectorEntity.class, OlapEmptyEntity.class, (ent1, ent2) -> 1);
        OlapScalarOperators.register(OlapComparableVectorEntity.class, OlapComparableVectorEntity.class, OlapComparableVectorEntity::compare);
    }

    private static double toNumeric(OlapBooleanEntity ent1) {
        return ent1.value() ? 1.0 : 0.0;
    }

    protected static interface Compare<T extends OlapScalarEntity, P extends OlapScalarEntity> {
        public int compare(T var1, P var2);
    }
}

