/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.operator.common;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.operator.common.OlapBinaryOperatorSyntaxErrorEvaluationException;
import crazydev.iccube.olap.eval.operator.common.OlapOperatorName;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapOperator {
    private final OlapOperatorName name;

    public OlapOperator(OlapOperatorName name) {
        this.name = name;
    }

    public OlapOperatorName getName() {
        return this.name;
    }

    public OlapEntity onOperatorSyntaxError(IOlapEvaluationExceptionContext context, OlapEntity operand) {
        throw new OlapEvaluationException(context, OlapErrorCode.UNARY_OPERATOR_SYNTAX_ERROR, new Serializable[]{this.getName().mdx(), operand.getFriendlyTypeName()});
    }

    public OlapEntity onOperatorSyntaxError(IOlapEvaluationExceptionContext context, OlapEntity left, @Nullable OlapEntity right) {
        String lType = left.getFriendlyTypeName();
        String rType = right != null ? right.getFriendlyTypeName() : "n/a";
        throw new OlapBinaryOperatorSyntaxErrorEvaluationException(context, this.getName().mdx(), lType, rType);
    }

    protected OlapBooleanEntity asBoolean(boolean value) {
        return OlapBooleanEntity.value(value);
    }

    protected OlapBooleanEntity asFalse() {
        return OlapBooleanEntity.FALSE;
    }

    protected OlapBooleanEntity asTrue() {
        return OlapBooleanEntity.TRUE;
    }

    protected OlapEmptyEntity asEmpty() {
        return OlapEmptyEntity.INSTANCE;
    }
}

