/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.operator.binary.ops.range;

import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorFactoryContext;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorOperator;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.operator.binary.OlapBinaryOperator;
import crazydev.iccube.olap.eval.operator.common.OlapOperatorName;
import crazydev.iccube.olap.eval.select.context.OlapNonEmptyBehaviorException;
import java.io.Serializable;

public class OlapRangeOperator
extends OlapBinaryOperator {
    public static final OlapRangeOperator INSTANCE = new OlapRangeOperator();

    private OlapRangeOperator() {
        super(OlapOperatorName.RANGE);
    }

    @Override
    public boolean isPossiblyScalar() {
        return false;
    }

    @Override
    public boolean isAlwaysScalar() {
        return false;
    }

    @Override
    public S_NonEmptyBehavior nonEmptyBehavior(S_NonEmptyBehaviorFactoryContext context, GFNode left, GFNode right) throws OlapNonEmptyBehaviorException {
        return S_NonEmptyBehaviorOperator.range(context, left, right);
    }

    @Override
    protected OlapEntity executeForEntity(GFContext context, GFTupleEvaluator evaluator, OlapEntity left, OlapEntity right) {
        OlapLevel toLevel;
        OlapMember to;
        OlapMember from;
        if (left.isMdxNull()) {
            from = null;
        } else if (left.isToMemberApplicable(context.getPrepareContext())) {
            from = left.toNullableMember(context.getPrepareContext());
        } else {
            return this.onOperatorSyntaxError(context, left, right);
        }
        if (right.isMdxNull()) {
            to = null;
        } else if (right.isToMemberApplicable(context.getPrepareContext())) {
            to = right.toNullableMember(context.getPrepareContext());
        } else {
            return this.onOperatorSyntaxError(context, left, right);
        }
        OlapLevel fromLevel = from == null ? null : from.getLevel();
        OlapLevel olapLevel = toLevel = to == null ? null : to.getLevel();
        if (fromLevel != null && toLevel != null && !fromLevel.equals(toLevel)) {
            throw new OlapEvaluationException(context, OlapErrorCode.RANGE_OPERATOR_MEMBER_LEVEL_MISMATCH, new Serializable[]{ONames.uname4Log(from), ONames.uname4Log(to)});
        }
        return OlapLevel.range(context.getMemberFilter(), from, to);
    }

    @Override
    public OlapEntity executeForNull(GFContext context, GFTupleEvaluator evaluator, OlapEntity left, OlapEntity right) {
        return this.executeForEntity(context, evaluator, left, right);
    }
}

