/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.method;

import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tupleevaluator.GFTupleEvaluator;
import crazydev.iccube.olap.eval.function.OlapCallInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;

public abstract class OlapMethodCallInstr
extends OlapCallInstr {
    private static final OlapScalarEntity[] NO_ARG_EVAL = new OlapScalarEntity[0];
    private final String methodName;

    public OlapMethodCallInstr(OlapInstrLocationRange range, String methodName) {
        super(range);
        this.methodName = methodName;
    }

    public abstract String getModuleName();

    public String getMethodName() {
        return this.methodName;
    }

    public static OlapScalarEntity[] executeArgs(GFContext context, GFTupleEvaluator cache, GFNode[] args) {
        if (args.length == 0) {
            return NO_ARG_EVAL;
        }
        OlapScalarEntity[] params = new OlapScalarEntity[args.length];
        for (int idx = 0; idx < args.length; ++idx) {
            GFNode arg = args[idx];
            OlapScalarEntity val = arg.executeToScalar(context, cache, null);
            params[idx] = val.isMdxNull() ? null : arg.executeToScalar(context, cache, null);
        }
        return params;
    }

    @Override
    public String toStringForDebugger() {
        return this.methodName + "(...)";
    }

    public String toString() {
        return this.methodName;
    }
}

