/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.eval.method;

import crazydev.common.lang.CdMethodParams;
import crazydev.iccube.olap.eval.method.OlapJavaMethod;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class OlapJavaRegularMethod
extends OlapJavaMethod {
    private final Method method;
    private final Class<Object>[] paramTypes;

    public OlapJavaRegularMethod(Method method) throws NoSuchMethodException {
        method.setAccessible(true);
        this.method = method;
        this.paramTypes = method.getParameterTypes();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    @Nullable
    public String getParamName(int pos) {
        try {
            CdMethodParams ann = this.method.getAnnotation(CdMethodParams.class);
            if (ann != null) {
                return ann.value()[pos];
            }
            return null;
        }
        catch (RuntimeException ignored) {
            OlapLoggers.MDX_EVALUATION.warn((Object)"[mdx] could not retrieve the parameter annotation", (Throwable)ignored);
            return null;
        }
    }

    @Override
    public Class<Object>[] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public Object invoke(@Nullable Object obj, Object ... args) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(obj, args);
    }

    @Override
    public String toString() {
        return this.method.toString();
    }
}

